/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.jdbi3.locator;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.google.common.collect.ImmutableMap;
import java.util.Map;

@JsonFormat(shape=JsonFormat.Shape.OBJECT)
public enum ConnectionType {
    MYSQL("com.mysql.cj.jdbc.Driver"),
    POSTGRES("org.postgresql.Driver");

    public final String label;
    private static final Map<String, ConnectionType> labelMap;

    private ConnectionType(String label) {
        this.label = label;
    }

    @JsonCreator
    public static ConnectionType from(String value) {
        try {
            return labelMap.get(value);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(String.format("Cannot create %s from value [%s]", ConnectionType.class.getName(), value), e);
        }
    }

    public String toString() {
        return "ConnectionType{name='" + this.name() + "'driver='" + this.label + "'}";
    }

    static {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (ConnectionType t : ConnectionType.values()) {
            builder.put((Object)t.label, (Object)t);
        }
        labelMap = builder.build();
    }
}

