/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.resources.events;

import io.swagger.annotations.Api;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import javax.validation.Valid;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.UriInfo;
import org.openmetadata.schema.type.ChangeEvent;
import org.openmetadata.service.Entity;
import org.openmetadata.service.jdbi3.ChangeEventRepository;
import org.openmetadata.service.jdbi3.CollectionDAO;
import org.openmetadata.service.resources.Collection;
import org.openmetadata.service.security.Authorizer;
import org.openmetadata.service.util.EntityUtil;
import org.openmetadata.service.util.ResultList;

@Path(value="/v1/events")
@Api(value="Events resource", tags={"events"})
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@Collection(name="events")
public class EventResource {
    private final ChangeEventRepository dao;
    private final Authorizer authorizer;

    public EventResource(CollectionDAO dao, Authorizer authorizer) {
        Objects.requireNonNull(dao, "ChangeEventRepository must not be null");
        this.dao = new ChangeEventRepository(dao);
        this.authorizer = authorizer;
    }

    @GET
    @Valid
    @Operation(operationId="listChangeEvents", summary="Get change events", tags={"events"}, description="Get a list of change events matching event types, entity type, from a given date", responses={@ApiResponse(responseCode="200", description="Entity events", content={@Content(mediaType="application/json", schema=@Schema(implementation=EventList.class))}), @ApiResponse(responseCode="404", description="Entity for instance {id} is not found")})
    public ResultList<ChangeEvent> get(@Context UriInfo uriInfo, @Parameter(description="List of comma separated entities requested for `entityCreated` event. When set to `*` all entities will be returned", schema=@Schema(type="string", example="table,dashboard,...")) @QueryParam(value="entityCreated") String entityCreated, @Parameter(description="List of comma separated entities requested for `entityCreated` event. When set to `*` all entities will be returned", schema=@Schema(type="string", example="table,dashboard,...")) @QueryParam(value="entityUpdated") String entityUpdated, @Parameter(description="List of comma separated entities requested for `entityCreated` event. When set to `*` all entities will be returned", schema=@Schema(type="string", example="table,dashboard,...")) @QueryParam(value="entityDeleted") String entityDeleted, @Parameter(description="Events starting from this unix timestamp in milliseconds", required=true, schema=@Schema(type="long", example="1426349294842")) @QueryParam(value="timestamp") long timestamp) throws IOException {
        List<String> entityCreatedList = Entity.EntityList.getEntityList("entityCreated", entityCreated);
        List<String> entityUpdatedList = Entity.EntityList.getEntityList("entityUpdated", entityUpdated);
        List<String> entityDeletedList = Entity.EntityList.getEntityList("entityDeleted", entityDeleted);
        List<ChangeEvent> events = this.dao.list(timestamp, entityCreatedList, entityUpdatedList, entityDeletedList);
        events.sort(EntityUtil.compareChangeEvent);
        return new EventList(events, null, null, events.size());
    }

    public ChangeEventRepository getDao() {
        return this.dao;
    }

    public static class EventList
    extends ResultList<ChangeEvent> {
        public EventList() {
        }

        public EventList(List<ChangeEvent> data, String beforeCursor, String afterCursor, int total) {
            super(data, beforeCursor, afterCursor, total);
        }
    }
}

