/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.resources.feeds;

import io.swagger.annotations.Api;
import io.swagger.v3.oas.annotations.ExternalDocumentation;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.ExampleObject;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.json.JsonPatch;
import javax.validation.Valid;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.PATCH;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriInfo;
import org.openmetadata.schema.api.CreateTaskDetails;
import org.openmetadata.schema.api.feed.CloseTask;
import org.openmetadata.schema.api.feed.CreatePost;
import org.openmetadata.schema.api.feed.CreateThread;
import org.openmetadata.schema.api.feed.ResolveTask;
import org.openmetadata.schema.api.feed.ThreadCount;
import org.openmetadata.schema.entity.feed.Thread;
import org.openmetadata.schema.entity.teams.User;
import org.openmetadata.schema.type.EntityReference;
import org.openmetadata.schema.type.MetadataOperation;
import org.openmetadata.schema.type.Post;
import org.openmetadata.schema.type.TaskDetails;
import org.openmetadata.schema.type.TaskStatus;
import org.openmetadata.schema.type.ThreadType;
import org.openmetadata.service.Entity;
import org.openmetadata.service.jdbi3.CollectionDAO;
import org.openmetadata.service.jdbi3.FeedRepository;
import org.openmetadata.service.resources.Collection;
import org.openmetadata.service.resources.feeds.MessageParser;
import org.openmetadata.service.security.Authorizer;
import org.openmetadata.service.security.policyevaluator.OperationContext;
import org.openmetadata.service.security.policyevaluator.PostResourceContext;
import org.openmetadata.service.security.policyevaluator.ThreadResourceContext;
import org.openmetadata.service.util.EntityUtil;
import org.openmetadata.service.util.RestUtil;
import org.openmetadata.service.util.ResultList;

@Path(value="/v1/feed")
@Api(value="Feeds collection", tags={"Feeds collection"})
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@Collection(name="feeds")
public class FeedResource {
    public static final String COLLECTION_PATH = "/v1/feed/";
    private final FeedRepository dao;
    private final Authorizer authorizer;

    public static void addHref(UriInfo uriInfo, List<Thread> threads) {
        threads.forEach(t -> FeedResource.addHref(uriInfo, t));
    }

    public static Thread addHref(UriInfo uriInfo, Thread thread) {
        thread.setHref(RestUtil.getHref(uriInfo, COLLECTION_PATH, thread.getId()));
        return thread;
    }

    public FeedResource(CollectionDAO dao, Authorizer authorizer) {
        Objects.requireNonNull(dao, "FeedRepository must not be null");
        this.dao = new FeedRepository(dao);
        this.authorizer = authorizer;
    }

    @GET
    @Operation(operationId="listThreads", summary="List threads", tags={"feeds"}, description="Get a list of threads, optionally filtered by `entityLink`.", responses={@ApiResponse(responseCode="200", description="List of threads", content={@Content(mediaType="application/json", schema=@Schema(implementation=ThreadList.class))})})
    public ResultList<Thread> list(@Context UriInfo uriInfo, @Parameter(description="Limit the number of posts sorted by chronological order (1 to 1000000, default = 3)", schema=@Schema(type="integer")) @Min(value=0L) @Max(value=1000000L) @DefaultValue(value="3") @QueryParam(value="limitPosts") @Min(value=0L) @Max(value=1000000L) int limitPosts, @Parameter(description="Limit the number of threads returned. (1 to 1000000, default = 10)") @DefaultValue(value="10") @Min(value=1L) @Max(value=1000000L) @QueryParam(value="limit") @Min(value=1L) @Max(value=1000000L) int limitParam, @Parameter(description="Returns list of threads before this cursor", schema=@Schema(type="string")) @QueryParam(value="before") String before, @Parameter(description="Returns list of threads after this cursor", schema=@Schema(type="string")) @QueryParam(value="after") String after, @Parameter(description="Filter threads by entity link", schema=@Schema(type="string", example="<E#/{entityType}/{entityFQN}/{fieldName}>")) @QueryParam(value="entityLink") String entityLink, @Parameter(description="Filter threads by user id. This filter requires a 'filterType' query param. The default filter type is 'OWNER'. This filter cannot be combined with the entityLink filter.", schema=@Schema(type="string")) @QueryParam(value="userId") String userId, @Parameter(description="Filter type definition for the user filter. It can take one of 'OWNER', 'FOLLOWS', 'MENTIONS'. This must be used with the 'user' query param", schema=@Schema(implementation=FeedRepository.FilterType.class)) @QueryParam(value="filterType") FeedRepository.FilterType filterType, @Parameter(description="Filter threads by whether they are resolved or not. By default resolved is false") @DefaultValue(value="false") @QueryParam(value="resolved") boolean resolved, @Parameter(description="The type of thread to filter the results. It can take one of 'Conversation', 'Task', 'Announcement'", schema=@Schema(implementation=ThreadType.class)) @QueryParam(value="type") ThreadType threadType, @Parameter(description="The status of tasks to filter the results. It can take one of 'Open', 'Closed'. This filter will take effect only when type is set to Task", schema=@Schema(implementation=TaskStatus.class)) @QueryParam(value="taskStatus") TaskStatus taskStatus, @Parameter(description="Whether to filter results by announcements that are currently active. This filter will take effect only when type is set to Announcement", schema=@Schema(type="boolean")) @QueryParam(value="activeAnnouncement") Boolean activeAnnouncement) throws IOException {
        RestUtil.validateCursors(before, after);
        ResultList<Thread> threads = before != null ? this.dao.list(entityLink, limitPosts, userId, filterType, limitParam, before, resolved, FeedRepository.PaginationType.BEFORE, threadType, taskStatus, activeAnnouncement) : this.dao.list(entityLink, limitPosts, userId, filterType, limitParam, after, resolved, FeedRepository.PaginationType.AFTER, threadType, taskStatus, activeAnnouncement);
        FeedResource.addHref(uriInfo, threads.getData());
        return threads;
    }

    @GET
    @Path(value="/{id}")
    @Operation(operationId="getThreadByID", summary="Get a thread by Id", tags={"feeds"}, description="Get a thread by `Id`.", responses={@ApiResponse(responseCode="200", description="The thread", content={@Content(mediaType="application/json", schema=@Schema(implementation=Thread.class))}), @ApiResponse(responseCode="404", description="Thread for instance {id} is not found")})
    public Thread get(@Context UriInfo uriInfo, @Parameter(description="Id of the Thread", schema=@Schema(type="string")) @PathParam(value="id") String id, @Parameter(description="Type of the Entity", schema=@Schema(type="string")) @PathParam(value="entityType") String entityType) throws IOException {
        return FeedResource.addHref(uriInfo, this.dao.get(id));
    }

    @GET
    @Path(value="/tasks/{id}")
    @Operation(operationId="getTaskByID", summary="Get a task thread by task Id", tags={"feeds"}, description="Get a task thread by `task Id`.", responses={@ApiResponse(responseCode="200", description="The task thread", content={@Content(mediaType="application/json", schema=@Schema(implementation=Thread.class))}), @ApiResponse(responseCode="404", description="Task for instance {id} is not found")})
    public Thread getTask(@Context UriInfo uriInfo, @Parameter(description="Id of the task thread", schema=@Schema(type="string")) @PathParam(value="id") String id) throws IOException {
        return FeedResource.addHref(uriInfo, this.dao.getTask(Integer.parseInt(id)));
    }

    @PUT
    @Path(value="/tasks/{id}/resolve")
    @Operation(operationId="resolveTask", summary="Resolve a task", tags={"feeds"}, description="Resolve a task.", responses={@ApiResponse(responseCode="200", description="The task thread", content={@Content(mediaType="application/json", schema=@Schema(implementation=Thread.class))}), @ApiResponse(responseCode="400", description="Bad request")})
    public Response resolveTask(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Id of the task thread", schema=@Schema(type="string")) @PathParam(value="id") String id, @Valid ResolveTask resolveTask) throws IOException {
        Thread task = this.dao.getTask(Integer.parseInt(id));
        this.checkPermissionsForResolveTask(task, securityContext);
        return this.dao.resolveTask(uriInfo, task, securityContext.getUserPrincipal().getName(), resolveTask).toResponse();
    }

    @PUT
    @Path(value="/tasks/{id}/close")
    @Operation(operationId="closeTask", summary="Close a task", tags={"feeds"}, description="Close a task without making any changes to the entity.", responses={@ApiResponse(responseCode="200", description="The task thread.", content={@Content(mediaType="application/json", schema=@Schema(implementation=Thread.class))}), @ApiResponse(responseCode="400", description="Bad request")})
    public Response closeTask(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Id of the task thread", schema=@Schema(type="string")) @PathParam(value="id") String id, @Valid CloseTask closeTask) throws IOException {
        Thread task = this.dao.getTask(Integer.parseInt(id));
        this.checkPermissionsForResolveTask(task, securityContext);
        return this.dao.closeTask(uriInfo, task, securityContext.getUserPrincipal().getName(), closeTask).toResponse();
    }

    private void checkPermissionsForResolveTask(Thread thread, SecurityContext securityContext) throws IOException {
        if (thread.getType().equals((Object)ThreadType.Task)) {
            TaskDetails taskDetails = thread.getTask();
            List assignees = taskDetails.getAssignees();
            String createdBy = thread.getCreatedBy();
            MessageParser.EntityLink about = MessageParser.EntityLink.parse(thread.getAbout());
            EntityReference aboutRef = EntityUtil.validateEntityLink(about);
            EntityReference owner = Entity.getOwner(aboutRef);
            String userName = securityContext.getUserPrincipal().getName();
            User loggedInUser = this.dao.findUserByName(userName);
            List teams = loggedInUser.getTeams();
            List<Object> teamNames = new ArrayList();
            if (teams != null) {
                teamNames = teams.stream().map(EntityReference::getName).collect(Collectors.toList());
            }
            ArrayList finalTeamNames = teamNames;
            if (!(createdBy.equals(userName) || assignees.stream().anyMatch(assignee -> assignee.getName().equals(userName)) || assignees.stream().anyMatch(assignee -> finalTeamNames.contains(assignee.getName())) || owner.getName().equals(userName) || teamNames.contains(owner.getName()))) {
                this.authorizer.authorizeAdmin(securityContext);
            }
        }
    }

    @PATCH
    @Path(value="/{id}")
    @Operation(operationId="patchThread", summary="Update a thread by `Id`.", tags={"feeds"}, description="Update an existing thread using JsonPatch.", externalDocs=@ExternalDocumentation(description="JsonPatch RFC", url="https://tools.ietf.org/html/rfc6902"))
    @Consumes(value={"application/json-patch+json"})
    public Response updateThread(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Id of the thread", schema=@Schema(type="string")) @PathParam(value="id") String id, @RequestBody(description="JsonPatch with array of operations", content={@Content(mediaType="application/json-patch+json", examples={@ExampleObject(value="[{op:remove, path:/a},{op:add, path: /b, value: val}]")})}) JsonPatch patch) throws IOException {
        RestUtil.PatchResponse<Thread> response = this.dao.patchThread(uriInfo, UUID.fromString(id), securityContext.getUserPrincipal().getName(), patch);
        return response.toResponse();
    }

    @GET
    @Path(value="/count")
    @Operation(operationId="countThreads", summary="Count of threads", tags={"feeds"}, description="Get a count of threads, optionally filtered by `entityLink` for each of the entities.", responses={@ApiResponse(responseCode="200", description="Count of threads", content={@Content(mediaType="application/json", schema=@Schema(implementation=ThreadCount.class))})})
    public ThreadCount getThreadCount(@Context UriInfo uriInfo, @Parameter(description="Filter threads by entity link", schema=@Schema(type="string", example="<E#/{entityType}/{entityFQN}/{fieldName}>")) @QueryParam(value="entityLink") String entityLink, @Parameter(description="The type of thread to filter the results. It can take one of 'Conversation', 'Task', 'Announcement'", schema=@Schema(implementation=ThreadType.class)) @QueryParam(value="type") ThreadType threadType, @Parameter(description="The status of tasks to filter the results. It can take one of 'Open', 'Closed'. This filter will take effect only when type is set to Task", schema=@Schema(implementation=TaskStatus.class)) @QueryParam(value="taskStatus") TaskStatus taskStatus, @Parameter(description="Filter threads by whether it is active or resolved", schema=@Schema(type="boolean")) @DefaultValue(value="false") @QueryParam(value="isResolved") Boolean isResolved) {
        return this.dao.getThreadsCount(entityLink, threadType, taskStatus, isResolved);
    }

    @POST
    @Operation(operationId="createThread", summary="Create a thread", tags={"feeds"}, description="Create a new thread. A thread is created about a data asset when a user posts the first post.", responses={@ApiResponse(responseCode="200", description="The thread", content={@Content(mediaType="application/json", schema=@Schema(implementation=Thread.class))}), @ApiResponse(responseCode="400", description="Bad request")})
    public Response createThread(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Valid CreateThread create) throws IOException {
        Thread thread = this.getThread(securityContext, create);
        FeedResource.addHref(uriInfo, this.dao.create(thread));
        return Response.created((URI)thread.getHref()).entity((Object)thread).build();
    }

    @POST
    @Path(value="/{id}/posts")
    @Operation(operationId="addPostToThread", summary="Add post to a thread", tags={"feeds"}, description="Add a post to an existing thread.", responses={@ApiResponse(responseCode="200", description="The post", content={@Content(mediaType="application/json", schema=@Schema(implementation=Thread.class))}), @ApiResponse(responseCode="400", description="Bad request")})
    public Response addPost(@Context SecurityContext securityContext, @Context UriInfo uriInfo, @Parameter(description="Id of the thread", schema=@Schema(type="string")) @PathParam(value="id") String id, @Valid CreatePost createPost) throws IOException {
        Post post = this.getPost(createPost);
        Thread thread = FeedResource.addHref(uriInfo, this.dao.addPostToThread(id, post, securityContext.getUserPrincipal().getName()));
        return Response.created((URI)thread.getHref()).entity((Object)thread).build();
    }

    @PATCH
    @Path(value="/{threadId}/posts/{postId}")
    @Operation(operationId="patchPostOfThread", summary="Update post of a thread by `Id`.", tags={"feeds"}, description="Update a post of an existing thread using JsonPatch.", externalDocs=@ExternalDocumentation(description="JsonPatch RFC", url="https://tools.ietf.org/html/rfc6902"), responses={@ApiResponse(responseCode="400", description="Bad request"), @ApiResponse(responseCode="404", description="post with {postId} is not found")})
    @Consumes(value={"application/json-patch+json"})
    public Response patchPost(@Context SecurityContext securityContext, @Context UriInfo uriInfo, @Parameter(description="Id of the thread", schema=@Schema(type="string")) @PathParam(value="threadId") String threadId, @Parameter(description="Id of the post", schema=@Schema(type="string")) @PathParam(value="postId") String postId, @RequestBody(description="JsonPatch with array of operations", content={@Content(mediaType="application/json-patch+json", examples={@ExampleObject(value="[{op:remove, path:/a},{op:add, path: /b, value: val}]")})}) JsonPatch patch) throws IOException {
        Thread thread = this.dao.get(threadId);
        Post post = this.dao.getPostById(thread, postId);
        RestUtil.PatchResponse<Post> response = this.dao.patchPost(thread, post, securityContext.getUserPrincipal().getName(), patch);
        return response.toResponse();
    }

    @DELETE
    @Path(value="/{threadId}")
    @Operation(operationId="deleteThread", summary="Delete a thread by Id", tags={"feeds"}, description="Delete an existing thread and all its relationships.", responses={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="thread with {threadId} is not found"), @ApiResponse(responseCode="400", description="Bad request")})
    public Response deleteThread(@Context SecurityContext securityContext, @Parameter(description="ThreadId of the thread to be deleted", schema=@Schema(type="string")) @PathParam(value="threadId") String threadId) throws IOException {
        Thread thread = this.dao.get(threadId);
        OperationContext operationContext = new OperationContext("THREAD", MetadataOperation.DELETE);
        ThreadResourceContext resourceContext = new ThreadResourceContext(this.dao.getOwnerReference(thread.getCreatedBy()));
        this.authorizer.authorize(securityContext, operationContext, resourceContext);
        return this.dao.deleteThread(thread, securityContext.getUserPrincipal().getName()).toResponse();
    }

    @DELETE
    @Path(value="/{threadId}/posts/{postId}")
    @Operation(operationId="deletePostFromThread", summary="Delete a post from its thread", tags={"feeds"}, description="Delete a post from an existing thread.", responses={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="post with {postId} is not found"), @ApiResponse(responseCode="400", description="Bad request")})
    public Response deletePost(@Context SecurityContext securityContext, @Parameter(description="ThreadId of the post to be deleted", schema=@Schema(type="string")) @PathParam(value="threadId") String threadId, @Parameter(description="PostId of the post to be deleted", schema=@Schema(type="string")) @PathParam(value="postId") String postId) throws IOException {
        Thread thread = this.dao.get(threadId);
        Post post = this.dao.getPostById(thread, postId);
        OperationContext operationContext = new OperationContext("THREAD", MetadataOperation.DELETE);
        PostResourceContext resourceContext = new PostResourceContext(this.dao.getOwnerReference(post.getFrom()));
        this.authorizer.authorize(securityContext, operationContext, resourceContext);
        return this.dao.deletePost(thread, post, securityContext.getUserPrincipal().getName()).toResponse();
    }

    @GET
    @Path(value="/{id}/posts")
    @Operation(operationId="getAllPostOfThread", summary="Get all the posts of a thread", tags={"feeds"}, description="Get all the posts of an existing thread.", responses={@ApiResponse(responseCode="200", description="The posts of the given thread.", content={@Content(mediaType="application/json", schema=@Schema(implementation=PostList.class))})})
    public PostList getPosts(@Context UriInfo uriInfo, @Parameter(description="Id of the thread", schema=@Schema(type="string")) @PathParam(value="id") String id) throws IOException {
        return new PostList(this.dao.listPosts(id));
    }

    private Thread getThread(SecurityContext securityContext, CreateThread create) {
        return new Thread().withId(UUID.randomUUID()).withThreadTs(Long.valueOf(System.currentTimeMillis())).withMessage(create.getMessage()).withCreatedBy(create.getFrom()).withAbout(create.getAbout()).withAddressedTo(create.getAddressedTo()).withReactions(Collections.emptyList()).withType(create.getType()).withTask(this.getTaskDetails(create.getTaskDetails())).withAnnouncement(create.getAnnouncementDetails()).withUpdatedBy(securityContext.getUserPrincipal().getName()).withUpdatedAt(Long.valueOf(System.currentTimeMillis()));
    }

    private Post getPost(CreatePost create) {
        return new Post().withId(UUID.randomUUID()).withMessage(create.getMessage()).withFrom(create.getFrom()).withReactions(Collections.emptyList()).withPostTs(Long.valueOf(System.currentTimeMillis()));
    }

    private TaskDetails getTaskDetails(CreateTaskDetails create) {
        if (create != null) {
            return new TaskDetails().withAssignees(this.formatAssignees(create.getAssignees())).withType(create.getType()).withStatus(TaskStatus.Open).withOldValue(create.getOldValue()).withSuggestion(create.getSuggestion());
        }
        return null;
    }

    private List<EntityReference> formatAssignees(List<EntityReference> assignees) {
        ArrayList<EntityReference> result = new ArrayList<EntityReference>();
        assignees.forEach(assignee -> result.add(new EntityReference().withId(assignee.getId()).withType(assignee.getType())));
        return result;
    }

    public static class PostList
    extends ResultList<Post> {
        public PostList() {
        }

        public PostList(List<Post> listPosts) {
            super(listPosts);
        }
    }

    static class ThreadList
    extends ResultList<Thread> {
        ThreadList() {
        }
    }
}

