/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.resources.services.objectstore;

import io.swagger.annotations.Api;
import io.swagger.v3.oas.annotations.ExternalDocumentation;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.ExampleObject;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import java.io.IOException;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.json.JsonPatch;
import javax.validation.Valid;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.PATCH;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriInfo;
import org.openmetadata.schema.CreateEntity;
import org.openmetadata.schema.api.data.RestoreEntity;
import org.openmetadata.schema.api.services.CreateObjectStoreService;
import org.openmetadata.schema.entity.services.DatabaseService;
import org.openmetadata.schema.entity.services.ObjectStoreService;
import org.openmetadata.schema.entity.services.ServiceType;
import org.openmetadata.schema.entity.services.connections.TestConnectionResult;
import org.openmetadata.schema.type.EntityHistory;
import org.openmetadata.schema.type.Include;
import org.openmetadata.schema.type.MetadataOperation;
import org.openmetadata.schema.type.ObjectStoreConnection;
import org.openmetadata.service.Entity;
import org.openmetadata.service.jdbi3.CollectionDAO;
import org.openmetadata.service.jdbi3.ListFilter;
import org.openmetadata.service.jdbi3.ObjectStoreServiceRepository;
import org.openmetadata.service.resources.Collection;
import org.openmetadata.service.resources.services.ServiceEntityResource;
import org.openmetadata.service.security.Authorizer;
import org.openmetadata.service.security.policyevaluator.OperationContext;
import org.openmetadata.service.util.EntityUtil;
import org.openmetadata.service.util.JsonUtils;
import org.openmetadata.service.util.RestUtil;
import org.openmetadata.service.util.ResultList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/v1/services/objectStoreServices")
@Api(value="Object store service collection", tags={"Services -> Object store service collection"})
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@Collection(name="objectstoreServices")
public class ObjectStoreServiceResource
extends ServiceEntityResource<ObjectStoreService, ObjectStoreServiceRepository, ObjectStoreConnection> {
    private static final Logger LOG = LoggerFactory.getLogger(ObjectStoreServiceResource.class);
    public static final String COLLECTION_PATH = "v1/services/objectStoreServices/";
    static final String FIELDS = "pipelines,owner,tags";

    @Override
    public ObjectStoreService addHref(UriInfo uriInfo, ObjectStoreService service) {
        service.setHref(RestUtil.getHref(uriInfo, COLLECTION_PATH, service.getId()));
        Entity.withHref(uriInfo, service.getOwner());
        Entity.withHref(uriInfo, service.getPipelines());
        return service;
    }

    public ObjectStoreServiceResource(CollectionDAO dao, Authorizer authorizer) {
        super(ObjectStoreService.class, new ObjectStoreServiceRepository(dao), authorizer, ServiceType.OBJECT_STORE);
    }

    @GET
    @Operation(operationId="listObjectStoreServices", summary="List object store services", tags={"objectStoreServices"}, description="Get a list of object store services.", responses={@ApiResponse(responseCode="200", description="List of object store service instances", content={@Content(mediaType="application/json", schema=@Schema(implementation=ObjectStoreServiceList.class))})})
    public ResultList<ObjectStoreService> list(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Fields requested in the returned resource", schema=@Schema(type="string", example="pipelines,owner,tags")) @QueryParam(value="fields") String fieldsParam, @DefaultValue(value="10") @Min(value=0L) @Max(value=1000000L) @QueryParam(value="limit") @Min(value=0L) @Max(value=1000000L) int limitParam, @Parameter(description="Returns list of object store services before this cursor", schema=@Schema(type="string")) @QueryParam(value="before") String before, @Parameter(description="Returns list of object store services after this cursor", schema=@Schema(type="string")) @QueryParam(value="after") String after, @Parameter(description="Include all, deleted, or non-deleted entities.", schema=@Schema(implementation=Include.class)) @QueryParam(value="include") @DefaultValue(value="non-deleted") Include include) throws IOException {
        RestUtil.validateCursors(before, after);
        EntityUtil.Fields fields = this.getFields(fieldsParam);
        ListFilter filter = new ListFilter(include);
        ResultList objectStoreServices = before != null ? ((ObjectStoreServiceRepository)this.dao).listBefore(uriInfo, fields, filter, limitParam, before) : ((ObjectStoreServiceRepository)this.dao).listAfter(uriInfo, fields, filter, limitParam, after);
        return this.addHref(uriInfo, this.decryptOrNullify(securityContext, objectStoreServices));
    }

    @GET
    @Path(value="/{id}")
    @Operation(operationId="getObjectStoreServiceByID", summary="Get an object store service", tags={"objectStoreServices"}, description="Get an object store service by `id`.", responses={@ApiResponse(responseCode="200", description="Object store service instance", content={@Content(mediaType="application/json", schema=@Schema(implementation=ObjectStoreService.class))}), @ApiResponse(responseCode="404", description="Object store service for instance {id} is not found")})
    public ObjectStoreService get(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @PathParam(value="id") UUID id, @Parameter(description="Fields requested in the returned resource", schema=@Schema(type="string", example="pipelines,owner,tags")) @QueryParam(value="fields") String fieldsParam, @Parameter(description="Include all, deleted, or non-deleted entities.", schema=@Schema(implementation=Include.class)) @QueryParam(value="include") @DefaultValue(value="non-deleted") Include include) throws IOException {
        ObjectStoreService objectStoreService = (ObjectStoreService)this.getInternal(uriInfo, securityContext, id, fieldsParam, include);
        return this.decryptOrNullify(securityContext, objectStoreService);
    }

    @GET
    @Path(value="/name/{name}")
    @Operation(operationId="getObjectStoreServiceByFQN", summary="Get object store service by name", tags={"objectStoreServices"}, description="Get a object store service by the service `name`.", responses={@ApiResponse(responseCode="200", description="Object store service instance", content={@Content(mediaType="application/json", schema=@Schema(implementation=ObjectStoreService.class))}), @ApiResponse(responseCode="404", description="Object store service for instance {id} is not found")})
    public ObjectStoreService getByName(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @PathParam(value="name") String name, @Parameter(description="Fields requested in the returned resource", schema=@Schema(type="string", example="pipelines,owner,tags")) @QueryParam(value="fields") String fieldsParam, @Parameter(description="Include all, deleted, or non-deleted entities.", schema=@Schema(implementation=Include.class)) @QueryParam(value="include") @DefaultValue(value="non-deleted") Include include) throws IOException {
        ObjectStoreService objectStoreService = (ObjectStoreService)this.getByNameInternal(uriInfo, securityContext, name, fieldsParam, include);
        return this.decryptOrNullify(securityContext, objectStoreService);
    }

    @PUT
    @Path(value="/{id}/testConnectionResult")
    @Operation(operationId="addTestConnectionResult", summary="Add test connection result", tags={"objectStoreServices"}, description="Add test connection result to the service.", responses={@ApiResponse(responseCode="200", description="Successfully updated the service", content={@Content(mediaType="application/json", schema=@Schema(implementation=DatabaseService.class))})})
    public ObjectStoreService addTestConnectionResult(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Id of the service", schema=@Schema(type="UUID")) @PathParam(value="id") UUID id, @Valid TestConnectionResult testConnectionResult) throws IOException {
        OperationContext operationContext = new OperationContext(this.entityType, MetadataOperation.CREATE);
        this.authorizer.authorize(securityContext, operationContext, this.getResourceContextById(id));
        ObjectStoreService service = (ObjectStoreService)((ObjectStoreServiceRepository)this.dao).addTestConnectionResult(id, testConnectionResult);
        return this.decryptOrNullify(securityContext, service);
    }

    @GET
    @Path(value="/{id}/versions")
    @Operation(operationId="listAllObjectStoreServiceVersion", summary="List object store service versions", tags={"objectStoreServices"}, description="Get a list of all the versions of an object store service identified by `id`", responses={@ApiResponse(responseCode="200", description="List of object store service versions", content={@Content(mediaType="application/json", schema=@Schema(implementation=EntityHistory.class))})})
    public EntityHistory listVersions(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="object store service Id", schema=@Schema(type="string")) @PathParam(value="id") UUID id) throws IOException {
        EntityHistory entityHistory = super.listVersionsInternal(securityContext, id);
        List versions = entityHistory.getVersions().stream().map(json -> {
            try {
                ObjectStoreService objectStoreService = JsonUtils.readValue((String)json, ObjectStoreService.class);
                return JsonUtils.pojoToJson(this.decryptOrNullify(securityContext, objectStoreService));
            }
            catch (IOException e) {
                return json;
            }
        }).collect(Collectors.toList());
        entityHistory.setVersions(versions);
        return entityHistory;
    }

    @GET
    @Path(value="/{id}/versions/{version}")
    @Operation(operationId="getSpecificObjectStoreServiceVersion", summary="Get a version of the object store service", tags={"objectStoreServices"}, description="Get a version of the object store service by given `id`", responses={@ApiResponse(responseCode="200", description="object service", content={@Content(mediaType="application/json", schema=@Schema(implementation=ObjectStoreService.class))}), @ApiResponse(responseCode="404", description="Object store service for instance {id} and version {version} is not found")})
    public ObjectStoreService getVersion(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="object store service Id", schema=@Schema(type="string")) @PathParam(value="id") UUID id, @Parameter(description="object store service version number in the form `major`.`minor`", schema=@Schema(type="string", example="0.1 or 1.1")) @PathParam(value="version") String version) throws IOException {
        ObjectStoreService objectStoreService = (ObjectStoreService)super.getVersionInternal(securityContext, id, version);
        return this.decryptOrNullify(securityContext, objectStoreService);
    }

    @Override
    @POST
    @Operation(operationId="createObjectStoreService", summary="Create object store service", tags={"objectStoreServices"}, description="Create a new object store service.", responses={@ApiResponse(responseCode="200", description="Object store service instance", content={@Content(mediaType="application/json", schema=@Schema(implementation=ObjectStoreService.class))}), @ApiResponse(responseCode="400", description="Bad request")})
    public Response create(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Valid CreateObjectStoreService create) throws IOException {
        ObjectStoreService service = this.getService(create, securityContext.getUserPrincipal().getName());
        Response response = this.create(uriInfo, securityContext, service);
        this.decryptOrNullify(securityContext, (ObjectStoreService)response.getEntity());
        return response;
    }

    @Override
    @PUT
    @Operation(operationId="createOrUpdateObjectStoreService", summary="Update object store service", tags={"objectStoreServices"}, description="Update an existing or create a new object store service.", responses={@ApiResponse(responseCode="200", description="Object store service instance", content={@Content(mediaType="application/json", schema=@Schema(implementation=ObjectStoreService.class))}), @ApiResponse(responseCode="400", description="Bad request")})
    public Response createOrUpdate(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Valid CreateObjectStoreService update) throws IOException {
        ObjectStoreService service = this.getService(update, securityContext.getUserPrincipal().getName());
        Response response = this.createOrUpdate(uriInfo, securityContext, this.unmask(service));
        this.decryptOrNullify(securityContext, (ObjectStoreService)response.getEntity());
        return response;
    }

    @PATCH
    @Path(value="/{id}")
    @Operation(operationId="patchObjectStoreService", summary="Update an object store service", tags={"objectStoreServices"}, description="Update an existing object store service using JsonPatch.", externalDocs=@ExternalDocumentation(description="JsonPatch RFC", url="https://tools.ietf.org/html/rfc6902"))
    @Consumes(value={"application/json-patch+json"})
    public Response patch(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @PathParam(value="id") UUID id, @RequestBody(description="JsonPatch with array of operations", content={@Content(mediaType="application/json-patch+json", examples={@ExampleObject(value="[{op:remove, path:/a},{op:add, path: /b, value: val}]")})}) JsonPatch patch) throws IOException {
        return this.patchInternal(uriInfo, securityContext, id, patch);
    }

    @DELETE
    @Path(value="/{id}")
    @Operation(operationId="deleteObjectStoreService", summary="Delete an object store service", tags={"objectStoreServices"}, description="Delete an object store services. If containers belong the service, it can't be deleted.", responses={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="ObjectStoreService service for instance {id} is not found")})
    public Response delete(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Recursively delete this entity and it's children. (Default `false`)") @DefaultValue(value="false") @QueryParam(value="recursive") boolean recursive, @Parameter(description="Hard delete the entity. (Default = `false`)") @QueryParam(value="hardDelete") @DefaultValue(value="false") boolean hardDelete, @Parameter(description="Id of the object store service", schema=@Schema(type="string")) @PathParam(value="id") UUID id) throws IOException {
        return this.delete(uriInfo, securityContext, id, recursive, hardDelete);
    }

    @DELETE
    @Path(value="/name/{fqn}")
    @Operation(operationId="deleteObjectStoreServiceByFQN", summary="Delete an ObjectStoreService by fully qualified name", tags={"containers"}, description="Delete an ObjectStoreService by `fullyQualifiedName`.", responses={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="ObjectStoreService for instance {fqn} is not found")})
    public Response delete(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Hard delete the entity. (Default = `false`)") @QueryParam(value="hardDelete") @DefaultValue(value="false") boolean hardDelete, @Parameter(description="Name of the ObjectStoreService", schema=@Schema(type="string")) @PathParam(value="fqn") String fqn) throws IOException {
        return this.deleteByName(uriInfo, securityContext, fqn, false, hardDelete);
    }

    @PUT
    @Path(value="/restore")
    @Operation(operationId="restore", summary="Restore a soft deleted ObjectStoreService.", tags={"objectStoreServices"}, description="Restore a soft deleted ObjectStoreService.", responses={@ApiResponse(responseCode="200", description="Successfully restored the ObjectStoreService.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ObjectStoreService.class))})})
    public Response restoreObjectStoreService(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Valid RestoreEntity restore) throws IOException {
        return this.restoreEntity(uriInfo, securityContext, restore.getId());
    }

    private ObjectStoreService getService(CreateObjectStoreService create, String user) throws IOException {
        return this.copy(new ObjectStoreService(), (CreateEntity)create, user).withServiceType(create.getServiceType()).withConnection(create.getConnection());
    }

    @Override
    protected ObjectStoreService nullifyConnection(ObjectStoreService service) {
        return service.withConnection(null);
    }

    @Override
    protected String extractServiceType(ObjectStoreService service) {
        return service.getServiceType().value();
    }

    public static class ObjectStoreServiceList
    extends ResultList<ObjectStoreService> {
    }
}

