/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.secrets.converter;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.openmetadata.service.secrets.converter.ClassConverterFactory;
import org.openmetadata.service.util.JsonUtils;

public abstract class ClassConverter {
    protected Class<?> clazz;

    public ClassConverter(Class<?> clazz) {
        this.clazz = clazz;
    }

    public Object convert(Object object) {
        return JsonUtils.convertValue(object, this.clazz);
    }

    protected Object convert(Object object, Class<?> clazz) {
        try {
            return ClassConverterFactory.getConverter(clazz).convert(object);
        }
        catch (Exception ignore) {
            return null;
        }
    }

    protected Optional<Object> tryToConvertOrFail(Object object, List<Class<?>> candidateClasses) {
        if (object != null) {
            Object converted = candidateClasses.stream().map(clazz -> this.convert(object, (Class<?>)clazz)).filter(Objects::nonNull).findFirst().orElseThrow(() -> new IllegalArgumentException(String.format("Cannot convert [%s] due to missing converter implementation.", object.getClass().getSimpleName())));
            return Optional.of(ClassConverterFactory.getConverter(converted.getClass()).convert(converted));
        }
        return Optional.empty();
    }

    protected Optional<Object> tryToConvert(Object object, List<Class<?>> candidateClasses) {
        Optional<Object> converted;
        if (object != null && (converted = candidateClasses.stream().map(clazz -> this.convert(object, (Class<?>)clazz)).filter(Objects::nonNull).findFirst()).isPresent()) {
            return Optional.of(ClassConverterFactory.getConverter(converted.get().getClass()).convert(converted.get()));
        }
        return object == null ? Optional.empty() : Optional.of(object);
    }
}

