/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.secrets.converter;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.openmetadata.schema.auth.SSOAuthMechanism;
import org.openmetadata.schema.entity.automations.TestServiceConnectionRequest;
import org.openmetadata.schema.entity.automations.Workflow;
import org.openmetadata.schema.metadataIngestion.DbtPipeline;
import org.openmetadata.schema.metadataIngestion.dbtconfig.DbtGCSConfig;
import org.openmetadata.schema.security.credentials.GCSCredentials;
import org.openmetadata.schema.services.connections.dashboard.SupersetConnection;
import org.openmetadata.schema.services.connections.database.BigQueryConnection;
import org.openmetadata.schema.services.connections.database.DatalakeConnection;
import org.openmetadata.schema.services.connections.database.datalake.GCSConfig;
import org.openmetadata.schema.services.connections.metadata.OpenMetadataConnection;
import org.openmetadata.schema.services.connections.objectstore.GcsConnection;
import org.openmetadata.schema.services.connections.pipeline.AirflowConnection;
import org.openmetadata.service.secrets.converter.AirflowConnectionClassConverter;
import org.openmetadata.service.secrets.converter.BigQueryConnectionClassConverter;
import org.openmetadata.service.secrets.converter.ClassConverter;
import org.openmetadata.service.secrets.converter.DatalakeConnectionClassConverter;
import org.openmetadata.service.secrets.converter.DbtGCSConfigClassConverter;
import org.openmetadata.service.secrets.converter.DbtPipelineClassConverter;
import org.openmetadata.service.secrets.converter.DefaultConnectionClassConverter;
import org.openmetadata.service.secrets.converter.GCSConfigClassConverter;
import org.openmetadata.service.secrets.converter.GcsConnectionClassConverter;
import org.openmetadata.service.secrets.converter.GcsCredentialsClassConverter;
import org.openmetadata.service.secrets.converter.OpenMetadataConnectionClassConverter;
import org.openmetadata.service.secrets.converter.SSOAuthMechanismClassConverter;
import org.openmetadata.service.secrets.converter.SupersetConnectionClassConverter;
import org.openmetadata.service.secrets.converter.TestServiceConnectionRequestClassConverter;
import org.openmetadata.service.secrets.converter.WorkflowClassConverter;

public class ClassConverterFactory {
    private static final Map<Class<?>, ClassConverter> converterMap = Collections.unmodifiableMap(new HashMap<Class<?>, ClassConverter>(){
        {
            this.put(AirflowConnection.class, new AirflowConnectionClassConverter());
            this.put(BigQueryConnection.class, new BigQueryConnectionClassConverter());
            this.put(DatalakeConnection.class, new DatalakeConnectionClassConverter());
            this.put(DbtGCSConfig.class, new DbtGCSConfigClassConverter());
            this.put(DbtPipeline.class, new DbtPipelineClassConverter());
            this.put(GCSConfig.class, new GCSConfigClassConverter());
            this.put(GCSCredentials.class, new GcsCredentialsClassConverter());
            this.put(GcsConnection.class, new GcsConnectionClassConverter());
            this.put(OpenMetadataConnection.class, new OpenMetadataConnectionClassConverter());
            this.put(SSOAuthMechanism.class, new SSOAuthMechanismClassConverter());
            this.put(SupersetConnection.class, new SupersetConnectionClassConverter());
            this.put(TestServiceConnectionRequest.class, new TestServiceConnectionRequestClassConverter());
            this.put(Workflow.class, new WorkflowClassConverter());
        }
    });

    public static ClassConverter getConverter(Class<?> clazz) {
        return converterMap.getOrDefault(clazz, new DefaultConnectionClassConverter(clazz));
    }

    public static Map<Class<?>, ClassConverter> getConverterMap() {
        return converterMap;
    }
}

