/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.secrets.converter;

import java.util.List;
import org.openmetadata.schema.ServiceConnectionEntityInterface;
import org.openmetadata.schema.api.services.DatabaseConnection;
import org.openmetadata.schema.entity.automations.TestServiceConnectionRequest;
import org.openmetadata.schema.entity.services.MetadataConnection;
import org.openmetadata.schema.type.DashboardConnection;
import org.openmetadata.schema.type.MessagingConnection;
import org.openmetadata.schema.type.MlModelConnection;
import org.openmetadata.schema.type.ObjectStoreConnection;
import org.openmetadata.schema.type.PipelineConnection;
import org.openmetadata.service.exception.InvalidServiceConnectionException;
import org.openmetadata.service.secrets.converter.ClassConverter;
import org.openmetadata.service.secrets.converter.ClassConverterFactory;
import org.openmetadata.service.util.JsonUtils;
import org.openmetadata.service.util.ReflectionUtil;

public class TestServiceConnectionRequestClassConverter
extends ClassConverter {
    private static final List<Class<?>> CONNECTION_CLASSES = List.of(DatabaseConnection.class, DashboardConnection.class, MessagingConnection.class, PipelineConnection.class, MlModelConnection.class, MetadataConnection.class, ObjectStoreConnection.class);

    public TestServiceConnectionRequestClassConverter() {
        super(TestServiceConnectionRequest.class);
    }

    @Override
    public Object convert(Object object) {
        TestServiceConnectionRequest testServiceConnectionRequest = (TestServiceConnectionRequest)JsonUtils.convertValue(object, this.clazz);
        try {
            Class<?> clazz = ReflectionUtil.createConnectionConfigClass(testServiceConnectionRequest.getConnectionType(), testServiceConnectionRequest.getServiceType());
            this.tryToConvertOrFail(testServiceConnectionRequest.getConnection(), CONNECTION_CLASSES).ifPresent(arg_0 -> ((TestServiceConnectionRequest)testServiceConnectionRequest).setConnection(arg_0));
            Object newConnectionConfig = ClassConverterFactory.getConverter(clazz).convert(((ServiceConnectionEntityInterface)testServiceConnectionRequest.getConnection()).getConfig());
            ((ServiceConnectionEntityInterface)testServiceConnectionRequest.getConnection()).setConfig(newConnectionConfig);
        }
        catch (Exception e) {
            throw InvalidServiceConnectionException.byMessage(testServiceConnectionRequest.getConnectionType(), String.format("Failed to convert class instance of %s", testServiceConnectionRequest.getConnectionType()));
        }
        return testServiceConnectionRequest;
    }
}

