/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.security.saml;

import io.github.maksymdolgykh.dropwizard.micrometer.MicrometerBundle;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Timer;
import io.prometheus.client.Histogram;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.openmetadata.common.utils.CommonUtil;
import org.openmetadata.service.util.MicrometerBundleSingleton;

public class OMMicrometerHttpFilter
implements Filter {
    protected FilterConfig filterConfig;

    public void init(FilterConfig filterConfig) throws ServletException {
        this.filterConfig = filterConfig;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        Timer.Sample timer = Timer.start((MeterRegistry)MicrometerBundleSingleton.prometheusMeterRegistry);
        long startTime = System.nanoTime();
        chain.doFilter(request, response);
        double elapsed = (double)(System.nanoTime() - startTime) / 1.0E9;
        String requestPath = ((HttpServletRequest)request).getPathInfo();
        if (CommonUtil.nullOrEmpty((String)requestPath)) {
            requestPath = ((HttpServletRequest)request).getServletPath();
        }
        String responseStatus = String.valueOf(((HttpServletResponse)response).getStatus());
        String requestMethod = ((HttpServletRequest)request).getMethod();
        ((Histogram.Child)MicrometerBundle.httpRequests.labels(new String[]{requestMethod, responseStatus, requestPath})).observe(elapsed);
        timer.stop(MicrometerBundleSingleton.webAnalyticEvents);
    }

    public void destroy() {
    }
}

