/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.security.saml;

import com.onelogin.saml2.settings.Saml2Settings;
import com.onelogin.saml2.settings.SettingsBuilder;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.util.HashMap;
import java.util.Map;
import org.openmetadata.catalog.security.client.SamlSSOClientConfig;
import org.openmetadata.catalog.type.SamlSecurityConfig;
import org.openmetadata.common.utils.CommonUtil;
import org.openmetadata.service.OpenMetadataApplicationConfig;

public class SamlSettingsHolder {
    private static SamlSettingsHolder INSTANCE;
    private Map<String, Object> samlData = new HashMap<String, Object>();
    private SettingsBuilder builder = new SettingsBuilder();
    private Saml2Settings saml2Settings;
    private String relayState;
    private long tokenValidity;
    private String domain;

    private SamlSettingsHolder() {
    }

    public static SamlSettingsHolder getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new SamlSettingsHolder();
        }
        return INSTANCE;
    }

    public void initDefaultSettings(OpenMetadataApplicationConfig catalogApplicationConfig) throws IOException, KeyStoreException, CertificateException, NoSuchAlgorithmException {
        SamlSSOClientConfig samlConfig = catalogApplicationConfig.getAuthenticationConfiguration().getSamlConfiguration();
        this.tokenValidity = samlConfig.getSecurity().getTokenValidity().intValue();
        this.domain = catalogApplicationConfig.getAuthorizerConfiguration().getPrincipalDomain();
        if (this.samlData == null) {
            this.samlData = new HashMap<String, Object>();
        }
        if (this.builder == null) {
            this.builder = new SettingsBuilder();
        }
        this.samlData.put("onelogin.saml2.debug", samlConfig.getDebugMode());
        this.samlData.put("onelogin.saml2.sp.entityid", samlConfig.getSp().getEntityId());
        this.samlData.put("onelogin.saml2.sp.assertion_consumer_service.url", samlConfig.getSp().getAcs());
        this.samlData.put("onelogin.saml2.sp.assertion_consumer_service.binding", "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST");
        this.samlData.put("onelogin.saml2.sp.single_logout_service.binding", "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect");
        this.samlData.put("onelogin.saml2.sp.nameidformat", samlConfig.getIdp().getNameId());
        this.relayState = samlConfig.getSp().getCallback();
        this.samlData.put("onelogin.saml2.idp.entityid", samlConfig.getIdp().getEntityId());
        this.samlData.put("onelogin.saml2.idp.single_sign_on_service.url", samlConfig.getIdp().getSsoLoginUrl());
        this.samlData.put("onelogin.saml2.idp.single_sign_on_service.binding", "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect");
        this.samlData.put("onelogin.saml2.idp.single_logout_service.binding", "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect");
        this.samlData.put("onelogin.saml2.idp.x509cert", samlConfig.getIdp().getIdpX509Certificate());
        SamlSecurityConfig securityConfig = samlConfig.getSecurity();
        this.samlData.put("onelogin.saml2.strict", securityConfig.getStrictMode());
        this.samlData.put("onelogin.saml2.security.nameid_encrypted", securityConfig.getSendEncryptedNameId());
        this.samlData.put("onelogin.saml2.security.authnrequest_signed", securityConfig.getSendSignedAuthRequest());
        this.samlData.put("onelogin.saml2.security.want_messages_signed", securityConfig.getWantMessagesSigned());
        this.samlData.put("onelogin.saml2.security.want_assertions_signed", securityConfig.getWantAssertionsSigned());
        this.samlData.put("onelogin.saml2.security.sign_metadata", securityConfig.getSignSpMetadata());
        this.samlData.put("onelogin.saml2.security.want_assertions_encrypted", securityConfig.getWantAssertionEncrypted());
        this.samlData.put("onelogin.saml2.security.want_nameid_encrypted", securityConfig.getWantNameIdEncrypted());
        this.samlData.put("onelogin.saml2.security.requested_authncontextcomparison", "exact");
        this.samlData.put("onelogin.saml2.security.signature_algorithm", "http://www.w3.org/2001/04/xmldsig-more#rsa-sha256");
        this.samlData.put("onelogin.saml2.security.digest_algorithm", "http://www.w3.org/2001/04/xmlenc#sha256");
        if (securityConfig.getSendSignedAuthRequest().booleanValue() || securityConfig.getWantAssertionEncrypted().booleanValue() || securityConfig.getWantNameIdEncrypted().booleanValue()) {
            if (!(CommonUtil.nullOrEmpty((String)securityConfig.getKeyStoreFilePath()) || CommonUtil.nullOrEmpty((String)securityConfig.getKeyStorePassword()) || CommonUtil.nullOrEmpty((String)securityConfig.getKeyStoreAlias()))) {
                KeyStore keyStore = KeyStore.getInstance("JKS");
                keyStore.load(new FileInputStream(securityConfig.getKeyStoreFilePath()), securityConfig.getKeyStorePassword().toCharArray());
                this.samlData.put("onelogin.saml2.keystore.store", keyStore);
                this.samlData.put("onelogin.saml2.keystore.alias", securityConfig.getKeyStoreAlias());
                this.samlData.put("onelogin.saml2.keystore.key.password", securityConfig.getKeyStorePassword());
            } else if (!CommonUtil.nullOrEmpty((String)samlConfig.getSp().getSpX509Certificate()) || !CommonUtil.nullOrEmpty((String)samlConfig.getSp().getSpPrivateKey())) {
                this.samlData.put("onelogin.saml2.sp.privatekey", samlConfig.getSp().getSpPrivateKey());
                this.samlData.put("onelogin.saml2.sp.x509cert", samlConfig.getSp().getSpX509Certificate());
            } else {
                throw new IllegalArgumentException("Either Specify (KeyStoreFilePath, KeyStoreAlias and KeyStorePassword) or (Sp X509 Certificate and Private Key) as one of both is mandatory.");
            }
        }
        this.samlData.put("onelogin.saml2.unique_id_prefix", "OPENMETADATA_");
        this.saml2Settings = this.builder.fromValues(this.samlData).build();
    }

    public Saml2Settings getSaml2Settings() {
        return this.saml2Settings;
    }

    public String getRelayState() {
        return this.relayState;
    }

    public long getTokenValidity() {
        return this.tokenValidity;
    }

    public String getDomain() {
        return this.domain;
    }
}

