/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.events.subscription.slack;

import java.util.concurrent.TimeUnit;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.openmetadata.schema.api.events.CreateEventSubscription;
import org.openmetadata.schema.entity.events.EventSubscription;
import org.openmetadata.schema.type.ChangeEvent;
import org.openmetadata.schema.type.Webhook;
import org.openmetadata.service.events.errors.EventPublisherException;
import org.openmetadata.service.events.subscription.SubscriptionPublisher;
import org.openmetadata.service.events.subscription.slack.SlackMessage;
import org.openmetadata.service.jdbi3.CollectionDAO;
import org.openmetadata.service.resources.events.EventResource;
import org.openmetadata.service.util.ChangeEventParser;
import org.openmetadata.service.util.JsonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SlackEventPublisher
extends SubscriptionPublisher {
    private static final Logger LOG = LoggerFactory.getLogger(SlackEventPublisher.class);
    private final Invocation.Builder target;
    private final Client client;

    public SlackEventPublisher(EventSubscription eventSub, CollectionDAO dao) {
        super(eventSub, dao);
        if (eventSub.getSubscriptionType() != CreateEventSubscription.SubscriptionType.SLACK_WEBHOOK) {
            throw new IllegalArgumentException("Slack Alert Invoked with Illegal Type and Settings.");
        }
        Webhook webhook = JsonUtils.convertValue(eventSub.getSubscriptionConfig(), Webhook.class);
        String slackWebhookURL = webhook.getEndpoint().toString();
        ClientBuilder clientBuilder = ClientBuilder.newBuilder();
        clientBuilder.connectTimeout((long)eventSub.getTimeout().intValue(), TimeUnit.SECONDS);
        clientBuilder.readTimeout((long)eventSub.getReadTimeout().intValue(), TimeUnit.SECONDS);
        this.client = clientBuilder.build();
        this.target = this.client.target(slackWebhookURL).request();
    }

    @Override
    public void onStartDelegate() {
        LOG.info("Slack Webhook Publisher Started");
    }

    @Override
    public void onShutdownDelegate() {
        if (this.client != null) {
            this.client.close();
        }
    }

    @Override
    public void sendAlert(EventResource.EventList list) {
        for (ChangeEvent event : list.getData()) {
            long attemptTime = System.currentTimeMillis();
            try {
                SlackMessage slackMessage = ChangeEventParser.buildSlackMessage(event);
                Response response = this.target.post(Entity.entity((Object)slackMessage, (MediaType)MediaType.APPLICATION_JSON_TYPE));
                if (response.getStatus() >= 300 && response.getStatus() < 400) {
                    this.setErrorStatus(attemptTime, response.getStatus(), response.getStatusInfo().getReasonPhrase());
                    continue;
                }
                if (response.getStatus() >= 400 && response.getStatus() < 600) {
                    this.setNextBackOff();
                    this.setAwaitingRetry(attemptTime, response.getStatus(), response.getStatusInfo().getReasonPhrase());
                    Thread.sleep(this.currentBackoffTime);
                    continue;
                }
                if (response.getStatus() != 200) continue;
                this.setSuccessStatus(System.currentTimeMillis());
            }
            catch (Exception e) {
                LOG.error("Failed to publish event {} to slack due to {} ", (Object)event, (Object)e.getMessage());
                throw new EventPublisherException(String.format("Failed to publish event %s to slack due to %s ", event, e.getMessage()));
            }
        }
    }
}

