/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.jdbi3;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.function.BiPredicate;
import org.openmetadata.common.utils.CommonUtil;
import org.openmetadata.schema.EntityInterface;
import org.openmetadata.schema.entity.data.DashboardDataModel;
import org.openmetadata.schema.entity.services.DashboardService;
import org.openmetadata.schema.type.Column;
import org.openmetadata.schema.type.EntityReference;
import org.openmetadata.schema.type.Include;
import org.openmetadata.schema.type.Relationship;
import org.openmetadata.service.Entity;
import org.openmetadata.service.jdbi3.CollectionDAO;
import org.openmetadata.service.jdbi3.ColumnUtil;
import org.openmetadata.service.jdbi3.EntityRepository;
import org.openmetadata.service.resources.databases.DatabaseUtil;
import org.openmetadata.service.util.EntityUtil;
import org.openmetadata.service.util.FullyQualifiedName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DashboardDataModelRepository
extends EntityRepository<DashboardDataModel> {
    private static final Logger LOG = LoggerFactory.getLogger(DashboardDataModelRepository.class);
    private static final String DATA_MODELS_FIELD = "dataModels";
    private static final String DATA_MODEL_UPDATE_FIELDS = "owner,tags,followers";
    private static final String DATA_MODEL_PATCH_FIELDS = "owner,tags,followers";

    public DashboardDataModelRepository(CollectionDAO dao) {
        super("/v1/dashboard/datamodels", "dashboardDataModel", DashboardDataModel.class, dao.dataModelDAO(), dao, "owner,tags,followers", "owner,tags,followers");
    }

    @Override
    public void setFullyQualifiedName(DashboardDataModel dashboardDataModel) {
        dashboardDataModel.setFullyQualifiedName(FullyQualifiedName.add(dashboardDataModel.getService().getName() + ".model", dashboardDataModel.getName()));
        ColumnUtil.setColumnFQN(dashboardDataModel.getFullyQualifiedName(), dashboardDataModel.getColumns());
    }

    @Override
    public void prepare(DashboardDataModel dashboardDataModel) throws IOException {
        DashboardService dashboardService = (DashboardService)Entity.getEntity(dashboardDataModel.getService(), "", Include.ALL);
        dashboardDataModel.setService(dashboardService.getEntityReference());
        dashboardDataModel.setServiceType(dashboardService.getServiceType());
    }

    @Override
    public void storeEntity(DashboardDataModel dashboardDataModel, boolean update) throws JsonProcessingException {
        EntityReference owner = dashboardDataModel.getOwner();
        List tags = dashboardDataModel.getTags();
        List dataModels = dashboardDataModel.getDataModels();
        EntityReference service = dashboardDataModel.getService();
        dashboardDataModel.withOwner(null).withService(null).withHref(null).withTags(null).withDataModels(null);
        this.store(dashboardDataModel, update);
        dashboardDataModel.withOwner(owner).withService(service).withTags(tags).withDataModels(dataModels);
    }

    @Override
    public void storeRelationships(DashboardDataModel dashboardDataModel) {
        EntityReference service = dashboardDataModel.getService();
        this.addRelationship(service.getId(), dashboardDataModel.getId(), service.getType(), "dashboardDataModel", Relationship.CONTAINS);
        this.storeOwner(dashboardDataModel, dashboardDataModel.getOwner());
        this.applyTags(dashboardDataModel);
    }

    @Override
    public DashboardDataModel setFields(DashboardDataModel dashboardDataModel, EntityUtil.Fields fields) throws IOException {
        this.getColumnTags(fields.contains("tags"), dashboardDataModel.getColumns());
        return dashboardDataModel.withService(this.getContainer(dashboardDataModel.getId())).withFollowers(fields.contains("followers") ? this.getFollowers(dashboardDataModel) : null).withTags(fields.contains("tags") ? this.getTags(dashboardDataModel.getFullyQualifiedName()) : null).withDataModels(fields.contains(DATA_MODELS_FIELD) ? this.getDataModels(dashboardDataModel) : null);
    }

    @Override
    public void restorePatchAttributes(DashboardDataModel original, DashboardDataModel updated) {
        updated.withFullyQualifiedName(original.getFullyQualifiedName()).withName(original.getName()).withService(original.getService()).withId(original.getId());
    }

    protected List<EntityReference> getDataModels(DashboardDataModel dashboardDataModel) throws IOException {
        if (dashboardDataModel == null) {
            return Collections.emptyList();
        }
        List<CollectionDAO.EntityRelationshipRecord> tableIds = this.findTo(dashboardDataModel.getId(), this.entityType, Relationship.USES, "dashboardDataModel");
        return EntityUtil.populateEntityReferences(tableIds, "table");
    }

    private void getColumnTags(boolean setTags, List<Column> columns) {
        for (Column c : CommonUtil.listOrEmpty(columns)) {
            c.setTags(setTags ? this.getTags(c.getFullyQualifiedName()) : null);
            this.getColumnTags(setTags, c.getChildren());
        }
    }

    @Override
    private void applyTags(List<Column> columns) {
        for (Column column : columns) {
            this.applyTags(column.getTags(), column.getFullyQualifiedName());
            if (column.getChildren() == null) continue;
            this.applyTags(column.getChildren());
        }
    }

    @Override
    public void applyTags(DashboardDataModel dashboardDataModel) {
        super.applyTags(dashboardDataModel);
        this.applyTags(dashboardDataModel.getColumns());
    }

    @Override
    public EntityRepository.EntityUpdater getUpdater(DashboardDataModel original, DashboardDataModel updated, EntityRepository.Operation operation) {
        return new DataModelUpdater(original, updated, operation);
    }

    public class DataModelUpdater
    extends EntityRepository.ColumnEntityUpdater {
        public DataModelUpdater(DashboardDataModel original, DashboardDataModel updated, EntityRepository.Operation operation) {
            super((EntityRepository)DashboardDataModelRepository.this, (EntityInterface)original, (EntityInterface)updated, operation);
        }

        @Override
        public void entitySpecificUpdate() throws IOException {
            DatabaseUtil.validateColumns(((DashboardDataModel)this.original).getColumns());
            this.updateColumns("columns", ((DashboardDataModel)this.original).getColumns(), ((DashboardDataModel)this.updated).getColumns(), (BiPredicate)EntityUtil.columnMatch);
        }
    }
}

