/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.jdbi3;

import java.io.IOException;
import java.util.List;
import org.openmetadata.schema.entity.data.Database;
import org.openmetadata.schema.entity.services.DatabaseService;
import org.openmetadata.schema.type.EntityReference;
import org.openmetadata.schema.type.Include;
import org.openmetadata.schema.type.Relationship;
import org.openmetadata.service.Entity;
import org.openmetadata.service.jdbi3.CollectionDAO;
import org.openmetadata.service.jdbi3.EntityRepository;
import org.openmetadata.service.util.EntityUtil;
import org.openmetadata.service.util.FullyQualifiedName;

public class DatabaseRepository
extends EntityRepository<Database> {
    private static final String DATABASE_UPDATE_FIELDS = "owner,tags";
    private static final String DATABASE_PATCH_FIELDS = "owner,tags";

    public DatabaseRepository(CollectionDAO dao) {
        super("v1/databases/", "database", Database.class, dao.databaseDAO(), dao, "owner,tags", "owner,tags");
    }

    @Override
    public void setFullyQualifiedName(Database database) {
        database.setFullyQualifiedName(FullyQualifiedName.build(database.getService().getName(), database.getName()));
    }

    @Override
    public void prepare(Database database) throws IOException {
        this.populateService(database);
    }

    @Override
    public void storeEntity(Database database, boolean update) throws IOException {
        EntityReference service = database.getService();
        database.withService(null);
        this.store(database, update);
        database.withService(service);
    }

    @Override
    public void storeRelationships(Database database) {
        EntityReference service = database.getService();
        this.addRelationship(service.getId(), database.getId(), service.getType(), "database", Relationship.CONTAINS);
        this.storeOwner(database, database.getOwner());
        this.applyTags(database);
    }

    private List<EntityReference> getSchemas(Database database) throws IOException {
        if (database == null) {
            return null;
        }
        List<CollectionDAO.EntityRelationshipRecord> schemaIds = this.findTo(database.getId(), "database", Relationship.CONTAINS, "databaseSchema");
        return EntityUtil.populateEntityReferences(schemaIds, "databaseSchema");
    }

    @Override
    public Database setFields(Database database, EntityUtil.Fields fields) throws IOException {
        database.setService(this.getContainer(database.getId()));
        database.setDatabaseSchemas(fields.contains("databaseSchemas") ? this.getSchemas(database) : null);
        database.setUsageSummary(fields.contains("usageSummary") ? EntityUtil.getLatestUsage(this.daoCollection.usageDAO(), database.getId()) : null);
        return database;
    }

    @Override
    public void restorePatchAttributes(Database original, Database updated) {
        updated.withFullyQualifiedName(original.getFullyQualifiedName()).withName(original.getName()).withService(original.getService()).withId(original.getId());
    }

    private void populateService(Database database) throws IOException {
        DatabaseService service = (DatabaseService)Entity.getEntity(database.getService(), "", Include.NON_DELETED);
        database.setService(service.getEntityReference());
        database.setServiceType(service.getServiceType());
    }
}

