/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.jdbi3;

import java.io.IOException;
import java.util.List;
import org.openmetadata.common.utils.CommonUtil;
import org.openmetadata.schema.EntityInterface;
import org.openmetadata.schema.tests.TestDefinition;
import org.openmetadata.service.jdbi3.CollectionDAO;
import org.openmetadata.service.jdbi3.EntityRepository;
import org.openmetadata.service.util.EntityUtil;

public class TestDefinitionRepository
extends EntityRepository<TestDefinition> {
    private static final String UPDATE_FIELDS = "owner";
    private static final String PATCH_FIELDS = "owner";

    public TestDefinitionRepository(CollectionDAO dao) {
        super("/v1/dataQuality/testDefinitions", "testDefinition", TestDefinition.class, dao.testDefinitionDAO(), dao, "owner", "owner");
    }

    @Override
    public TestDefinition setFields(TestDefinition entity, EntityUtil.Fields fields) throws IOException {
        return entity.withOwner(fields.contains("owner") ? this.getOwner(entity) : null);
    }

    @Override
    public void prepare(TestDefinition entity) {
        if (CommonUtil.nullOrEmpty((List)entity.getTestPlatforms())) {
            throw new IllegalArgumentException("testPlatforms must not be empty");
        }
    }

    @Override
    public void storeEntity(TestDefinition entity, boolean update) throws IOException {
        this.store(entity, update);
    }

    @Override
    public void storeRelationships(TestDefinition entity) {
        this.storeOwner(entity, entity.getOwner());
    }

    @Override
    public EntityRepository.EntityUpdater getUpdater(TestDefinition original, TestDefinition updated, EntityRepository.Operation operation) {
        return new TestDefinitionUpdater(original, updated, operation);
    }

    public class TestDefinitionUpdater
    extends EntityRepository.EntityUpdater {
        public TestDefinitionUpdater(TestDefinition original, TestDefinition updated, EntityRepository.Operation operation) {
            super((EntityRepository)TestDefinitionRepository.this, (EntityInterface)original, (EntityInterface)updated, operation);
        }

        @Override
        public void entitySpecificUpdate() throws IOException {
            this.recordChange("testPlatforms", ((TestDefinition)this.original).getTestPlatforms(), ((TestDefinition)this.updated).getTestPlatforms());
            this.recordChange("supportedDataTypes", ((TestDefinition)this.original).getSupportedDataTypes(), ((TestDefinition)this.updated).getSupportedDataTypes());
            this.recordChange("parameterDefinition", ((TestDefinition)this.original).getParameterDefinition(), ((TestDefinition)this.updated).getParameterDefinition());
        }
    }
}

