/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.monitoring;

import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.prometheus.PrometheusMeterRegistry;
import org.openmetadata.schema.entity.services.ingestionPipelines.IngestionPipeline;
import org.openmetadata.schema.entity.services.ingestionPipelines.PipelineStatus;
import org.openmetadata.schema.monitoring.EventMonitorProvider;
import org.openmetadata.schema.type.ChangeEvent;
import org.openmetadata.service.monitoring.EventMonitor;
import org.openmetadata.service.monitoring.EventMonitorConfiguration;
import org.openmetadata.service.util.MicrometerBundleSingleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.services.cloudwatch.model.CloudWatchException;

public class PrometheusEventMonitor
extends EventMonitor {
    private static final Logger LOG = LoggerFactory.getLogger(PrometheusEventMonitor.class);
    private final PrometheusMeterRegistry meterRegistry = MicrometerBundleSingleton.prometheusMeterRegistry;
    private static final String PIPELINE_STATUS = "pipelineStatus";
    private static final String COUNTER_NAME = "ingestionPipeline.counter";
    private static final String FQN_TAG_NAME = "fqn";
    private static final String PIPELINE_TYPE_TAG_NAME = "pipelineType";
    private static final String EVENT_TYPE_TAG_NAME = "eventType";
    private static final String CLUSTER_TAG_NAME = "clusterName";

    public PrometheusEventMonitor(EventMonitorProvider eventMonitorProvider, EventMonitorConfiguration config, String clusterPrefix) {
        super(eventMonitorProvider, config, clusterPrefix);
    }

    @Override
    protected void pushMetric(ChangeEvent event) {
        String fqn = event.getEntityFullyQualifiedName();
        IngestionPipeline ingestionPipeline = (IngestionPipeline)event.getEntity();
        String pipelineType = ingestionPipeline.getPipelineType().toString();
        try {
            switch (event.getEventType()) {
                case ENTITY_DELETED: 
                case ENTITY_SOFT_DELETED: 
                case ENTITY_CREATED: {
                    this.incrementIngestionPipelineCounter(fqn, pipelineType, event.getEventType().value());
                    break;
                }
                case ENTITY_UPDATED: {
                    event.getChangeDescription().getFieldsUpdated().forEach(change -> {
                        if (change.getName().equals(PIPELINE_STATUS) && change.getNewValue() != null) {
                            PipelineStatus pipelineStatus = (PipelineStatus)change.getNewValue();
                            this.incrementIngestionPipelineCounter(fqn, pipelineType, pipelineStatus.getPipelineState().value());
                        }
                    });
                }
                default: {
                    throw new IllegalArgumentException("Invalid EventType " + event.getEventType());
                }
            }
        }
        catch (IllegalArgumentException | CloudWatchException e) {
            LOG.error("Failed to publish IngestionPipeline Cloudwatch metric due to " + e.getMessage());
        }
    }

    @Override
    protected void close() {
        this.meterRegistry.close();
    }

    public void incrementIngestionPipelineCounter(String fqn, String pipelineType, String eventType) {
        Counter.builder((String)COUNTER_NAME).tags(new String[]{FQN_TAG_NAME, fqn, PIPELINE_TYPE_TAG_NAME, pipelineType, EVENT_TYPE_TAG_NAME, eventType, CLUSTER_TAG_NAME, this.getClusterPrefix()}).register((MeterRegistry)this.meterRegistry).increment();
    }
}

