/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.resources.tags;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.util.concurrent.UncheckedExecutionException;
import java.io.IOException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import javax.annotation.CheckForNull;
import org.openmetadata.schema.entity.classification.Classification;
import org.openmetadata.schema.entity.classification.Tag;
import org.openmetadata.schema.entity.data.Glossary;
import org.openmetadata.schema.entity.data.GlossaryTerm;
import org.openmetadata.schema.type.TagLabel;
import org.openmetadata.service.Entity;
import org.openmetadata.service.exception.EntityNotFoundException;
import org.openmetadata.service.jdbi3.ClassificationRepository;
import org.openmetadata.service.jdbi3.GlossaryRepository;
import org.openmetadata.service.jdbi3.GlossaryTermRepository;
import org.openmetadata.service.jdbi3.TagRepository;
import org.openmetadata.service.util.EntityUtil;
import org.openmetadata.service.util.FullyQualifiedName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TagLabelCache {
    private static final Logger LOG = LoggerFactory.getLogger(TagLabelCache.class);
    private static final TagLabelCache INSTANCE = new TagLabelCache();
    private static volatile boolean INITIALIZED = false;
    protected static TagRepository TAG_REPOSITORY;
    protected static ClassificationRepository TAG_CLASSIFICATION_REPOSITORY;
    protected static LoadingCache<String, Tag> TAG_CACHE;
    protected static LoadingCache<String, Classification> CLASSIFICATION_CACHE;
    protected static GlossaryTermRepository GLOSSARY_TERM_REPOSITORY;
    protected static GlossaryRepository GLOSSARY_REPOSITORY;
    protected static LoadingCache<String, GlossaryTerm> GLOSSARY_TERM_CACHE;
    protected static LoadingCache<String, Glossary> GLOSSARY_CACHE;

    public static void initialize() {
        if (!INITIALIZED) {
            CLASSIFICATION_CACHE = CacheBuilder.newBuilder().maximumSize(25L).expireAfterWrite(2L, TimeUnit.MINUTES).build((CacheLoader)new ClassificationLoader());
            TAG_CACHE = CacheBuilder.newBuilder().maximumSize(100L).expireAfterWrite(2L, TimeUnit.MINUTES).build((CacheLoader)new TagLoader());
            TAG_REPOSITORY = (TagRepository)Entity.getEntityRepository("tag");
            TAG_CLASSIFICATION_REPOSITORY = (ClassificationRepository)Entity.getEntityRepository("classification");
            GLOSSARY_CACHE = CacheBuilder.newBuilder().maximumSize(25L).expireAfterWrite(2L, TimeUnit.MINUTES).build((CacheLoader)new GlossaryLoader());
            GLOSSARY_TERM_CACHE = CacheBuilder.newBuilder().maximumSize(100L).expireAfterWrite(2L, TimeUnit.MINUTES).build((CacheLoader)new GlossaryTermLoader());
            GLOSSARY_TERM_REPOSITORY = (GlossaryTermRepository)Entity.getEntityRepository("glossaryTerm");
            GLOSSARY_REPOSITORY = (GlossaryRepository)Entity.getEntityRepository("glossary");
            INITIALIZED = true;
        } else {
            LOG.info("Subject cache is already initialized");
        }
    }

    public static TagLabelCache getInstance() {
        return INSTANCE;
    }

    public Classification getClassification(String classificationName) {
        try {
            return (Classification)CLASSIFICATION_CACHE.get((Object)classificationName);
        }
        catch (UncheckedExecutionException | ExecutionException ex) {
            throw new EntityNotFoundException(ex.getMessage());
        }
    }

    public Tag getTag(String tagFqn) {
        try {
            return (Tag)TAG_CACHE.get((Object)tagFqn);
        }
        catch (UncheckedExecutionException | ExecutionException ex) {
            throw new EntityNotFoundException(ex.getMessage());
        }
    }

    public Glossary getGlossary(String glossaryName) {
        try {
            return (Glossary)GLOSSARY_CACHE.get((Object)glossaryName);
        }
        catch (UncheckedExecutionException | ExecutionException ex) {
            throw new EntityNotFoundException(ex.getMessage());
        }
    }

    public GlossaryTerm getGlossaryTerm(String glossaryTermFqn) {
        try {
            return (GlossaryTerm)GLOSSARY_TERM_CACHE.get((Object)glossaryTermFqn);
        }
        catch (UncheckedExecutionException | ExecutionException ex) {
            throw new EntityNotFoundException(ex.getMessage());
        }
    }

    public String getDescription(TagLabel label) {
        if (label.getSource() == TagLabel.TagSource.CLASSIFICATION) {
            return this.getTag(label.getTagFQN()).getDescription();
        }
        if (label.getSource() == TagLabel.TagSource.GLOSSARY) {
            return this.getGlossaryTerm(label.getTagFQN()).getDescription();
        }
        throw new IllegalArgumentException("Invalid source type " + label.getSource());
    }

    public boolean mutuallyExclusive(TagLabel label) {
        boolean rootParent;
        String[] fqnParts = FullyQualifiedName.split(label.getTagFQN());
        String parentFqn = FullyQualifiedName.getParent(fqnParts);
        boolean bl = rootParent = fqnParts.length == 2;
        if (label.getSource() == TagLabel.TagSource.CLASSIFICATION) {
            return rootParent ? this.getClassification(parentFqn).getMutuallyExclusive() : this.getTag(parentFqn).getMutuallyExclusive();
        }
        if (label.getSource() == TagLabel.TagSource.GLOSSARY) {
            return rootParent ? this.getGlossary(parentFqn).getMutuallyExclusive() : this.getGlossaryTerm(parentFqn).getMutuallyExclusive();
        }
        throw new IllegalArgumentException("Invalid source type " + label.getSource());
    }

    static class GlossaryLoader
    extends CacheLoader<String, Glossary> {
        GlossaryLoader() {
        }

        public Glossary load(@CheckForNull String glossaryName) throws IOException {
            Glossary glossary = (Glossary)GLOSSARY_REPOSITORY.getByName(null, glossaryName, EntityUtil.Fields.EMPTY_FIELDS);
            LOG.info("Loaded glossary {}:{}", (Object)glossary.getName(), (Object)glossary.getId());
            return glossary;
        }
    }

    static class GlossaryTermLoader
    extends CacheLoader<String, GlossaryTerm> {
        GlossaryTermLoader() {
        }

        public GlossaryTerm load(@CheckForNull String glossaryTermName) throws IOException {
            GlossaryTerm glossaryTerm = (GlossaryTerm)GLOSSARY_TERM_REPOSITORY.getByName(null, glossaryTermName, EntityUtil.Fields.EMPTY_FIELDS);
            LOG.info("Loaded glossaryTerm {}:{}", (Object)glossaryTerm.getName(), (Object)glossaryTerm.getId());
            return glossaryTerm;
        }
    }

    static class ClassificationLoader
    extends CacheLoader<String, Classification> {
        ClassificationLoader() {
        }

        public Classification load(@CheckForNull String classificationName) throws IOException {
            Classification classification = (Classification)TAG_CLASSIFICATION_REPOSITORY.getByName(null, classificationName, EntityUtil.Fields.EMPTY_FIELDS);
            LOG.info("Loaded classification {}:{}", (Object)classification.getName(), (Object)classification.getId());
            return classification;
        }
    }

    static class TagLoader
    extends CacheLoader<String, Tag> {
        TagLoader() {
        }

        public Tag load(@CheckForNull String tagName) throws IOException {
            Tag tag = (Tag)TAG_REPOSITORY.getByName(null, tagName, EntityUtil.Fields.EMPTY_FIELDS);
            LOG.info("Loaded tag {}:{}", (Object)tag.getName(), (Object)tag.getId());
            return tag;
        }
    }
}

