/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.resources.teams;

import io.dropwizard.jersey.PATCH;
import io.swagger.v3.oas.annotations.ExternalDocumentation;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.ExampleObject;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.io.IOException;
import java.util.UUID;
import javax.json.JsonPatch;
import javax.validation.Valid;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriInfo;
import org.openmetadata.schema.CreateEntity;
import org.openmetadata.schema.api.data.RestoreEntity;
import org.openmetadata.schema.api.teams.CreateTeam;
import org.openmetadata.schema.entity.teams.Team;
import org.openmetadata.schema.entity.teams.TeamHierarchy;
import org.openmetadata.schema.type.EntityHistory;
import org.openmetadata.schema.type.Include;
import org.openmetadata.schema.type.csv.CsvImportResult;
import org.openmetadata.service.Entity;
import org.openmetadata.service.OpenMetadataApplicationConfig;
import org.openmetadata.service.jdbi3.CollectionDAO;
import org.openmetadata.service.jdbi3.ListFilter;
import org.openmetadata.service.jdbi3.TeamRepository;
import org.openmetadata.service.resources.Collection;
import org.openmetadata.service.resources.EntityResource;
import org.openmetadata.service.security.Authorizer;
import org.openmetadata.service.util.EntityUtil;
import org.openmetadata.service.util.JsonUtils;
import org.openmetadata.service.util.ResultList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/v1/teams")
@Tag(name="Teams", description="A `Team` is a group of zero or more users and/or other teams. Teams can own zero or more data assets. Hierarchical teams are supported `Organization` -> `BusinessUnit` -> `Division` -> `Department`.")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@Collection(name="teams", order=2)
public class TeamResource
extends EntityResource<Team, TeamRepository> {
    private static final Logger LOG = LoggerFactory.getLogger(TeamResource.class);
    public static final String COLLECTION_PATH = "/v1/teams/";
    static final String FIELDS = "owner,profile,users,owns,defaultRoles,parents,children,policies,userCount,childrenCount";

    @Override
    public Team addHref(UriInfo uriInfo, Team team) {
        Entity.withHref(uriInfo, team.getOwner());
        Entity.withHref(uriInfo, team.getUsers());
        Entity.withHref(uriInfo, team.getDefaultRoles());
        Entity.withHref(uriInfo, team.getOwns());
        Entity.withHref(uriInfo, team.getParents());
        Entity.withHref(uriInfo, team.getChildren());
        Entity.withHref(uriInfo, team.getPolicies());
        return team;
    }

    public TeamResource(CollectionDAO dao, Authorizer authorizer) {
        super(Team.class, new TeamRepository(dao), authorizer);
    }

    @Override
    public void initialize(OpenMetadataApplicationConfig config) throws IOException {
        ((TeamRepository)this.dao).initOrganization();
    }

    @GET
    @Path(value="/hierarchy")
    @Valid
    @Operation(operationId="listTeamsHierarchy", summary="List teams with hierarchy", description="Get a list of teams with hierarchy.", responses={@ApiResponse(responseCode="200", description="List of teams with hierarchy", content={@Content(mediaType="application/json", schema=@Schema(implementation=TeamList.class))})})
    public ResultList<TeamHierarchy> listHierarchy(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Limit the number of teams returned. (1 to 1000000, default = 10)") @DefaultValue(value="10000") @Min(value=1000L) @Max(value=1000000L) @QueryParam(value="limit") @Min(value=1000L) @Max(value=1000000L) int limitParam, @Parameter(description="Filter the results by whether the team can be joined by any user or not", schema=@Schema(type="boolean")) @QueryParam(value="isJoinable") Boolean isJoinable) throws IOException {
        ListFilter filter = new ListFilter(Include.NON_DELETED);
        return new ResultList<TeamHierarchy>(((TeamRepository)this.dao).listHierarchy(filter, limitParam, isJoinable));
    }

    @GET
    @Valid
    @Operation(operationId="listTeams", summary="List teams", description="Get a list of teams. Use `fields` parameter to get only necessary fields. Use cursor-based pagination to limit the number entries in the list using `limit` and `before` or `after` query params.", responses={@ApiResponse(responseCode="200", description="List of teams", content={@Content(mediaType="application/json", schema=@Schema(implementation=TeamList.class))})})
    public ResultList<Team> list(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Fields requested in the returned resource", schema=@Schema(type="string", example="owner,profile,users,owns,defaultRoles,parents,children,policies,userCount,childrenCount")) @QueryParam(value="fields") String fieldsParam, @Parameter(description="Limit the number of teams returned. (1 to 1000000, default = 10)") @DefaultValue(value="10") @Min(value=0L) @Max(value=1000000L) @QueryParam(value="limit") @Min(value=0L) @Max(value=1000000L) int limitParam, @Parameter(description="Returns list of teams before this cursor", schema=@Schema(type="string")) @QueryParam(value="before") String before, @Parameter(description="Returns list of teams after this cursor", schema=@Schema(type="string")) @QueryParam(value="after") String after, @Parameter(description="Filter the results by parent team name", schema=@Schema(type="string")) @QueryParam(value="parentTeam") String parentTeam, @Parameter(description="Filter the results by whether the team can be joined by any user or not", schema=@Schema(type="boolean")) @QueryParam(value="isJoinable") Boolean isJoinable, @Parameter(description="Include all, deleted, or non-deleted entities.", schema=@Schema(implementation=Include.class)) @QueryParam(value="include") @DefaultValue(value="non-deleted") Include include) throws IOException {
        ListFilter filter = new ListFilter(include).addQueryParam("parentTeam", parentTeam);
        if (isJoinable != null) {
            filter.addQueryParam("isJoinable", String.valueOf(isJoinable));
        }
        return super.listInternal(uriInfo, securityContext, fieldsParam, filter, limitParam, before, after);
    }

    @GET
    @Path(value="/{id}/versions")
    @Operation(operationId="listAllTeamVersion", summary="List team versions", description="Get a list of all the versions of a team identified by `id`", responses={@ApiResponse(responseCode="200", description="List of team versions", content={@Content(mediaType="application/json", schema=@Schema(implementation=EntityHistory.class))})})
    public EntityHistory listVersions(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Id of the team", schema=@Schema(type="UUID")) @PathParam(value="id") UUID id) throws IOException {
        return super.listVersionsInternal(securityContext, id);
    }

    @GET
    @Valid
    @Path(value="/{id}")
    @Operation(operationId="getTeamByID", summary="Get a team by id", description="Get a team by `id`.", responses={@ApiResponse(responseCode="200", description="The team", content={@Content(mediaType="application/json", schema=@Schema(implementation=Team.class))}), @ApiResponse(responseCode="404", description="Team for instance {id} is not found")})
    public Team get(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Id of the team", schema=@Schema(type="UUID")) @PathParam(value="id") UUID id, @Parameter(description="Fields requested in the returned resource", schema=@Schema(type="string", example="owner,profile,users,owns,defaultRoles,parents,children,policies,userCount,childrenCount")) @QueryParam(value="fields") String fieldsParam, @Parameter(description="Include all, deleted, or non-deleted entities.", schema=@Schema(implementation=Include.class)) @QueryParam(value="include") @DefaultValue(value="non-deleted") Include include) throws IOException {
        return (Team)this.getInternal(uriInfo, securityContext, id, fieldsParam, include);
    }

    @GET
    @Valid
    @Path(value="/name/{name}")
    @Operation(operationId="getTeamByFQN", summary="Get a team by name", description="Get a team by `name`.", responses={@ApiResponse(responseCode="200", description="The team", content={@Content(mediaType="application/json", schema=@Schema(implementation=Team.class))}), @ApiResponse(responseCode="404", description="Team for instance {name} is not found")})
    public Team getByName(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Name of the team", schema=@Schema(type="string")) @PathParam(value="name") String name, @Parameter(description="Fields requested in the returned resource", schema=@Schema(type="string", example="owner,profile,users,owns,defaultRoles,parents,children,policies,userCount,childrenCount")) @QueryParam(value="fields") String fieldsParam, @Parameter(description="Include all, deleted, or non-deleted entities.", schema=@Schema(implementation=Include.class)) @QueryParam(value="include") @DefaultValue(value="non-deleted") Include include) throws IOException {
        return (Team)this.getByNameInternal(uriInfo, securityContext, name, fieldsParam, include);
    }

    @GET
    @Path(value="/{id}/versions/{version}")
    @Operation(operationId="getSpecificRoleVersion", summary="Get a version of the team", description="Get a version of the team by given `id`", responses={@ApiResponse(responseCode="200", description="team", content={@Content(mediaType="application/json", schema=@Schema(implementation=Team.class))}), @ApiResponse(responseCode="404", description="Team for instance {id} and version {version} is not found")})
    public Team getVersion(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Id of the team", schema=@Schema(type="UUID")) @PathParam(value="id") UUID id, @Parameter(description="Team version number in the form `major`.`minor`", schema=@Schema(type="string", example="0.1 or 1.1")) @PathParam(value="version") String version) throws IOException {
        return (Team)super.getVersionInternal(securityContext, id, version);
    }

    @Override
    @POST
    @Operation(operationId="createTeam", summary="Create a team", description="Create a new team.", responses={@ApiResponse(responseCode="200", description="The team", content={@Content(mediaType="application/json", schema=@Schema(implementation=Team.class))}), @ApiResponse(responseCode="400", description="Bad request")})
    public Response create(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Valid CreateTeam ct) throws IOException {
        Team team = this.getTeam(ct, securityContext.getUserPrincipal().getName());
        return this.create(uriInfo, securityContext, team);
    }

    @Override
    @PUT
    @Operation(operationId="createOrUpdateTeam", summary="Update team", description="Create or Update a team.", responses={@ApiResponse(responseCode="200", description="The team ", content={@Content(mediaType="application/json", schema=@Schema(implementation=Team.class))}), @ApiResponse(responseCode="400", description="Bad request")})
    public Response createOrUpdate(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Valid CreateTeam ct) throws IOException {
        Team team = this.getTeam(ct, securityContext.getUserPrincipal().getName());
        return this.createOrUpdate(uriInfo, securityContext, team);
    }

    @PATCH
    @Path(value="/{id}")
    @Consumes(value={"application/json-patch+json"})
    @Operation(operationId="patchTeam", summary="Update a team", description="Update an existing team with JsonPatch.", externalDocs=@ExternalDocumentation(description="JsonPatch RFC", url="https://tools.ietf.org/html/rfc6902"))
    public Response patch(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Id of the team", schema=@Schema(type="UUID")) @PathParam(value="id") UUID id, @RequestBody(description="JsonPatch with array of operations", content={@Content(mediaType="application/json-patch+json", examples={@ExampleObject(value="[{op:remove, path:/a},{op:add, path: /b, value: val}]")})}) JsonPatch patch) throws IOException {
        return this.patchInternal(uriInfo, securityContext, id, patch);
    }

    @DELETE
    @Path(value="/{id}")
    @Operation(operationId="deleteTeam", summary="Delete a team by id", description="Delete a team by given `id`.", responses={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="Team for instance {id} is not found")})
    public Response delete(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Recursively delete this team and it's children. (Default `false`)") @DefaultValue(value="false") @QueryParam(value="recursive") boolean recursive, @Parameter(description="Hard delete the entity. (Default = `false`)") @QueryParam(value="hardDelete") @DefaultValue(value="false") boolean hardDelete, @Parameter(description="Id of the team", schema=@Schema(type="UUID")) @PathParam(value="id") UUID id) throws IOException {
        return this.delete(uriInfo, securityContext, id, recursive, hardDelete);
    }

    @DELETE
    @Path(value="/name/{name}")
    @Operation(operationId="deleteTeamByName", summary="Delete a team by name", description="Delete a team by given `name`.", responses={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="Team for instance {name} is not found")})
    public Response delete(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Hard delete the entity. (Default = `false`)") @QueryParam(value="hardDelete") @DefaultValue(value="false") boolean hardDelete, @Parameter(description="Name of the team", schema=@Schema(type="string")) @PathParam(value="name") String name) throws IOException {
        return this.deleteByName(uriInfo, securityContext, name, false, hardDelete);
    }

    @PUT
    @Path(value="/restore")
    @Operation(operationId="restore", summary="Restore a soft deleted team", description="Restore a soft deleted team.", responses={@ApiResponse(responseCode="200", description="Successfully restored the Team ", content={@Content(mediaType="application/json", schema=@Schema(implementation=Team.class))})})
    public Response restoreTeam(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Valid RestoreEntity restore) throws IOException {
        return this.restoreEntity(uriInfo, securityContext, restore.getId());
    }

    @GET
    @Path(value="/documentation/csv")
    @Valid
    @Operation(operationId="getCsvDocumentation", summary="Get CSV documentation for team import/export")
    public String getCsvDocumentation(@Context SecurityContext securityContext, @PathParam(value="name") String name) throws IOException {
        return JsonUtils.pojoToJson(TeamRepository.TeamCsv.DOCUMENTATION);
    }

    @GET
    @Path(value="/name/{name}/export")
    @Produces(value={"text/plain"})
    @Valid
    @Operation(operationId="exportTeams", summary="Export teams in CSV format", responses={@ApiResponse(responseCode="200", description="Exported csv with teams information", content={@Content(mediaType="application/json", schema=@Schema(implementation=String.class))})})
    public String exportCsv(@Context SecurityContext securityContext, @PathParam(value="name") String name) throws IOException {
        return this.exportCsvInternal(securityContext, name);
    }

    @PUT
    @Path(value="/name/{name}/import")
    @Consumes(value={"text/plain"})
    @Valid
    @Operation(operationId="importTeams", summary="Import from CSV to create, and update teams.", responses={@ApiResponse(responseCode="200", description="Import result", content={@Content(mediaType="application/json", schema=@Schema(implementation=CsvImportResult.class))})})
    public CsvImportResult importCsv(@Context SecurityContext securityContext, @PathParam(value="name") String name, @Parameter(description="Dry-run when true is used for validating the CSV without really importing it. (default=true)", schema=@Schema(type="boolean")) @DefaultValue(value="true") @QueryParam(value="dryRun") boolean dryRun, String csv) throws IOException {
        return this.importCsvInternal(securityContext, name, csv, dryRun);
    }

    private Team getTeam(CreateTeam ct, String user) throws IOException {
        if (ct.getTeamType().equals((Object)CreateTeam.TeamType.ORGANIZATION)) {
            throw new IllegalArgumentException("Only one Organization is allowed. New Organization type can't be created");
        }
        if (ct.getTeamType().equals((Object)CreateTeam.TeamType.GROUP) && ct.getChildren() != null) {
            throw new IllegalArgumentException("Team of type Group can't have children of type team. Only users are allowed as part of the team");
        }
        return this.copy(new Team(), (CreateEntity)ct, user).withProfile(ct.getProfile()).withIsJoinable(ct.getIsJoinable()).withUsers(EntityUtil.toEntityReferences(ct.getUsers(), "user")).withDefaultRoles(EntityUtil.toEntityReferences(ct.getDefaultRoles(), "role")).withTeamType(ct.getTeamType()).withParents(EntityUtil.toEntityReferences(ct.getParents(), "team")).withChildren(EntityUtil.toEntityReferences(ct.getChildren(), "team")).withPolicies(EntityUtil.toEntityReferences(ct.getPolicies(), "policy"));
    }

    public static class TeamHierarchyList
    extends ResultList<TeamHierarchy> {
        TeamHierarchyList() {
        }
    }

    public static class TeamList
    extends ResultList<Team> {
        TeamList() {
        }
    }
}

