/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.secrets.converter;

import java.util.List;
import org.openmetadata.schema.security.client.Auth0SSOClientConfig;
import org.openmetadata.schema.security.client.AzureSSOClientConfig;
import org.openmetadata.schema.security.client.CustomOIDCSSOClientConfig;
import org.openmetadata.schema.security.client.GoogleSSOClientConfig;
import org.openmetadata.schema.security.client.OktaSSOClientConfig;
import org.openmetadata.schema.security.client.OpenMetadataJWTClientConfig;
import org.openmetadata.schema.security.credentials.AWSCredentials;
import org.openmetadata.schema.services.connections.metadata.OpenMetadataConnection;
import org.openmetadata.service.secrets.converter.ClassConverter;
import org.openmetadata.service.util.JsonUtils;

public class OpenMetadataConnectionClassConverter
extends ClassConverter {
    private static final List<Class<?>> SECURITY_CONFIG_CLASSES = List.of(OpenMetadataJWTClientConfig.class, GoogleSSOClientConfig.class, OktaSSOClientConfig.class, Auth0SSOClientConfig.class, AzureSSOClientConfig.class, CustomOIDCSSOClientConfig.class);
    private static final List<Class<?>> SECRET_MANAGER_CREDENTIALS_CLASSES = List.of(AWSCredentials.class);

    public OpenMetadataConnectionClassConverter() {
        super(OpenMetadataConnection.class);
    }

    @Override
    public Object convert(Object connectionConfig) {
        OpenMetadataConnection openMetadataConnection = (OpenMetadataConnection)JsonUtils.convertValue(connectionConfig, this.clazz);
        this.tryToConvertOrFail(openMetadataConnection.getSecurityConfig(), SECURITY_CONFIG_CLASSES).ifPresent(arg_0 -> ((OpenMetadataConnection)openMetadataConnection).setSecurityConfig(arg_0));
        this.tryToConvertOrFail(openMetadataConnection.getSecretsManagerCredentials(), SECRET_MANAGER_CREDENTIALS_CLASSES).ifPresent(arg_0 -> ((OpenMetadataConnection)openMetadataConnection).setSecretsManagerCredentials(arg_0));
        return openMetadataConnection;
    }
}

