/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.security.policyevaluator;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.openmetadata.schema.entity.policies.accessControl.Rule;
import org.openmetadata.schema.type.MetadataOperation;
import org.openmetadata.schema.type.Permission;
import org.openmetadata.schema.type.ResourcePermission;
import org.openmetadata.service.exception.CatalogExceptionMessage;
import org.openmetadata.service.security.AuthorizationException;
import org.openmetadata.service.security.policyevaluator.OperationContext;
import org.openmetadata.service.security.policyevaluator.ResourceContextInterface;
import org.openmetadata.service.security.policyevaluator.RuleEvaluator;
import org.openmetadata.service.security.policyevaluator.SubjectContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;

public class CompiledRule
extends Rule {
    private static final Logger LOG = LoggerFactory.getLogger(CompiledRule.class);
    private static final SpelExpressionParser EXPRESSION_PARSER = new SpelExpressionParser();
    @JsonIgnore
    private Expression expression;

    public CompiledRule(Rule rule) {
        this.withName(rule.getName()).withDescription(rule.getDescription()).withCondition(rule.getCondition()).withEffect(rule.getEffect()).withOperations(rule.getOperations()).withResources(rule.getResources());
    }

    public static Expression parseExpression(String condition) {
        if (condition == null) {
            return null;
        }
        try {
            return EXPRESSION_PARSER.parseExpression(condition);
        }
        catch (Exception exception) {
            throw new IllegalArgumentException(CatalogExceptionMessage.failedToParse(exception.getMessage()));
        }
    }

    public static <T> void validateExpression(String condition, Class<T> clz) {
        if (condition == null) {
            return;
        }
        Expression expression = CompiledRule.parseExpression(condition);
        RuleEvaluator ruleEvaluator = new RuleEvaluator(null, null, null);
        try {
            expression.getValue((Object)ruleEvaluator, clz);
        }
        catch (Exception exception) {
            String message = exception.getMessage().replaceAll("on type .*$", "").replaceAll("on object .*$", "");
            throw new IllegalArgumentException(CatalogExceptionMessage.failedToEvaluate(message));
        }
    }

    public Expression getExpression() {
        if (this.getCondition() == null) {
            return null;
        }
        if (this.expression == null) {
            this.expression = CompiledRule.parseExpression(this.getCondition());
        }
        return this.expression;
    }

    public void evaluateDenyRule(OperationContext operationContext, SubjectContext subjectContext, ResourceContextInterface resourceContext, SubjectContext.PolicyContext policyContext) {
        if (this.getEffect() != Rule.Effect.DENY || !this.matchResource(operationContext.getResource())) {
            return;
        }
        List<MetadataOperation> operations = operationContext.getOperations();
        for (MetadataOperation operation : operations) {
            if (!this.matchOperation(operation)) continue;
            LOG.debug("operation {} denied by {}{}{}", new Object[]{operation, policyContext.getRoleName(), policyContext.getPolicyName(), this.getName()});
            if (!this.matchExpression(policyContext, subjectContext, resourceContext)) continue;
            throw new AuthorizationException(CatalogExceptionMessage.permissionDenied(subjectContext.getUser().getName(), operation, policyContext.getRoleName(), policyContext.getPolicyName(), this.getName()));
        }
    }

    private Permission.Access getAccess() {
        if (this.getCondition() != null) {
            return this.getEffect() == Rule.Effect.DENY ? Permission.Access.CONDITIONAL_DENY : Permission.Access.CONDITIONAL_ALLOW;
        }
        return this.getEffect() == Rule.Effect.DENY ? Permission.Access.DENY : Permission.Access.ALLOW;
    }

    public void evaluateAllowRule(OperationContext operationContext, SubjectContext subjectContext, ResourceContextInterface resourceContext, SubjectContext.PolicyContext policyContext) {
        if (this.getEffect() != Rule.Effect.ALLOW || !this.matchResource(operationContext.getResource())) {
            return;
        }
        ListIterator<MetadataOperation> iterator = operationContext.getOperations().listIterator();
        while (iterator.hasNext()) {
            MetadataOperation operation = (MetadataOperation)iterator.next();
            if (!this.matchOperation(operation) || !this.matchExpression(policyContext, subjectContext, resourceContext)) continue;
            LOG.debug("operation {} allowed", (Object)operation);
            iterator.remove();
        }
    }

    public void evaluatePermission(Map<String, ResourcePermission> resourcePermissionMap, SubjectContext.PolicyContext policyContext) {
        for (ResourcePermission resourcePermission : resourcePermissionMap.values()) {
            this.evaluatePermission(resourcePermission.getResource(), resourcePermission, policyContext);
        }
    }

    public void evaluatePermission(String resource, ResourcePermission resourcePermission, SubjectContext.PolicyContext policyContext) {
        if (!this.matchResource(resource)) {
            return;
        }
        Permission.Access access = this.getAccess();
        for (Permission permission : resourcePermission.getPermissions()) {
            if (!this.matchOperation(permission.getOperation()) || !CompiledRule.overrideAccess(access, permission.getAccess())) continue;
            permission.withAccess(access).withRole(policyContext.getRoleName()).withPolicy(policyContext.getPolicyName()).withRule((Rule)this);
            LOG.debug("Updated permission {}", (Object)permission);
        }
    }

    public void evaluatePermission(SubjectContext subjectContext, ResourceContextInterface resourceContext, ResourcePermission resourcePermission, SubjectContext.PolicyContext policyContext) {
        if (!this.matchResource(resourceContext.getResource())) {
            return;
        }
        for (Permission permission : resourcePermission.getPermissions()) {
            Permission.Access access;
            if (!this.matchOperation(permission.getOperation()) || !this.matchExpression(policyContext, subjectContext, resourceContext) || !CompiledRule.overrideAccess(access = this.getEffect() == Rule.Effect.DENY ? Permission.Access.DENY : Permission.Access.ALLOW, permission.getAccess())) continue;
            permission.withAccess(access).withRole(policyContext.getRoleName()).withPolicy(policyContext.getPolicyName()).withRule((Rule)this);
            LOG.debug("Updated permission {}", (Object)permission);
        }
    }

    protected boolean matchResource(String resource) {
        return ((String)this.getResources().get(0)).equalsIgnoreCase("All") || this.getResources().contains(resource);
    }

    private boolean matchOperation(MetadataOperation operation) {
        if (this.getOperations().contains(MetadataOperation.ALL)) {
            LOG.debug("matched all operations");
            return true;
        }
        if (this.getOperations().contains(MetadataOperation.EDIT_ALL) && OperationContext.isEditOperation(operation)) {
            LOG.debug("matched editAll operations");
            return true;
        }
        if (this.getOperations().contains(MetadataOperation.VIEW_ALL) && OperationContext.isViewOperation(operation)) {
            LOG.debug("matched viewAll operations");
            return true;
        }
        return this.getOperations().contains(operation);
    }

    private boolean matchExpression(SubjectContext.PolicyContext policyContext, SubjectContext subjectContext, ResourceContextInterface resourceContext) {
        Expression expression = this.getExpression();
        if (expression == null) {
            return true;
        }
        RuleEvaluator ruleEvaluator = new RuleEvaluator(policyContext, subjectContext, resourceContext);
        StandardEvaluationContext evaluationContext = new StandardEvaluationContext((Object)ruleEvaluator);
        return Boolean.TRUE.equals(expression.getValue((EvaluationContext)evaluationContext, Boolean.class));
    }

    public static boolean overrideAccess(Permission.Access newAccess, Permission.Access currentAccess) {
        return currentAccess.ordinal() > newAccess.ordinal();
    }
}

