/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.security.policyevaluator;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.openmetadata.schema.Function;
import org.openmetadata.schema.type.TagLabel;
import org.openmetadata.service.security.policyevaluator.ResourceContextInterface;
import org.openmetadata.service.security.policyevaluator.SubjectContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RuleEvaluator {
    private static final Logger LOG = LoggerFactory.getLogger(RuleEvaluator.class);
    private final SubjectContext.PolicyContext policyContext;
    private final SubjectContext subjectContext;
    private final ResourceContextInterface resourceContext;

    public RuleEvaluator(SubjectContext.PolicyContext policyContext, SubjectContext subjectContext, ResourceContextInterface resourceContext) {
        this.policyContext = policyContext;
        this.subjectContext = subjectContext;
        this.resourceContext = resourceContext;
    }

    @Function(name="noOwner", input="none", description="Returns true if the entity being accessed has no owner", examples={"noOwner()", "!noOwner", "noOwner() || isOwner()"})
    public boolean noOwner() throws IOException {
        return this.resourceContext != null && this.resourceContext.getOwner() == null;
    }

    @Function(name="isOwner", input="none", description="Returns true if the logged in user is the owner of the entity being accessed", examples={"isOwner()", "!isOwner", "noOwner() || isOwner()"})
    public boolean isOwner() throws IOException {
        return this.subjectContext != null && this.subjectContext.isOwner(this.resourceContext.getOwner());
    }

    @Function(name="matchAllTags", input="List of comma separated tag or glossary fully qualified names", description="Returns true if the entity being accessed has all the tags given as input", examples={"matchAllTags('PersonalData.Personal', 'Tier.Tier1', 'Business Glossary.Clothing')"})
    public boolean matchAllTags(String ... tagFQNs) throws IOException {
        if (this.resourceContext == null) {
            return false;
        }
        List<TagLabel> tags = this.resourceContext.getTags();
        LOG.debug("matchAllTags {} resourceTags {}", (Object)Arrays.toString(tagFQNs), (Object)Arrays.toString(tags.toArray()));
        for (String tagFQN : tagFQNs) {
            TagLabel found = tags.stream().filter(t -> t.getTagFQN().equals(tagFQN)).findAny().orElse(null);
            if (found != null) continue;
            return false;
        }
        return true;
    }

    @Function(name="matchAnyTag", input="List of comma separated tag or glossary fully qualified names", description="Returns true if the entity being accessed has at least one of the tags given as input", examples={"matchAnyTag('PersonalData.Personal', 'Tier.Tier1', 'Business Glossary.Clothing')"})
    public boolean matchAnyTag(String ... tagFQNs) throws IOException {
        if (this.resourceContext == null) {
            return false;
        }
        List<TagLabel> tags = this.resourceContext.getTags();
        LOG.debug("matchAnyTag {} resourceTags {}", (Object)Arrays.toString(tagFQNs), (Object)Arrays.toString(tags.toArray()));
        for (String tagFQN : tagFQNs) {
            TagLabel found = tags.stream().filter(t -> t.getTagFQN().equals(tagFQN)).findAny().orElse(null);
            if (found == null) continue;
            return true;
        }
        return false;
    }

    @Function(name="matchTeam", input="None", description="Returns true if the user and the resource belongs to the team hierarchy where this policy isattached. This allows restricting permissions to a resource to the members of the team hierarchy.", examples={"matchTeam()"})
    public boolean matchTeam() throws IOException {
        if (this.resourceContext == null || this.resourceContext.getOwner() == null) {
            return false;
        }
        if (this.policyContext == null || !this.policyContext.getEntityType().equals("team")) {
            return false;
        }
        return this.subjectContext.isTeamAsset(this.policyContext.getEntityName(), this.resourceContext.getOwner()) && this.subjectContext.isUserUnderTeam(this.policyContext.getEntityName());
    }

    @Function(name="inAnyTeam", input="List of comma separated team names", description="Returns true if the user belongs under the hierarchy of any of the teams in the given team list.", examples={"inAnyTeam('marketing')"})
    public boolean inAnyTeam(String ... teams) {
        for (String team : teams) {
            if (this.subjectContext.isUserUnderTeam(team)) {
                LOG.debug("inAnyTeam - User {} is under the team {}", (Object)this.subjectContext.getUser().getName(), (Object)team);
                return true;
            }
            LOG.debug("inAnyTeam - User {} is not under the team {}", (Object)this.subjectContext.getUser().getName(), (Object)team);
        }
        return false;
    }

    @Function(name="hasAnyRole", input="List of comma separated roles", description="Returns true if the user (either direct or inherited from the parent teams) has one or more roles from the list.", examples={"hasAnyRole('DataSteward', 'DataEngineer')"})
    public boolean hasAnyRole(String ... roles) {
        for (String role : roles) {
            if (!this.subjectContext.hasAnyRole(role)) continue;
            LOG.debug("hasAnyRole - User {} has the role {}", (Object)this.subjectContext.getUser().getName(), (Object)role);
            return true;
        }
        return false;
    }
}

