/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.security.policyevaluator;

import java.io.IOException;
import java.util.List;
import java.util.UUID;
import org.openmetadata.schema.EntityInterface;
import org.openmetadata.schema.tests.TestCase;
import org.openmetadata.schema.type.EntityReference;
import org.openmetadata.schema.type.Include;
import org.openmetadata.schema.type.TagLabel;
import org.openmetadata.service.Entity;
import org.openmetadata.service.jdbi3.EntityRepository;
import org.openmetadata.service.jdbi3.TestCaseRepository;
import org.openmetadata.service.resources.feeds.MessageParser;
import org.openmetadata.service.security.policyevaluator.ResourceContextInterface;
import org.openmetadata.service.util.EntityUtil;

public class TestCaseResourceContext
implements ResourceContextInterface {
    private final MessageParser.EntityLink entityLink;
    private final UUID id;
    private final String name;
    private EntityInterface entity;

    @Override
    public String getResource() {
        return this.entityLink.getEntityType();
    }

    @Override
    public EntityReference getOwner() throws IOException {
        this.resolveEntity();
        return this.entity == null ? null : this.entity.getOwner();
    }

    @Override
    public List<TagLabel> getTags() throws IOException {
        this.resolveEntity();
        return this.entity == null ? null : Entity.getEntityTags(this.getResource(), this.entity);
    }

    @Override
    public EntityInterface getEntity() throws IOException {
        return this.resolveEntity();
    }

    private EntityInterface resolveEntity() throws IOException {
        if (this.entity == null) {
            this.entity = this.entityLink != null ? TestCaseResourceContext.resolveEntityByEntityLink(this.entityLink) : (this.id != null ? TestCaseResourceContext.resolveEntityById(this.id) : TestCaseResourceContext.resolveEntityByName(this.name));
        }
        return this.entity;
    }

    private static EntityInterface resolveEntityByEntityLink(MessageParser.EntityLink entityLink) throws IOException {
        EntityRepository<? extends EntityInterface> entityRepository = Entity.getEntityRepository(entityLink.getEntityType());
        String fields = "";
        if (entityRepository.isSupportsOwner()) {
            fields = EntityUtil.addField(fields, "owner");
        }
        if (entityRepository.isSupportsTags()) {
            fields = EntityUtil.addField(fields, "tags");
        }
        return entityRepository.getByName(null, entityLink.getEntityFQN(), entityRepository.getFields(fields));
    }

    private static EntityInterface resolveEntityById(UUID id) throws IOException {
        TestCaseRepository dao = (TestCaseRepository)Entity.getEntityRepository("testCase");
        TestCase testCase = (TestCase)dao.get(null, id, dao.getFields("entityLink"), Include.ALL);
        return TestCaseResourceContext.resolveEntityByEntityLink(MessageParser.EntityLink.parse(testCase.getEntityLink()));
    }

    private static EntityInterface resolveEntityByName(String fqn) throws IOException {
        if (fqn == null) {
            return null;
        }
        TestCaseRepository dao = (TestCaseRepository)Entity.getEntityRepository("testCase");
        TestCase testCase = (TestCase)dao.getByName(null, fqn, dao.getFields("entityLink"), Include.ALL);
        return TestCaseResourceContext.resolveEntityByEntityLink(MessageParser.EntityLink.parse(testCase.getEntityLink()));
    }

    TestCaseResourceContext(MessageParser.EntityLink entityLink, UUID id, String name, EntityInterface entity) {
        this.entityLink = entityLink;
        this.id = id;
        this.name = name;
        this.entity = entity;
    }

    public static TestCaseResourceContextBuilder builder() {
        return new TestCaseResourceContextBuilder();
    }

    public static class TestCaseResourceContextBuilder {
        private MessageParser.EntityLink entityLink;
        private UUID id;
        private String name;
        private EntityInterface entity;

        TestCaseResourceContextBuilder() {
        }

        public TestCaseResourceContextBuilder entityLink(MessageParser.EntityLink entityLink) {
            this.entityLink = entityLink;
            return this;
        }

        public TestCaseResourceContextBuilder id(UUID id) {
            this.id = id;
            return this;
        }

        public TestCaseResourceContextBuilder name(String name) {
            this.name = name;
            return this;
        }

        public TestCaseResourceContextBuilder entity(EntityInterface entity) {
            this.entity = entity;
            return this;
        }

        public TestCaseResourceContext build() {
            return new TestCaseResourceContext(this.entityLink, this.id, this.name, this.entity);
        }

        public String toString() {
            return "TestCaseResourceContext.TestCaseResourceContextBuilder(entityLink=" + this.entityLink + ", id=" + this.id + ", name=" + this.name + ", entity=" + this.entity + ")";
        }
    }
}

