/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.security.saml;

import com.onelogin.saml2.Auth;
import java.util.List;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.openmetadata.schema.auth.JWTAuthMechanism;
import org.openmetadata.schema.auth.ServiceTokenType;
import org.openmetadata.service.security.jwt.JWTTokenGenerator;
import org.openmetadata.service.security.saml.SamlSettingsHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebServlet(value={"/api/v1/saml/acs"})
public class SamlAssertionConsumerServlet
extends HttpServlet {
    private static final Logger LOG = LoggerFactory.getLogger(SamlAssertionConsumerServlet.class);

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) {
        try {
            this.handleResponse(req, resp);
        }
        catch (Exception e) {
            LOG.error("SamlResponseError :" + e.getMessage());
        }
    }

    private void handleResponse(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        List errors;
        Auth auth = new Auth(SamlSettingsHolder.getInstance().getSaml2Settings(), req, resp);
        auth.processResponse();
        if (!auth.isAuthenticated()) {
            LOG.error("[SAML ACS] Not Authenticated");
            resp.sendError(403, "UnAuthenticated");
        }
        if (!(errors = auth.getErrors()).isEmpty()) {
            String errorReason = auth.getLastErrorReason();
            if (errorReason != null && !errorReason.isEmpty()) {
                LOG.error("[SAML ACS]" + errorReason);
                resp.sendError(500, errorReason);
            }
        } else {
            String username;
            String nameId;
            String email = nameId = auth.getNameId();
            if (nameId.contains("@")) {
                username = nameId.split("@")[0];
            } else {
                username = nameId;
                email = String.format("%s@%s", username, SamlSettingsHolder.getInstance().getDomain());
            }
            JWTAuthMechanism jwtAuthMechanism = JWTTokenGenerator.getInstance().generateJWTToken(username, email, SamlSettingsHolder.getInstance().getTokenValidity(), false, ServiceTokenType.OM_USER);
            String url = SamlSettingsHolder.getInstance().getRelayState() + "?id_token=" + jwtAuthMechanism.getJWTToken() + "&email=" + nameId + "&name=" + username;
            resp.sendRedirect(url);
        }
    }
}

