/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.socket;

import com.auth0.jwt.interfaces.Claim;
import com.auth0.jwt.interfaces.DecodedJWT;
import io.socket.engineio.server.utils.ParseQS;
import java.io.IOException;
import java.util.Map;
import java.util.TreeMap;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.openmetadata.schema.api.security.AuthenticationConfiguration;
import org.openmetadata.schema.api.security.AuthorizerConfiguration;
import org.openmetadata.service.security.JwtFilter;
import org.openmetadata.service.socket.HeaderRequestWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SocketAddressFilter
implements Filter {
    private static final Logger LOG = LoggerFactory.getLogger(SocketAddressFilter.class);
    private JwtFilter jwtFilter;
    private final boolean enableSecureSocketConnection;

    public SocketAddressFilter(AuthenticationConfiguration authenticationConfiguration, AuthorizerConfiguration authorizerConf) {
        this.enableSecureSocketConnection = authorizerConf.getEnableSecureSocketConnection();
        if (this.enableSecureSocketConnection) {
            this.jwtFilter = new JwtFilter(authenticationConfiguration, authorizerConf);
        }
    }

    public SocketAddressFilter() {
        this.enableSecureSocketConnection = false;
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        try {
            HttpServletRequest httpServletRequest = (HttpServletRequest)request;
            Map query = ParseQS.decode((String)httpServletRequest.getQueryString());
            HeaderRequestWrapper requestWrapper = new HeaderRequestWrapper(httpServletRequest);
            requestWrapper.addHeader("RemoteAddress", httpServletRequest.getRemoteAddr());
            requestWrapper.addHeader("UserId", (String)query.get("userId"));
            if (this.enableSecureSocketConnection) {
                String tokenWithType = httpServletRequest.getHeader("Authorization");
                requestWrapper.addHeader("Authorization", tokenWithType);
                String token = JwtFilter.extractToken(tokenWithType);
                DecodedJWT jwt = this.jwtFilter.validateAndReturnDecodedJwtToken(token);
                TreeMap<String, Claim> claims = new TreeMap<String, Claim>(String.CASE_INSENSITIVE_ORDER);
                claims.putAll(jwt.getClaims());
                this.jwtFilter.validateAndReturnUsername(claims);
            }
            chain.doFilter((ServletRequest)requestWrapper, response);
        }
        catch (Exception ex) {
            LOG.error("[SAFilter] Failed in filtering request: {}", (Object)ex.getMessage());
            response.getWriter().println(String.format("[SAFilter] Failed in filtering request: %s", ex.getMessage()));
        }
    }

    public void init(FilterConfig filterConfig) {
    }
}

