/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.util;

import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Base64;
import java.util.Date;
import java.util.TimeZone;
import java.util.UUID;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.openmetadata.common.utils.CommonUtil;
import org.openmetadata.schema.type.ChangeEvent;

public final class RestUtil {
    public static final String CHANGE_CUSTOM_HEADER = "X-OpenMetadata-Change";
    public static final String ENTITY_CREATED = "entityCreated";
    public static final String ENTITY_UPDATED = "entityUpdated";
    public static final String ENTITY_FIELDS_CHANGED = "entityFieldsChanged";
    public static final String ENTITY_NO_CHANGE = "entityNoChange";
    public static final String ENTITY_SOFT_DELETED = "entitySoftDeleted";
    public static final String ENTITY_DELETED = "entityDeleted";
    public static final String DELETED_USER_NAME = "DeletedUser";
    public static final String DELETED_USER_DISPLAY = "User was deleted";
    public static final String DELETED_TEAM_NAME = "DeletedTeam";
    public static final String DELETED_TEAM_DISPLAY = "Team was deleted";
    public static final String SIGNATURE_HEADER = "X-OM-Signature";
    public static final DateFormat DATE_TIME_FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSSSS'Z'");
    public static final DateFormat DATE_FORMAT;

    private RestUtil() {
    }

    public static String removeSlashes(String s) {
        s = s.startsWith("/") ? s.substring(1) : s;
        s = s.endsWith("/") ? s.substring(0, s.length() - 1) : s;
        return s;
    }

    public static URI getHref(UriInfo uriInfo, String collectionPath) {
        collectionPath = RestUtil.removeSlashes(collectionPath);
        String uriPath = uriInfo.getBaseUri() + collectionPath;
        return URI.create(uriPath);
    }

    public static URI getHref(URI parent, String child) {
        child = RestUtil.removeSlashes(child);
        child = RestUtil.replaceSpaces(child);
        return URI.create(parent.toString() + "/" + child);
    }

    public static String replaceSpaces(String s) {
        s = s.replace(" ", "%20");
        return s;
    }

    public static URI getHref(UriInfo uriInfo, String collectionPath, String resourcePath) {
        collectionPath = RestUtil.removeSlashes(collectionPath);
        resourcePath = RestUtil.removeSlashes(resourcePath);
        URI uri = RestUtil.getHref(uriInfo, collectionPath);
        return RestUtil.getHref(uri, resourcePath);
    }

    public static URI getHref(UriInfo uriInfo, String collectionPath, UUID id) {
        return RestUtil.getHref(uriInfo, collectionPath, id.toString());
    }

    public static int compareDates(String date1, String date2) throws ParseException {
        return DATE_FORMAT.parse(date1).compareTo(DATE_FORMAT.parse(date2));
    }

    public static String today(int offsetDays) {
        Date date = CommonUtil.getDateByOffset((Date)new Date(), (int)offsetDays);
        return DATE_FORMAT.format(date);
    }

    public static void validateCursors(String before, String after) {
        if (before != null && after != null) {
            throw new IllegalArgumentException("Only one of before or after query parameter allowed");
        }
    }

    public static String encodeCursor(String cursor) {
        return cursor == null ? null : Base64.getUrlEncoder().encodeToString(cursor.getBytes(StandardCharsets.UTF_8));
    }

    public static String decodeCursor(String cursor) {
        return cursor == null ? null : new String(Base64.getUrlDecoder().decode(cursor));
    }

    static {
        DATE_TIME_FORMAT.setTimeZone(TimeZone.getTimeZone("UTC"));
        DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd");
        DATE_FORMAT.setTimeZone(TimeZone.getTimeZone("UTC"));
    }

    public static class DeleteResponse<T> {
        private final T entity;
        private final String changeType;

        public DeleteResponse(T entity, String changeType) {
            this.entity = entity;
            this.changeType = changeType;
        }

        public Response toResponse() {
            Response.ResponseBuilder responseBuilder = Response.status((Response.Status)Response.Status.OK).header(RestUtil.CHANGE_CUSTOM_HEADER, (Object)this.changeType);
            return responseBuilder.entity(this.entity).build();
        }

        public T getEntity() {
            return this.entity;
        }
    }

    public static class PatchResponse<T> {
        private final T entity;
        private final Response.Status status;
        private final String changeType;

        public PatchResponse(Response.Status status, T entity, String changeType) {
            this.entity = entity;
            this.status = status;
            this.changeType = changeType;
        }

        public Response toResponse() {
            return Response.status((Response.Status)this.status).header(RestUtil.CHANGE_CUSTOM_HEADER, (Object)this.changeType).entity(this.entity).build();
        }

        public T getEntity() {
            return this.entity;
        }
    }

    public static class PutResponse<T> {
        private T entity;
        private ChangeEvent changeEvent;
        private final Response.Status status;
        private final String changeType;

        public PutResponse(Response.Status status, T entity, String changeType) {
            this.entity = entity;
            this.status = status;
            this.changeType = changeType;
        }

        public PutResponse(Response.Status status, ChangeEvent changeEvent, String changeType) {
            this.changeEvent = changeEvent;
            this.status = status;
            this.changeType = changeType;
        }

        public Response toResponse() {
            Response.ResponseBuilder responseBuilder = Response.status((Response.Status)this.status).header(RestUtil.CHANGE_CUSTOM_HEADER, (Object)this.changeType);
            if (this.changeType.equals(RestUtil.ENTITY_CREATED) || this.changeType.equals(RestUtil.ENTITY_UPDATED) || this.changeType.equals(RestUtil.ENTITY_NO_CHANGE)) {
                return responseBuilder.entity(this.entity).build();
            }
            return responseBuilder.entity((Object)this.changeEvent).build();
        }

        public T getEntity() {
            return this.entity;
        }

        public Response.Status getStatus() {
            return this.status;
        }
    }
}

