/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.util;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.List;
import javax.validation.constraints.NotNull;
import org.openmetadata.schema.type.Paging;
import org.openmetadata.service.util.RestUtil;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"data"})
public class ResultList<T> {
    @JsonProperty(value="data")
    @NotNull
    private List<T> data;
    @JsonProperty(value="paging")
    private Paging paging;
    @JsonProperty(value="errors")
    private List<T> errors;

    public ResultList() {
    }

    public ResultList(List<T> data) {
        this.data = data;
        this.paging = null;
        this.errors = null;
    }

    public ResultList(List<T> data, String beforeCursor, String afterCursor, int total) {
        this.data = data;
        this.paging = new Paging().withBefore(RestUtil.encodeCursor(beforeCursor)).withAfter(RestUtil.encodeCursor(afterCursor)).withTotal(Integer.valueOf(total));
    }

    public ResultList(List<T> data, List<T> errors, String beforeCursor, String afterCursor, int total) {
        this.data = data;
        this.errors = errors;
        this.paging = new Paging().withBefore(RestUtil.encodeCursor(beforeCursor)).withAfter(RestUtil.encodeCursor(afterCursor)).withTotal(Integer.valueOf(total));
    }

    @JsonProperty(value="data")
    public List<T> getData() {
        return this.data;
    }

    @JsonProperty(value="data")
    public void setData(List<T> data) {
        this.data = data;
    }

    @JsonProperty(value="errors")
    public List<T> getErrors() {
        return this.errors;
    }

    @JsonProperty(value="errors")
    public void setErrors(List<T> data) {
        this.errors = data;
    }

    @JsonProperty(value="paging")
    public Paging getPaging() {
        return this.paging;
    }

    @JsonProperty(value="paging")
    public ResultList<T> setPaging(Paging paging) {
        this.paging = paging;
        return this;
    }
}

