/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.workflows.searchIndex;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.openmetadata.schema.analytics.ReportData;
import org.openmetadata.schema.system.StepStats;
import org.openmetadata.service.exception.SourceException;
import org.openmetadata.service.jdbi3.CollectionDAO;
import org.openmetadata.service.util.RestUtil;
import org.openmetadata.service.util.ResultList;
import org.openmetadata.service.workflows.interfaces.Source;
import org.openmetadata.service.workflows.searchIndex.ReindexingUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PaginatedDataInsightSource
implements Source<ResultList<ReportData>> {
    private static final Logger LOG = LoggerFactory.getLogger(PaginatedDataInsightSource.class);
    private final CollectionDAO dao;
    private final String entityType;
    private final int batchSize;
    private final StepStats stats = new StepStats();
    private String cursor = null;
    private boolean isDone = false;

    public PaginatedDataInsightSource(CollectionDAO dao, String entityType, int batchSize) {
        this.dao = dao;
        this.entityType = entityType;
        this.batchSize = batchSize;
        this.stats.setTotalRecords(Integer.valueOf(dao.entityExtensionTimeSeriesDao().listCount(entityType)));
    }

    @Override
    public ResultList<ReportData> readNext(Map<String, Object> contextData) throws SourceException {
        if (!this.isDone) {
            ResultList<ReportData> data = this.read(this.cursor);
            this.cursor = data.getPaging().getAfter();
            if (this.cursor == null) {
                this.isDone = true;
            }
            return data;
        }
        return null;
    }

    @Override
    public void reset() {
        this.cursor = null;
        this.isDone = false;
    }

    private ResultList<ReportData> read(String afterCursor) throws SourceException {
        ResultList<ReportData> result;
        LOG.debug("[DataInsightReader] Fetching a Batch of Size: {} ", (Object)this.batchSize);
        try {
            result = this.getReportDataPagination(this.entityType, this.batchSize, afterCursor);
            LOG.debug("[DataInsightReader] Batch Stats :- Submitted : {} Success: {} Failed: {}", new Object[]{this.batchSize, result.getData().size(), 0});
            this.updateStats(result.getData().size(), result.getErrors().size());
        }
        catch (Exception ex) {
            LOG.debug("[DataInsightReader] Batch Stats :- Submitted : {} Success: {} Failed: {}", new Object[]{this.batchSize, 0, this.batchSize});
            if (this.stats.getTotalRecords() - this.stats.getProcessedRecords() <= this.batchSize) {
                this.isDone = true;
                this.updateStats(0, this.stats.getTotalRecords() - this.stats.getProcessedRecords());
            } else {
                this.updateStats(0, this.batchSize);
            }
            throw new SourceException("[EntitiesReader] Batch encountered Exception. Failing Completely.", ex);
        }
        return result;
    }

    public ResultList<ReportData> getReportDataPagination(String entityFQN, int limit, String after) {
        int reportDataCount = this.dao.entityExtensionTimeSeriesDao().listCount(entityFQN);
        List<CollectionDAO.ReportDataRow> reportDataList = this.dao.entityExtensionTimeSeriesDao().getAfterExtension(entityFQN, limit + 1, after == null ? "0" : RestUtil.decodeCursor(after));
        return this.getAfterExtensionList(reportDataList, after, limit, reportDataCount);
    }

    private ResultList<ReportData> getAfterExtensionList(List<CollectionDAO.ReportDataRow> reportDataRowList, String after, int limit, int total) {
        String beforeCursor;
        String afterCursor = null;
        String string = beforeCursor = after == null ? null : reportDataRowList.get(0).getRowNum();
        if (reportDataRowList.size() > limit) {
            reportDataRowList.remove(limit);
            afterCursor = reportDataRowList.get(limit - 1).getRowNum();
        }
        ArrayList<ReportData> reportDataList = new ArrayList<ReportData>();
        for (CollectionDAO.ReportDataRow reportDataRow : reportDataRowList) {
            reportDataList.add(reportDataRow.getReportData());
        }
        return new ResultList<ReportData>(reportDataList, new ArrayList(), beforeCursor, afterCursor, total);
    }

    @Override
    public void updateStats(int currentSuccess, int currentFailed) {
        ReindexingUtil.getUpdatedStats(this.stats, currentSuccess, currentFailed);
    }

    @Override
    public StepStats getStats() {
        return this.stats;
    }

    public String getEntityType() {
        return this.entityType;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public boolean isDone() {
        return this.isDone;
    }
}

