/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.workflows.searchIndex;

import java.util.Set;
import org.elasticsearch.action.bulk.BulkItemResponse;
import org.elasticsearch.action.bulk.BulkResponse;
import org.openmetadata.schema.EntityInterface;
import org.openmetadata.schema.system.StepStats;
import org.openmetadata.service.Entity;
import org.openmetadata.service.jdbi3.CollectionDAO;
import org.openmetadata.service.jdbi3.EntityRepository;

public class ReindexingUtil {
    public static final String ENTITY_TYPE_KEY = "entityType";

    public static void getUpdatedStats(StepStats stats, int currentSuccess, int currentFailed) {
        stats.setProcessedRecords(Integer.valueOf(stats.getProcessedRecords() + currentSuccess + currentFailed));
        stats.setSuccessRecords(Integer.valueOf(stats.getSuccessRecords() + currentSuccess));
        stats.setFailedRecords(Integer.valueOf(stats.getFailedRecords() + currentFailed));
    }

    public static boolean isDataInsightIndex(String entityType) {
        return entityType.equalsIgnoreCase("entityReportData") || entityType.equalsIgnoreCase("webAnalyticEntityViewReportData") || entityType.equalsIgnoreCase("webAnalyticUserActivityReportData");
    }

    public static int getTotalRequestToProcess(Set<String> entities, CollectionDAO dao) {
        int total = 0;
        for (String entityType : entities) {
            if (!ReindexingUtil.isDataInsightIndex(entityType)) {
                EntityRepository<? extends EntityInterface> repository = Entity.getEntityRepository(entityType);
                total += repository.dao.listTotalCount();
                continue;
            }
            total += dao.entityExtensionTimeSeriesDao().listCount(entityType);
        }
        return total;
    }

    public static int getSuccessFromBulkResponse(BulkResponse response) {
        int success = 0;
        for (BulkItemResponse bulkItemResponse : response) {
            if (bulkItemResponse.isFailed()) continue;
            ++success;
        }
        return success;
    }
}

