/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.events.scheduled;

import com.fasterxml.jackson.core.type.TypeReference;
import java.io.IOException;
import java.text.ParseException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.openmetadata.common.utils.CommonUtil;
import org.openmetadata.schema.DataInsightInterface;
import org.openmetadata.schema.api.events.CreateEventSubscription;
import org.openmetadata.schema.dataInsight.DataInsightChartResult;
import org.openmetadata.schema.dataInsight.kpi.Kpi;
import org.openmetadata.schema.dataInsight.type.KpiResult;
import org.openmetadata.schema.dataInsight.type.KpiTarget;
import org.openmetadata.schema.dataInsight.type.PercentageOfEntitiesWithDescriptionByType;
import org.openmetadata.schema.dataInsight.type.PercentageOfEntitiesWithOwnerByType;
import org.openmetadata.schema.dataInsight.type.TotalEntitiesByTier;
import org.openmetadata.schema.dataInsight.type.TotalEntitiesByType;
import org.openmetadata.schema.entity.events.EventSubscription;
import org.openmetadata.schema.entity.events.TriggerConfig;
import org.openmetadata.schema.entity.teams.Team;
import org.openmetadata.schema.type.Include;
import org.openmetadata.service.Entity;
import org.openmetadata.service.elasticsearch.ElasticSearchIndexDefinition;
import org.openmetadata.service.events.scheduled.template.DataInsightDescriptionAndOwnerTemplate;
import org.openmetadata.service.events.scheduled.template.DataInsightTotalAssetTemplate;
import org.openmetadata.service.exception.DataInsightJobException;
import org.openmetadata.service.jdbi3.DataInsightChartRepository;
import org.openmetadata.service.jdbi3.KpiRepository;
import org.openmetadata.service.jdbi3.ListFilter;
import org.openmetadata.service.security.policyevaluator.SubjectCache;
import org.openmetadata.service.util.EmailUtil;
import org.openmetadata.service.util.JsonUtils;
import org.openmetadata.service.util.ResultList;
import org.openmetadata.service.util.SubscriptionUtil;
import org.openmetadata.service.workflows.searchIndex.PaginatedEntitiesSource;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataInsightsReportJob
implements Job {
    private static final Logger LOG = LoggerFactory.getLogger(DataInsightsReportJob.class);
    private static final String KPI_NOT_SET = "No Kpi Set";

    public void execute(JobExecutionContext jobExecutionContext) {
        DataInsightChartRepository repository = (DataInsightChartRepository)jobExecutionContext.getJobDetail().getJobDataMap().get((Object)"dataInsightChartRepository");
        RestHighLevelClient client = (RestHighLevelClient)jobExecutionContext.getJobDetail().getJobDataMap().get((Object)"esRestClient");
        EventSubscription dataReport = (EventSubscription)jobExecutionContext.getJobDetail().getJobDataMap().get((Object)"eventsubscription");
        long currentTime = Instant.now().toEpochMilli();
        long scheduleTime = currentTime - this.getTimeFromSchedule(dataReport.getTrigger());
        int numberOfDaysChange = SubscriptionUtil.getNumberOfDays(dataReport.getTrigger());
        try {
            this.sendReportsToTeams(repository, client, scheduleTime, currentTime, numberOfDaysChange);
            this.sendToAdmins(repository, client, scheduleTime, currentTime, numberOfDaysChange);
        }
        catch (Exception e) {
            LOG.error("[DIReport] Failed in sending report due to", (Throwable)e);
            throw new DataInsightJobException(e);
        }
    }

    private void sendReportsToTeams(DataInsightChartRepository repository, RestHighLevelClient client, Long scheduleTime, Long currentTime, int numberOfDaysChange) throws IOException {
        PaginatedEntitiesSource teamReader = new PaginatedEntitiesSource("team", 10, List.of("name", "email", "users"));
        while (!teamReader.isDone()) {
            Object resultList = teamReader.readNext((Map)null);
            for (Team team : ((ResultList)resultList).getData()) {
                HashSet<String> emails = new HashSet<String>();
                String email = team.getEmail();
                if (!CommonUtil.nullOrEmpty((String)email)) {
                    emails.add(email);
                } else {
                    team.getUsers().forEach(user -> emails.add(SubjectCache.getInstance().getUserById(user.getId()).getEmail()));
                }
                try {
                    DataInsightTotalAssetTemplate totalAssetTemplate = this.createTotalAssetTemplate(repository, client, team.getName(), scheduleTime, currentTime, numberOfDaysChange);
                    DataInsightDescriptionAndOwnerTemplate descriptionTemplate = this.createDescriptionTemplate(repository, client, team.getName(), scheduleTime, currentTime, numberOfDaysChange);
                    DataInsightDescriptionAndOwnerTemplate ownershipTemplate = this.createOwnershipTemplate(repository, client, team.getName(), scheduleTime, currentTime, numberOfDaysChange);
                    DataInsightDescriptionAndOwnerTemplate tierTemplate = this.createTierTemplate(repository, client, team.getName(), scheduleTime, currentTime, numberOfDaysChange);
                    EmailUtil.getInstance().sendDataInsightEmailNotificationToUser(emails, totalAssetTemplate, descriptionTemplate, ownershipTemplate, tierTemplate, EmailUtil.getInstance().getDataInsightReportSubject(), "dataInsightReport.ftl");
                }
                catch (Exception ex) {
                    LOG.error("[DataInsightReport] Failed for Team: {}, Reason : {}", (Object)team.getName(), (Object)ex.getMessage());
                }
            }
        }
    }

    private void sendToAdmins(DataInsightChartRepository repository, RestHighLevelClient client, Long scheduleTime, Long currentTime, int numberOfDaysChange) {
        Set<String> emailList = SubscriptionUtil.getAdminsData(CreateEventSubscription.SubscriptionType.DATA_INSIGHT);
        try {
            DataInsightTotalAssetTemplate totalAssetTemplate = this.createTotalAssetTemplate(repository, client, null, scheduleTime, currentTime, numberOfDaysChange);
            DataInsightDescriptionAndOwnerTemplate descriptionTemplate = this.createDescriptionTemplate(repository, client, null, scheduleTime, currentTime, numberOfDaysChange);
            DataInsightDescriptionAndOwnerTemplate ownershipTemplate = this.createOwnershipTemplate(repository, client, null, scheduleTime, currentTime, numberOfDaysChange);
            DataInsightDescriptionAndOwnerTemplate tierTemplate = this.createTierTemplate(repository, client, null, scheduleTime, currentTime, numberOfDaysChange);
            EmailUtil.getInstance().sendDataInsightEmailNotificationToUser(emailList, totalAssetTemplate, descriptionTemplate, ownershipTemplate, tierTemplate, EmailUtil.getInstance().getDataInsightReportSubject(), "dataInsightReport.ftl");
        }
        catch (Exception ex) {
            LOG.error("[DataInsightReport] Failed for Admin, Reason : {}", (Object)ex.getMessage(), (Object)ex);
        }
    }

    private List<Kpi> getAvailableKpi() throws IOException {
        KpiRepository repository = (KpiRepository)Entity.getEntityRepository("kpi");
        return repository.listAll(repository.getFields("dataInsightChart"), new ListFilter(Include.NON_DELETED));
    }

    private KpiResult getKpiResult(String fqn) throws IOException {
        KpiRepository repository = (KpiRepository)Entity.getEntityRepository("kpi");
        return repository.getKpiResult(fqn);
    }

    private DataInsightTotalAssetTemplate createTotalAssetTemplate(DataInsightChartRepository repository, RestHighLevelClient client, String team, Long scheduleTime, Long currentTime, int numberOfDays) throws ParseException, IOException {
        TreeMap<Long, List<Object>> dateWithDataMap = this.getSortedDate(repository, client, team, scheduleTime, currentTime, DataInsightChartResult.DataInsightChartType.TOTAL_ENTITIES_BY_TYPE, ElasticSearchIndexDefinition.ElasticSearchIndexType.ENTITY_REPORT_DATA_INDEX.indexName);
        if (dateWithDataMap.firstEntry() != null && dateWithDataMap.lastEntry() != null) {
            List<TotalEntitiesByType> first = JsonUtils.convertValue(dateWithDataMap.firstEntry().getValue(), new TypeReference<List<TotalEntitiesByType>>(){});
            List<TotalEntitiesByType> last = JsonUtils.convertValue(dateWithDataMap.lastEntry().getValue(), new TypeReference<List<TotalEntitiesByType>>(){});
            Double previousCount = this.getCountOfEntitiesFromList(first);
            Double currentCount = this.getCountOfEntitiesFromList(last);
            if (previousCount == 0.0) {
                return new DataInsightTotalAssetTemplate(currentCount, 0.0, numberOfDays);
            }
            return new DataInsightTotalAssetTemplate(currentCount, (currentCount - previousCount) / previousCount * 100.0, numberOfDays);
        }
        throw new IOException("Failed to get Total Asset Template Data.");
    }

    private DataInsightDescriptionAndOwnerTemplate createDescriptionTemplate(DataInsightChartRepository repository, RestHighLevelClient client, String team, Long scheduleTime, Long currentTime, int numberOfDaysChange) throws ParseException, IOException {
        TreeMap<Long, List<Object>> dateWithDataMap = this.getSortedDate(repository, client, team, scheduleTime, currentTime, DataInsightChartResult.DataInsightChartType.PERCENTAGE_OF_ENTITIES_WITH_DESCRIPTION_BY_TYPE, ElasticSearchIndexDefinition.ElasticSearchIndexType.ENTITY_REPORT_DATA_INDEX.indexName);
        if (dateWithDataMap.firstEntry() != null && dateWithDataMap.lastEntry() != null) {
            List<PercentageOfEntitiesWithDescriptionByType> first = JsonUtils.convertValue(dateWithDataMap.firstEntry().getValue(), new TypeReference<List<PercentageOfEntitiesWithDescriptionByType>>(){});
            List<PercentageOfEntitiesWithDescriptionByType> last = JsonUtils.convertValue(dateWithDataMap.lastEntry().getValue(), new TypeReference<List<PercentageOfEntitiesWithDescriptionByType>>(){});
            double previousCompletedDescription = this.getCompletedDescriptionCount(first);
            double previousTotalCount = this.getTotalEntityFromDescriptionList(first);
            double currentCompletedDescription = this.getCompletedDescriptionCount(last);
            double currentTotalCount = this.getTotalEntityFromDescriptionList(last);
            double previousDiff = previousTotalCount - previousCompletedDescription;
            double currentDiff = currentTotalCount - currentCompletedDescription;
            double percentChange = 0.0;
            if (previousDiff != 0.0) {
                percentChange = (currentDiff - previousDiff) / previousDiff * 100.0;
            }
            double percentCompleted = 0.0;
            if (currentTotalCount != 0.0) {
                percentCompleted = currentCompletedDescription / currentTotalCount * 100.0;
            }
            return this.getTemplate(DataInsightDescriptionAndOwnerTemplate.MetricType.DESCRIPTION, DataInsightChartResult.DataInsightChartType.PERCENTAGE_OF_ENTITIES_WITH_DESCRIPTION_BY_TYPE, percentCompleted, percentChange, numberOfDaysChange);
        }
        throw new IOException("Failed to get Description Template Data.");
    }

    private DataInsightDescriptionAndOwnerTemplate createOwnershipTemplate(DataInsightChartRepository repository, RestHighLevelClient client, String team, Long scheduleTime, Long currentTime, int numberOfDaysChange) throws ParseException, IOException {
        TreeMap<Long, List<Object>> dateWithDataMap = this.getSortedDate(repository, client, team, scheduleTime, currentTime, DataInsightChartResult.DataInsightChartType.PERCENTAGE_OF_ENTITIES_WITH_OWNER_BY_TYPE, ElasticSearchIndexDefinition.ElasticSearchIndexType.ENTITY_REPORT_DATA_INDEX.indexName);
        if (dateWithDataMap.firstEntry() != null && dateWithDataMap.lastEntry() != null) {
            List<PercentageOfEntitiesWithOwnerByType> first = JsonUtils.convertValue(dateWithDataMap.firstEntry().getValue(), new TypeReference<List<PercentageOfEntitiesWithOwnerByType>>(){});
            List<PercentageOfEntitiesWithOwnerByType> last = JsonUtils.convertValue(dateWithDataMap.lastEntry().getValue(), new TypeReference<List<PercentageOfEntitiesWithOwnerByType>>(){});
            double previousHasOwner = this.getCompletedOwnershipCount(first);
            double previousTotalCount = this.getTotalEntityFromOwnerList(first);
            double currentHasOwner = this.getCompletedOwnershipCount(last);
            double currentTotalCount = this.getTotalEntityFromOwnerList(last);
            double previousDiff = previousTotalCount - previousHasOwner;
            double currentDiff = currentTotalCount - currentHasOwner;
            double percentChange = 0.0;
            if (previousDiff != 0.0) {
                percentChange = (currentDiff - previousDiff) / previousDiff * 100.0;
            }
            double percentCompleted = 0.0;
            if (currentTotalCount != 0.0) {
                percentCompleted = currentHasOwner / currentTotalCount * 100.0;
            }
            return this.getTemplate(DataInsightDescriptionAndOwnerTemplate.MetricType.OWNER, DataInsightChartResult.DataInsightChartType.PERCENTAGE_OF_ENTITIES_WITH_OWNER_BY_TYPE, percentCompleted, percentChange, numberOfDaysChange);
        }
        throw new IOException("Failed to get OwnerShip Template Data.");
    }

    private DataInsightDescriptionAndOwnerTemplate createTierTemplate(DataInsightChartRepository repository, RestHighLevelClient client, String team, Long scheduleTime, Long currentTime, int numberOfDaysChange) throws ParseException, IOException {
        TreeMap<Long, List<Object>> dateWithDataMap = this.getSortedDate(repository, client, team, scheduleTime, currentTime, DataInsightChartResult.DataInsightChartType.TOTAL_ENTITIES_BY_TIER, ElasticSearchIndexDefinition.ElasticSearchIndexType.ENTITY_REPORT_DATA_INDEX.indexName);
        if (dateWithDataMap.lastEntry() != null) {
            List<TotalEntitiesByTier> last = JsonUtils.convertValue(dateWithDataMap.lastEntry().getValue(), new TypeReference<List<TotalEntitiesByTier>>(){});
            Map<String, Double> tierData = this.getTierData(last);
            return new DataInsightDescriptionAndOwnerTemplate(DataInsightDescriptionAndOwnerTemplate.MetricType.TIER, null, 0.0, KPI_NOT_SET, 0.0, false, "", numberOfDaysChange, tierData);
        }
        throw new IOException("Failed to get Tier Template Data.");
    }

    private Double getCountOfEntitiesFromList(List<TotalEntitiesByType> entitiesByTypeList) {
        Double totalCount = 0.0;
        for (TotalEntitiesByType obj : entitiesByTypeList) {
            totalCount = totalCount + obj.getEntityCount();
        }
        return totalCount;
    }

    private Map<String, Double> getTierData(List<TotalEntitiesByTier> entitiesByTypeList) {
        HashMap<String, Double> data = new HashMap<String, Double>();
        for (TotalEntitiesByTier obj : entitiesByTypeList) {
            data.put(obj.getEntityTier(), obj.getEntityCountFraction() * 100.0);
        }
        return data;
    }

    private Double getTotalEntityFromDescriptionList(List<PercentageOfEntitiesWithDescriptionByType> entitiesByTypeList) {
        Double totalCount = 0.0;
        for (PercentageOfEntitiesWithDescriptionByType obj : entitiesByTypeList) {
            totalCount = totalCount + obj.getEntityCount();
        }
        return totalCount;
    }

    private Double getCompletedDescriptionCount(List<PercentageOfEntitiesWithDescriptionByType> entitiesByTypeList) {
        Double completedDescriptions = 0.0;
        for (PercentageOfEntitiesWithDescriptionByType obj : entitiesByTypeList) {
            completedDescriptions = completedDescriptions + obj.getCompletedDescription();
        }
        return completedDescriptions;
    }

    private Double getTotalEntityFromOwnerList(List<PercentageOfEntitiesWithOwnerByType> entitiesByTypeList) {
        Double totalCount = 0.0;
        for (PercentageOfEntitiesWithOwnerByType obj : entitiesByTypeList) {
            totalCount = totalCount + obj.getEntityCount();
        }
        return totalCount;
    }

    private Double getCompletedOwnershipCount(List<PercentageOfEntitiesWithOwnerByType> entitiesByTypeList) {
        Double hasOwner = 0.0;
        for (PercentageOfEntitiesWithOwnerByType obj : entitiesByTypeList) {
            hasOwner = hasOwner + obj.getHasOwner();
        }
        return hasOwner;
    }

    private DataInsightDescriptionAndOwnerTemplate getTemplate(DataInsightDescriptionAndOwnerTemplate.MetricType metricType, DataInsightChartResult.DataInsightChartType chartType, Double percentCompleted, Double percentChange, int numberOfDaysChange) throws IOException {
        List<Kpi> kpiList = this.getAvailableKpi();
        Kpi validKpi = null;
        boolean isKpiAvailable = false;
        for (Kpi kpiObj : kpiList) {
            if (!Objects.equals(kpiObj.getDataInsightChart().getName(), chartType.value())) continue;
            validKpi = kpiObj;
            isKpiAvailable = true;
            break;
        }
        DataInsightDescriptionAndOwnerTemplate.KpiCriteria criteria = null;
        String totalDaysLeft = "";
        String targetKpi = KPI_NOT_SET;
        if (isKpiAvailable) {
            targetKpi = String.valueOf(Double.parseDouble(((KpiTarget)validKpi.getTargetDefinition().get(0)).getValue()) * 100.0);
            KpiResult result = this.getKpiResult(validKpi.getName());
            if (result != null) {
                boolean isTargetMet = ((KpiTarget)result.getTargetResult().get(0)).getTargetMet();
                criteria = DataInsightDescriptionAndOwnerTemplate.KpiCriteria.IN_PROGRESS;
                if (isTargetMet) {
                    criteria = DataInsightDescriptionAndOwnerTemplate.KpiCriteria.MET;
                } else {
                    long leftDaysInMilli = validKpi.getEndDate() - System.currentTimeMillis();
                    if (leftDaysInMilli >= 0L) {
                        totalDaysLeft = String.valueOf((int)(leftDaysInMilli / 86400000L));
                    } else {
                        criteria = DataInsightDescriptionAndOwnerTemplate.KpiCriteria.NOT_MET;
                    }
                }
            }
        }
        return new DataInsightDescriptionAndOwnerTemplate(metricType, criteria, percentCompleted, targetKpi, percentChange, isKpiAvailable, totalDaysLeft, numberOfDaysChange, null);
    }

    private TreeMap<Long, List<Object>> getSortedDate(DataInsightChartRepository repository, RestHighLevelClient client, String team, Long scheduleTime, Long currentTime, DataInsightChartResult.DataInsightChartType chartType, String indexName) throws IOException, ParseException {
        SearchRequest searchRequestTotalAssets = repository.buildSearchRequest(scheduleTime, currentTime, null, team, chartType, indexName);
        SearchResponse searchResponseTotalAssets = client.search(searchRequestTotalAssets, RequestOptions.DEFAULT);
        DataInsightChartResult processedDataTotalAssets = repository.processDataInsightChartResult(searchResponseTotalAssets, chartType);
        TreeMap<Long, List<Object>> dateWithDataMap = new TreeMap<Long, List<Object>>();
        for (Object data : processedDataTotalAssets.getData()) {
            DataInsightInterface convertedData = (DataInsightInterface)data;
            Long timestamp = convertedData.getTimestamp();
            List<Object> totalEntitiesByTypeList = new ArrayList<DataInsightInterface>();
            if (dateWithDataMap.containsKey(timestamp)) {
                totalEntitiesByTypeList = dateWithDataMap.get(timestamp);
            }
            totalEntitiesByTypeList.add(convertedData);
            dateWithDataMap.put(timestamp, totalEntitiesByTypeList);
        }
        return dateWithDataMap;
    }

    private long getTimeFromSchedule(TriggerConfig config) {
        if (config.getTriggerType() == TriggerConfig.TriggerType.SCHEDULED) {
            TriggerConfig.ScheduleInfo scheduleInfo = config.getScheduleInfo();
            switch (scheduleInfo) {
                case DAILY: {
                    return 86400000L;
                }
                case WEEKLY: {
                    return 604800000L;
                }
                case MONTHLY: {
                    return 2592000000L;
                }
            }
        }
        throw new IllegalArgumentException("Invalid Trigger Type, Can only be Scheduled.");
    }
}

