/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.events.scheduled.template;

import java.util.Map;

public class DataInsightDescriptionAndOwnerTemplate {
    private Double percentCompleted;
    private boolean kpiAvailable;
    private Double percentChange;
    private String targetKpi;
    private String numberOfDaysLeft;
    private String completeMessage;
    private int numberOfDaysChange;
    private Map<String, Double> tierMap;

    public DataInsightDescriptionAndOwnerTemplate(MetricType metricType, KpiCriteria criteria, Double percentCompleted, String targetKpi, Double percentChange, boolean isKpiAvailable, String numberOfDaysLeft, int numberOfDaysChange, Map<String, Double> tierMap) {
        this.percentCompleted = percentCompleted;
        this.targetKpi = targetKpi;
        this.percentChange = percentChange;
        this.kpiAvailable = isKpiAvailable;
        this.numberOfDaysLeft = numberOfDaysLeft;
        this.tierMap = tierMap;
        this.numberOfDaysChange = numberOfDaysChange;
        String color = "#BF0000";
        if (percentChange > 0.0) {
            color = "#008510";
        }
        this.completeMessage = String.format("The %s changed by <strong style=\"color: %s;\">%s%%</strong> per cent in the last week. %s", this.getMetricTypeMessage(metricType), color, percentChange, this.getKpiCriteriaMessage(metricType, criteria));
    }

    private String getMetricTypeMessage(MetricType metricType) {
        switch (metricType) {
            case DESCRIPTION: {
                return "<strong>Completed Description</strong>";
            }
            case OWNER: {
                return "<strong>Assigned Ownership</strong>";
            }
            case TIER: {
                return "<strong>Assets Assigned with Tiers</strong>";
            }
        }
        return "";
    }

    private String getKpiCriteriaMessage(MetricType metricType, KpiCriteria criteria) {
        if (metricType != MetricType.TIER) {
            if (this.kpiAvailable) {
                switch (criteria) {
                    case MET: {
                        return "Great the Target Set for KPIs has been achieved. It's time to restructure your goals, set new KPIs and progress faster.";
                    }
                    case IN_PROGRESS: {
                        return String.format("To meet the KPIs you will need a minimum of %s per cent completed description in the next %s days.", this.targetKpi, this.numberOfDaysLeft);
                    }
                    case NOT_MET: {
                        return "The Target set for KPIs was not met it\u2019s time to restructure your goals and progress faster.";
                    }
                }
            }
            return "You have not set any KPIS yet, it\u2019s time to restructure your goals, set KPIs and progress faster.";
        }
        return "";
    }

    public Double getPercentCompleted() {
        return this.percentCompleted;
    }

    public String getTargetKpi() {
        return this.targetKpi;
    }

    public void setTargetKpi(String targetKpi) {
        this.targetKpi = targetKpi;
    }

    public Double getPercentChange() {
        return this.percentChange;
    }

    public void setPercentChange(Double percentChange) {
        this.percentChange = percentChange;
    }

    public boolean isKpiAvailable() {
        return this.kpiAvailable;
    }

    public void setKpiAvailable(boolean kpiAvailable) {
        this.kpiAvailable = kpiAvailable;
    }

    public String getNumberOfDaysLeft() {
        return this.numberOfDaysLeft;
    }

    public void setNumberOfDaysLeft(String numberOfDaysLeft) {
        this.numberOfDaysLeft = numberOfDaysLeft;
    }

    public String getCompleteMessage() {
        return this.completeMessage;
    }

    public void setCompleteMessage(String completeMessage) {
        this.completeMessage = completeMessage;
    }

    public Map<String, Double> getTierMap() {
        return this.tierMap;
    }

    public void setTierMap(Map<String, Double> tierMap) {
        this.tierMap = tierMap;
    }

    public int getNumberOfDaysChange() {
        return this.numberOfDaysChange;
    }

    public void setNumberOfDaysChange(int numberOfDaysChange) {
        this.numberOfDaysChange = numberOfDaysChange;
    }

    public static enum KpiCriteria {
        MET,
        IN_PROGRESS,
        NOT_MET;

    }

    public static enum MetricType {
        DESCRIPTION,
        OWNER,
        TIER;

    }
}

