/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.jdbi3;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.IOException;
import java.util.List;
import java.util.UUID;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.jdbi.v3.sqlobject.transaction.Transaction;
import org.json.JSONObject;
import org.openmetadata.schema.EntityInterface;
import org.openmetadata.schema.entity.services.ingestionPipelines.AirflowConfig;
import org.openmetadata.schema.entity.services.ingestionPipelines.IngestionPipeline;
import org.openmetadata.schema.entity.services.ingestionPipelines.PipelineStatus;
import org.openmetadata.schema.metadataIngestion.LogLevels;
import org.openmetadata.schema.services.connections.metadata.OpenMetadataConnection;
import org.openmetadata.schema.type.ChangeDescription;
import org.openmetadata.schema.type.ChangeEvent;
import org.openmetadata.schema.type.EntityReference;
import org.openmetadata.schema.type.EventType;
import org.openmetadata.schema.type.FieldChange;
import org.openmetadata.schema.type.Include;
import org.openmetadata.schema.type.Relationship;
import org.openmetadata.sdk.PipelineServiceClient;
import org.openmetadata.service.Entity;
import org.openmetadata.service.jdbi3.CollectionDAO;
import org.openmetadata.service.jdbi3.EntityRepository;
import org.openmetadata.service.secrets.SecretsManager;
import org.openmetadata.service.secrets.SecretsManagerFactory;
import org.openmetadata.service.util.EntityUtil;
import org.openmetadata.service.util.FullyQualifiedName;
import org.openmetadata.service.util.JsonUtils;
import org.openmetadata.service.util.RestUtil;
import org.openmetadata.service.util.ResultList;

public class IngestionPipelineRepository
extends EntityRepository<IngestionPipeline> {
    private static final String UPDATE_FIELDS = "owner,sourceConfig,airflowConfig,loggerLevel,enabled,deployed";
    private static final String PATCH_FIELDS = "owner,sourceConfig,airflowConfig,loggerLevel,enabled,deployed";
    private static final String PIPELINE_STATUS_JSON_SCHEMA = "ingestionPipelineStatus";
    private static final String PIPELINE_STATUS_EXTENSION = "ingestionPipeline.pipelineStatus";
    private static final String RUN_ID_EXTENSION_KEY = "runId";
    private static PipelineServiceClient pipelineServiceClient;

    public IngestionPipelineRepository(CollectionDAO dao) {
        super("v1/services/ingestionPipelines/", "ingestionPipeline", IngestionPipeline.class, dao.ingestionPipelineDAO(), dao, "owner,sourceConfig,airflowConfig,loggerLevel,enabled,deployed", "owner,sourceConfig,airflowConfig,loggerLevel,enabled,deployed", null);
    }

    @Override
    public void setFullyQualifiedName(IngestionPipeline ingestionPipeline) {
        ingestionPipeline.setFullyQualifiedName(FullyQualifiedName.add(ingestionPipeline.getService().getName(), ingestionPipeline.getName()));
    }

    @Override
    public IngestionPipeline setFields(IngestionPipeline ingestionPipeline, EntityUtil.Fields fields) throws IOException {
        return ingestionPipeline.withService(this.getContainer(ingestionPipeline.getId()));
    }

    @Override
    public void prepare(IngestionPipeline ingestionPipeline) throws IOException {
        EntityReference entityReference = Entity.getEntityReference(ingestionPipeline.getService(), Include.NON_DELETED);
        ingestionPipeline.setService(entityReference);
    }

    @Transaction
    public IngestionPipeline deletePipelineStatus(UUID ingestionPipelineId) throws IOException {
        IngestionPipeline ingestionPipeline = (IngestionPipeline)this.dao.findEntityById(ingestionPipelineId);
        this.daoCollection.entityExtensionTimeSeriesDao().delete(ingestionPipeline.getFullyQualifiedName(), PIPELINE_STATUS_EXTENSION);
        this.setFieldsInternal(ingestionPipeline, EntityUtil.Fields.EMPTY_FIELDS);
        return ingestionPipeline;
    }

    @Override
    public void storeEntity(IngestionPipeline ingestionPipeline, boolean update) throws IOException {
        EntityReference service = ingestionPipeline.getService();
        OpenMetadataConnection openmetadataConnection = ingestionPipeline.getOpenMetadataServerConnection();
        SecretsManager secretsManager = SecretsManagerFactory.getSecretsManager();
        if (secretsManager != null) {
            secretsManager.encryptOrDecryptIngestionPipeline(ingestionPipeline, true);
            openmetadataConnection = secretsManager.encryptOrDecryptOpenMetadataConnection(openmetadataConnection, true, true);
        }
        ingestionPipeline.withService(null).withOpenMetadataServerConnection(null);
        this.store(ingestionPipeline, update);
        ingestionPipeline.withService(service).withOpenMetadataServerConnection(openmetadataConnection);
    }

    @Override
    public void storeRelationships(IngestionPipeline ingestionPipeline) {
        EntityReference service = ingestionPipeline.getService();
        this.addRelationship(service.getId(), ingestionPipeline.getId(), service.getType(), "ingestionPipeline", Relationship.CONTAINS);
        this.storeOwner(ingestionPipeline, ingestionPipeline.getOwner());
        this.applyTags(ingestionPipeline);
    }

    @Override
    public EntityRepository.EntityUpdater getUpdater(IngestionPipeline original, IngestionPipeline updated, EntityRepository.Operation operation) {
        return new IngestionPipelineUpdater(original, updated, operation);
    }

    @Override
    protected void postDelete(IngestionPipeline entity) {
        pipelineServiceClient.deletePipeline(entity);
    }

    public void setPipelineServiceClient(PipelineServiceClient client) {
        pipelineServiceClient = client;
    }

    private ChangeEvent getChangeEvent(EntityInterface updated, ChangeDescription change, String entityType, Double prevVersion) {
        return new ChangeEvent().withEntity((Object)updated).withChangeDescription(change).withEventType(EventType.ENTITY_UPDATED).withEntityType(entityType).withEntityId(updated.getId()).withEntityFullyQualifiedName(updated.getFullyQualifiedName()).withUserName(updated.getUpdatedBy()).withTimestamp(Long.valueOf(System.currentTimeMillis())).withCurrentVersion(updated.getVersion()).withPreviousVersion(prevVersion);
    }

    private ChangeDescription addPipelineStatusChangeDescription(Double version, Object newValue, Object oldValue) {
        FieldChange fieldChange = new FieldChange().withName("pipelineStatus").withNewValue(newValue).withOldValue(oldValue);
        ChangeDescription change = new ChangeDescription().withPreviousVersion(version);
        change.getFieldsUpdated().add(fieldChange);
        return change;
    }

    @Transaction
    public RestUtil.PutResponse<?> addPipelineStatus(UriInfo uriInfo, String fqn, PipelineStatus pipelineStatus) throws IOException {
        IngestionPipeline ingestionPipeline = (IngestionPipeline)this.dao.findEntityByName(fqn);
        PipelineStatus storedPipelineStatus = JsonUtils.readValue(this.daoCollection.entityExtensionTimeSeriesDao().getLatestExtensionByKey(RUN_ID_EXTENSION_KEY, pipelineStatus.getRunId(), ingestionPipeline.getFullyQualifiedName(), PIPELINE_STATUS_EXTENSION), PipelineStatus.class);
        if (storedPipelineStatus != null) {
            this.daoCollection.entityExtensionTimeSeriesDao().updateExtensionByKey(RUN_ID_EXTENSION_KEY, pipelineStatus.getRunId(), ingestionPipeline.getFullyQualifiedName(), PIPELINE_STATUS_EXTENSION, JsonUtils.pojoToJson(pipelineStatus));
        } else {
            this.daoCollection.entityExtensionTimeSeriesDao().insert(ingestionPipeline.getFullyQualifiedName(), PIPELINE_STATUS_EXTENSION, PIPELINE_STATUS_JSON_SCHEMA, JsonUtils.pojoToJson(pipelineStatus));
        }
        ChangeDescription change = this.addPipelineStatusChangeDescription(ingestionPipeline.getVersion(), pipelineStatus, storedPipelineStatus);
        ChangeEvent changeEvent = this.getChangeEvent((EntityInterface)this.withHref(uriInfo, ingestionPipeline), change, this.entityType, ingestionPipeline.getVersion());
        return new RestUtil.PutResponse(Response.Status.CREATED, changeEvent, "entityFieldsChanged");
    }

    public ResultList<PipelineStatus> listPipelineStatus(String ingestionPipelineFQN, Long startTs, Long endTs) throws IOException {
        IngestionPipeline ingestionPipeline = (IngestionPipeline)this.dao.findEntityByName(ingestionPipelineFQN);
        List<PipelineStatus> pipelineStatusList = JsonUtils.readObjects(this.daoCollection.entityExtensionTimeSeriesDao().listBetweenTimestampsByFQN(ingestionPipeline.getFullyQualifiedName(), PIPELINE_STATUS_JSON_SCHEMA, startTs, endTs), PipelineStatus.class);
        List allPipelineStatusList = pipelineServiceClient.getQueuedPipelineStatus(ingestionPipeline);
        allPipelineStatusList.addAll(pipelineStatusList);
        return new ResultList<PipelineStatus>(allPipelineStatusList, String.valueOf(startTs), String.valueOf(endTs), allPipelineStatusList.size());
    }

    public PipelineStatus getLatestPipelineStatus(IngestionPipeline ingestionPipeline) throws IOException {
        return JsonUtils.readValue(this.daoCollection.entityExtensionTimeSeriesDao().getLatestExtensionByFQN(ingestionPipeline.getFullyQualifiedName(), PIPELINE_STATUS_JSON_SCHEMA), PipelineStatus.class);
    }

    public PipelineStatus getPipelineStatus(String ingestionPipelineFQN, UUID pipelineStatusRunId) throws IOException {
        IngestionPipeline ingestionPipeline = (IngestionPipeline)this.dao.findEntityByName(ingestionPipelineFQN);
        return JsonUtils.readValue(this.daoCollection.entityExtensionTimeSeriesDao().getExtensionByKey(RUN_ID_EXTENSION_KEY, pipelineStatusRunId.toString(), ingestionPipeline.getFullyQualifiedName(), PIPELINE_STATUS_EXTENSION), PipelineStatus.class);
    }

    private static IngestionPipeline buildIngestionPipelineDecrypted(IngestionPipeline original) {
        IngestionPipeline decrypted = JsonUtils.convertValue(JsonUtils.getMap(original), IngestionPipeline.class);
        SecretsManagerFactory.getSecretsManager().encryptOrDecryptIngestionPipeline(decrypted, false);
        return decrypted;
    }

    public static void validateProfileSample(IngestionPipeline ingestionPipeline) throws JsonProcessingException {
        JSONObject sourceConfigJson = new JSONObject(JsonUtils.pojoToJson(ingestionPipeline.getSourceConfig().getConfig()));
        String profileSampleType = sourceConfigJson.optString("profileSampleType");
        double profileSample = sourceConfigJson.optDouble("profileSample");
        EntityUtil.validateProfileSample(profileSampleType, profileSample);
    }

    public class IngestionPipelineUpdater
    extends EntityRepository.EntityUpdater {
        public IngestionPipelineUpdater(IngestionPipeline original, IngestionPipeline updated, EntityRepository.Operation operation) {
            super((EntityRepository)IngestionPipelineRepository.this, (EntityInterface)IngestionPipelineRepository.buildIngestionPipelineDecrypted(original), (EntityInterface)updated, operation);
        }

        @Override
        public void entitySpecificUpdate() throws IOException {
            this.updateSourceConfig();
            this.updateAirflowConfig(((IngestionPipeline)this.original).getAirflowConfig(), ((IngestionPipeline)this.updated).getAirflowConfig());
            this.updateLogLevel(((IngestionPipeline)this.original).getLoggerLevel(), ((IngestionPipeline)this.updated).getLoggerLevel());
            this.updateEnabled(((IngestionPipeline)this.original).getEnabled(), ((IngestionPipeline)this.updated).getEnabled());
            this.updateDeployed(((IngestionPipeline)this.original).getDeployed(), ((IngestionPipeline)this.updated).getDeployed());
        }

        private void updateSourceConfig() throws JsonProcessingException {
            JSONObject updatedSourceConfig;
            JSONObject origSourceConfig = new JSONObject(JsonUtils.pojoToJson(((IngestionPipeline)this.original).getSourceConfig().getConfig()));
            if (!origSourceConfig.similar((Object)(updatedSourceConfig = new JSONObject(JsonUtils.pojoToJson(((IngestionPipeline)this.updated).getSourceConfig().getConfig()))))) {
                this.recordChange("sourceConfig", "old-encrypted-value", "new-encrypted-value", true);
            }
        }

        private void updateAirflowConfig(AirflowConfig origAirflowConfig, AirflowConfig updatedAirflowConfig) throws JsonProcessingException {
            if (!origAirflowConfig.equals((Object)updatedAirflowConfig)) {
                this.recordChange("airflowConfig", origAirflowConfig, updatedAirflowConfig);
            }
        }

        private void updateLogLevel(LogLevels origLevel, LogLevels updatedLevel) throws JsonProcessingException {
            if (updatedLevel != null && !origLevel.equals((Object)updatedLevel)) {
                this.recordChange("loggerLevel", origLevel, updatedLevel);
            }
        }

        private void updateDeployed(Boolean origDeployed, Boolean updatedDeployed) throws JsonProcessingException {
            if (updatedDeployed != null && !origDeployed.equals(updatedDeployed)) {
                this.recordChange("deployed", origDeployed, updatedDeployed);
            }
        }

        private void updateEnabled(Boolean origEnabled, Boolean updatedEnabled) throws JsonProcessingException {
            if (updatedEnabled != null && !origEnabled.equals(updatedEnabled)) {
                this.recordChange("enabled", origEnabled, updatedEnabled);
            }
        }
    }
}

