/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.jdbi3;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.jdbi.v3.sqlobject.transaction.Transaction;
import org.openmetadata.schema.EntityInterface;
import org.openmetadata.schema.dataInsight.ChartParameterValues;
import org.openmetadata.schema.dataInsight.DataInsightChart;
import org.openmetadata.schema.dataInsight.kpi.Kpi;
import org.openmetadata.schema.dataInsight.type.KpiResult;
import org.openmetadata.schema.dataInsight.type.KpiTarget;
import org.openmetadata.schema.type.ChangeDescription;
import org.openmetadata.schema.type.ChangeEvent;
import org.openmetadata.schema.type.DataInsightChartDataType;
import org.openmetadata.schema.type.EntityReference;
import org.openmetadata.schema.type.EventType;
import org.openmetadata.schema.type.FieldChange;
import org.openmetadata.schema.type.Include;
import org.openmetadata.schema.type.Relationship;
import org.openmetadata.service.Entity;
import org.openmetadata.service.exception.CustomExceptionMessage;
import org.openmetadata.service.exception.EntityNotFoundException;
import org.openmetadata.service.jdbi3.CollectionDAO;
import org.openmetadata.service.jdbi3.EntityRepository;
import org.openmetadata.service.util.EntityUtil;
import org.openmetadata.service.util.JsonUtils;
import org.openmetadata.service.util.RestUtil;
import org.openmetadata.service.util.ResultList;

public class KpiRepository
extends EntityRepository<Kpi> {
    public static final String COLLECTION_PATH = "/v1/kpi";
    private static final String UPDATE_FIELDS = "owner,targetDefinition,dataInsightChart,startDate,endDate,metricType";
    private static final String PATCH_FIELDS = "owner,targetDefinition,dataInsightChart,description,owner,startDate,endDate,metricType";
    public static final String KPI_RESULT_EXTENSION = "kpi.kpiResult";

    public KpiRepository(CollectionDAO dao) {
        super(COLLECTION_PATH, "kpi", Kpi.class, dao.kpiDAO(), dao, PATCH_FIELDS, UPDATE_FIELDS, null);
    }

    @Override
    public Kpi setFields(Kpi kpi, EntityUtil.Fields fields) throws IOException {
        kpi.setDataInsightChart(fields.contains("dataInsightChart") ? this.getDataInsightChart(kpi) : null);
        return kpi.withKpiResult(fields.contains("kpiResult") ? this.getKpiResult(kpi.getFullyQualifiedName()) : null);
    }

    @Override
    public void prepare(Kpi kpi) throws IOException {
        DataInsightChart chart = (DataInsightChart)Entity.getEntity(kpi.getDataInsightChart(), "metrics", Include.NON_DELETED);
        kpi.setDataInsightChart(chart.getEntityReference());
        this.validateKpiTargetDefinition(kpi.getTargetDefinition(), chart.getMetrics());
    }

    private void validateKpiTargetDefinition(List<KpiTarget> kpiTargetDef, List<ChartParameterValues> dataInsightChartMetric) {
        if (kpiTargetDef.isEmpty() && !dataInsightChartMetric.isEmpty()) {
            throw new IllegalArgumentException("Parameter Values doesn't match Kpi Definition Parameters");
        }
        HashMap<String, DataInsightChartDataType> values = new HashMap<String, DataInsightChartDataType>();
        for (ChartParameterValues parameterValue : dataInsightChartMetric) {
            values.put(parameterValue.getName(), parameterValue.getChartDataType());
        }
        for (KpiTarget kpiTarget : kpiTargetDef) {
            if (values.containsKey(kpiTarget.getName())) continue;
            throw new IllegalArgumentException("Kpi Target Definition " + kpiTarget.getName() + " is not valid, metric not defined in corresponding chart");
        }
    }

    @Override
    public void storeEntity(Kpi kpi, boolean update) throws IOException {
        EntityReference dataInsightChart = kpi.getDataInsightChart();
        KpiResult kpiResults = kpi.getKpiResult();
        kpi.withDataInsightChart(null).withKpiResult(null);
        this.store(kpi, update);
        kpi.withDataInsightChart(dataInsightChart).withKpiResult(kpiResults);
    }

    @Override
    public void storeRelationships(Kpi kpi) {
        this.addRelationship(kpi.getId(), kpi.getDataInsightChart().getId(), "kpi", "dataInsightChart", Relationship.USES);
        this.storeOwner(kpi, kpi.getOwner());
    }

    @Transaction
    public RestUtil.PutResponse<?> addKpiResult(UriInfo uriInfo, String fqn, KpiResult kpiResult) throws IOException {
        Kpi kpi = (Kpi)this.dao.findEntityByName(fqn);
        KpiResult storedKpiResult = JsonUtils.readValue(this.daoCollection.entityExtensionTimeSeriesDao().getExtensionAtTimestamp(kpi.getFullyQualifiedName(), KPI_RESULT_EXTENSION, kpiResult.getTimestamp()), KpiResult.class);
        if (storedKpiResult != null) {
            this.daoCollection.entityExtensionTimeSeriesDao().update(kpi.getFullyQualifiedName(), KPI_RESULT_EXTENSION, JsonUtils.pojoToJson(kpiResult), kpiResult.getTimestamp());
        } else {
            this.daoCollection.entityExtensionTimeSeriesDao().insert(kpi.getFullyQualifiedName(), KPI_RESULT_EXTENSION, "kpiResult", JsonUtils.pojoToJson(kpiResult));
        }
        ChangeDescription change = this.addKpiResultChangeDescription(kpi.getVersion(), kpiResult, storedKpiResult);
        ChangeEvent changeEvent = this.getChangeEvent((EntityInterface)this.withHref(uriInfo, kpi), change, this.entityType, kpi.getVersion());
        return new RestUtil.PutResponse(Response.Status.CREATED, changeEvent, "entityFieldsChanged");
    }

    @Transaction
    public RestUtil.PutResponse<?> deleteKpiResult(String fqn, Long timestamp) throws IOException {
        Kpi kpi = (Kpi)this.dao.findEntityByName(fqn);
        KpiResult storedKpiResult = JsonUtils.readValue(this.daoCollection.entityExtensionTimeSeriesDao().getExtensionAtTimestamp(fqn, KPI_RESULT_EXTENSION, timestamp), KpiResult.class);
        if (storedKpiResult != null) {
            this.daoCollection.entityExtensionTimeSeriesDao().deleteAtTimestamp(fqn, KPI_RESULT_EXTENSION, timestamp);
            kpi.setKpiResult(storedKpiResult);
            ChangeDescription change = this.deleteKpiChangeDescription(kpi.getVersion(), storedKpiResult);
            ChangeEvent changeEvent = this.getChangeEvent((EntityInterface)kpi, change, this.entityType, kpi.getVersion());
            return new RestUtil.PutResponse(Response.Status.OK, changeEvent, "entityFieldsChanged");
        }
        throw new EntityNotFoundException(String.format("Failed to find kpi result for %s at %s", kpi.getName(), timestamp));
    }

    private ChangeDescription addKpiResultChangeDescription(Double version, Object newValue, Object oldValue) {
        FieldChange fieldChange = new FieldChange().withName("kpiResult").withNewValue(newValue).withOldValue(oldValue);
        ChangeDescription change = new ChangeDescription().withPreviousVersion(version);
        change.getFieldsUpdated().add(fieldChange);
        return change;
    }

    private ChangeDescription deleteKpiChangeDescription(Double version, Object oldValue) {
        FieldChange fieldChange = new FieldChange().withName("kpiResult").withOldValue(oldValue);
        ChangeDescription change = new ChangeDescription().withPreviousVersion(version);
        change.getFieldsDeleted().add(fieldChange);
        return change;
    }

    private EntityReference getDataInsightChart(Kpi kpi) throws IOException {
        return this.getToEntityRef(kpi.getId(), Relationship.USES, "dataInsightChart", true);
    }

    public void validateDataInsightChartOneToOneMapping(UUID chartId) {
        List<CollectionDAO.EntityRelationshipRecord> record = this.findTo(chartId, "dataInsightChart", Relationship.USES, "kpi");
        if (record.size() > 0 && !chartId.equals(record.get(0).getId())) {
            throw new CustomExceptionMessage(Response.Status.BAD_REQUEST, "Chart Already has a mapped Kpi.");
        }
    }

    public KpiResult getKpiResult(String fqn) throws IOException {
        return JsonUtils.readValue(this.daoCollection.entityExtensionTimeSeriesDao().getLatestExtension(fqn, KPI_RESULT_EXTENSION), KpiResult.class);
    }

    public ResultList<KpiResult> getKpiResults(String fqn, Long startTs, Long endTs, CollectionDAO.EntityExtensionTimeSeriesDAO.OrderBy orderBy) throws IOException {
        List<KpiResult> kpiResults = JsonUtils.readObjects(this.daoCollection.entityExtensionTimeSeriesDao().listBetweenTimestampsByOrder(fqn, KPI_RESULT_EXTENSION, startTs, endTs, orderBy), KpiResult.class);
        return new ResultList<KpiResult>(kpiResults, String.valueOf(startTs), String.valueOf(endTs), kpiResults.size());
    }

    private ChangeEvent getChangeEvent(EntityInterface updated, ChangeDescription change, String entityType, Double prevVersion) {
        return new ChangeEvent().withEntity((Object)updated).withChangeDescription(change).withEventType(EventType.ENTITY_UPDATED).withEntityType(entityType).withEntityId(updated.getId()).withEntityFullyQualifiedName(updated.getFullyQualifiedName()).withUserName(updated.getUpdatedBy()).withTimestamp(Long.valueOf(System.currentTimeMillis())).withCurrentVersion(updated.getVersion()).withPreviousVersion(prevVersion);
    }

    @Override
    public EntityRepository.EntityUpdater getUpdater(Kpi original, Kpi updated, EntityRepository.Operation operation) {
        return new KpiUpdater(original, updated, operation);
    }

    public class KpiUpdater
    extends EntityRepository.EntityUpdater {
        public KpiUpdater(Kpi original, Kpi updated, EntityRepository.Operation operation) {
            super((EntityRepository)KpiRepository.this, (EntityInterface)original, (EntityInterface)updated, operation);
        }

        @Override
        public void entitySpecificUpdate() throws IOException {
            this.updateToRelationship("dataInsightChart", "kpi", ((Kpi)this.original).getId(), Relationship.USES, "dataInsightChart", ((Kpi)this.original).getDataInsightChart(), ((Kpi)this.updated).getDataInsightChart(), false);
            this.recordChange("targetDefinition", ((Kpi)this.original).getTargetDefinition(), ((Kpi)this.updated).getTargetDefinition());
            this.recordChange("startDate", ((Kpi)this.original).getStartDate(), ((Kpi)this.updated).getStartDate());
            this.recordChange("endDate", ((Kpi)this.original).getEndDate(), ((Kpi)this.updated).getEndDate());
            this.recordChange("metricType", ((Kpi)this.original).getMetricType(), ((Kpi)this.updated).getMetricType());
        }
    }
}

