/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.resources.settings;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.concurrent.TimeUnit;
import javax.annotation.CheckForNull;
import org.openmetadata.schema.email.SmtpSettings;
import org.openmetadata.schema.settings.Settings;
import org.openmetadata.schema.settings.SettingsType;
import org.openmetadata.service.OpenMetadataApplicationConfig;
import org.openmetadata.service.jdbi3.CollectionDAO;
import org.openmetadata.service.jdbi3.SystemRepository;
import org.openmetadata.service.util.JsonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SettingsCache {
    private static final Logger LOG = LoggerFactory.getLogger(SettingsCache.class);
    private static final SettingsCache INSTANCE = new SettingsCache();
    private static volatile boolean INITIALIZED = false;
    protected static LoadingCache<String, Settings> SETTINGS_CACHE;
    protected static SystemRepository systemRepository;

    public static void initialize(CollectionDAO dao, OpenMetadataApplicationConfig config) {
        if (!INITIALIZED) {
            SETTINGS_CACHE = CacheBuilder.newBuilder().maximumSize(1000L).expireAfterWrite(3L, TimeUnit.MINUTES).build((CacheLoader)new SettingsLoader());
            systemRepository = new SystemRepository(dao.systemDAO());
            INITIALIZED = true;
            SettingsCache.createEmailConfiguration(config);
        }
    }

    private static void createEmailConfiguration(OpenMetadataApplicationConfig applicationConfig) {
        Settings storedSettings = systemRepository.getConfigWithKey(SettingsType.EMAIL_CONFIGURATION.toString());
        if (storedSettings == null) {
            SmtpSettings emailConfig = applicationConfig.getSmtpSettings();
            Settings setting = new Settings().withConfigType(SettingsType.EMAIL_CONFIGURATION).withConfigValue((Object)emailConfig);
            systemRepository.createNewSetting(setting);
        }
    }

    public static SettingsCache getInstance() {
        return INSTANCE;
    }

    public <T> T getSetting(SettingsType settingName, Class<T> clazz) throws RuntimeException {
        try {
            String json = JsonUtils.pojoToJson(((Settings)SETTINGS_CACHE.get((Object)settingName.toString())).getConfigValue());
            return JsonUtils.readValue(json, clazz);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public static void cleanUp() {
        SETTINGS_CACHE.invalidateAll();
        INITIALIZED = false;
    }

    public void invalidateSettings(String settingsName) {
        try {
            SETTINGS_CACHE.invalidate((Object)settingsName);
        }
        catch (Exception ex) {
            LOG.error("Failed to invalidate cache for settings {}", (Object)settingsName, (Object)ex);
        }
    }

    static class SettingsLoader
    extends CacheLoader<String, Settings> {
        SettingsLoader() {
        }

        public Settings load(@CheckForNull String settingsName) {
            Settings fetchedSettings;
            if (SettingsType.EMAIL_CONFIGURATION.value().equals(settingsName)) {
                fetchedSettings = systemRepository.getEmailConfigInternal();
                LOG.info("Loaded Email Setting");
            } else {
                fetchedSettings = systemRepository.getConfigWithKey(settingsName);
                LOG.info("Loaded Setting {}", (Object)fetchedSettings.getConfigType());
            }
            return fetchedSettings;
        }
    }
}

