/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.secrets.masker;

import com.google.common.annotations.VisibleForTesting;
import org.openmetadata.schema.security.SecurityConfiguration;
import org.openmetadata.service.secrets.masker.EntityMasker;
import org.openmetadata.service.secrets.masker.NoopEntityMasker;
import org.openmetadata.service.secrets.masker.PasswordEntityMasker;

public class EntityMaskerFactory {
    private static EntityMasker entityMasker;

    private EntityMaskerFactory() {
    }

    public static EntityMasker createEntityMasker(SecurityConfiguration config) {
        if (entityMasker != null) {
            return entityMasker;
        }
        entityMasker = Boolean.TRUE.equals(config.getMaskPasswordsAPI()) ? PasswordEntityMasker.getInstance() : NoopEntityMasker.getInstance();
        return entityMasker;
    }

    @VisibleForTesting
    public static void setEntityMasker(EntityMasker entityMasker) {
        EntityMaskerFactory.entityMasker = entityMasker;
    }

    public static EntityMasker getEntityMasker() {
        return entityMasker;
    }
}

