/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.secrets.masker;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.openmetadata.annotations.PasswordField;
import org.openmetadata.schema.entity.automations.Workflow;
import org.openmetadata.schema.entity.services.ServiceType;
import org.openmetadata.schema.entity.services.ingestionPipelines.IngestionPipeline;
import org.openmetadata.schema.entity.teams.AuthenticationMechanism;
import org.openmetadata.service.exception.EntityMaskException;
import org.openmetadata.service.fernet.Fernet;
import org.openmetadata.service.secrets.SecretsUtil;
import org.openmetadata.service.secrets.converter.ClassConverterFactory;
import org.openmetadata.service.secrets.masker.EntityMasker;
import org.openmetadata.service.util.AuthenticationMechanismBuilder;
import org.openmetadata.service.util.IngestionPipelineBuilder;
import org.openmetadata.service.util.ReflectionUtil;

public class PasswordEntityMasker
extends EntityMasker {
    private static PasswordEntityMasker INSTANCE;
    protected static final String PASSWORD_MASK = "*********";
    private static final String NEW_KEY = "";

    private PasswordEntityMasker() {
    }

    public static PasswordEntityMasker getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new PasswordEntityMasker();
        }
        return INSTANCE;
    }

    @Override
    public Object maskServiceConnectionConfig(Object connectionConfig, String connectionType, ServiceType serviceType) {
        if (connectionConfig != null) {
            try {
                Class<?> clazz = ReflectionUtil.createConnectionConfigClass(connectionType, serviceType);
                Object convertedConnectionConfig = ClassConverterFactory.getConverter(clazz).convert(connectionConfig);
                this.maskPasswordFields(convertedConnectionConfig);
                return convertedConnectionConfig;
            }
            catch (Exception e) {
                String message = SecretsUtil.buildExceptionMessageConnectionMask(e.getMessage(), connectionType, true);
                if (message != null) {
                    throw new EntityMaskException(message);
                }
                throw new EntityMaskException(String.format("Failed to mask connection instance of %s", connectionType));
            }
        }
        return null;
    }

    @Override
    public void maskAuthenticationMechanism(String name, AuthenticationMechanism authenticationMechanism) {
        if (authenticationMechanism != null) {
            AuthenticationMechanismBuilder.addDefinedConfig(authenticationMechanism);
            try {
                this.maskPasswordFields(authenticationMechanism);
            }
            catch (Exception e) {
                throw new EntityMaskException(String.format("Failed to mask user bot instance [%s]", name));
            }
        }
    }

    @Override
    public void maskIngestionPipeline(IngestionPipeline ingestionPipeline) {
        if (ingestionPipeline != null) {
            IngestionPipelineBuilder.addDefinedConfig(ingestionPipeline);
            try {
                this.maskPasswordFields(ingestionPipeline);
            }
            catch (Exception e) {
                throw new EntityMaskException(String.format("Failed to mask ingestion pipeline instance [%s]", ingestionPipeline.getName()));
            }
        }
    }

    @Override
    public Workflow maskWorkflow(Workflow workflow) {
        if (workflow != null) {
            Workflow workflowConverted = (Workflow)ClassConverterFactory.getConverter(Workflow.class).convert(workflow);
            try {
                this.maskPasswordFields(workflowConverted);
            }
            catch (Exception e) {
                throw new EntityMaskException(String.format("Failed to mask workflow instance [%s]", workflow.getName()));
            }
            return workflowConverted;
        }
        return null;
    }

    @Override
    public Object unmaskServiceConnectionConfig(Object connectionConfig, Object originalConnectionConfig, String connectionType, ServiceType serviceType) {
        if (originalConnectionConfig != null && connectionConfig != null) {
            try {
                Class<?> clazz = ReflectionUtil.createConnectionConfigClass(connectionType, serviceType);
                Object toUnmaskConfig = ClassConverterFactory.getConverter(clazz).convert(connectionConfig);
                Object originalConvertedConfig = ClassConverterFactory.getConverter(clazz).convert(originalConnectionConfig);
                HashMap<String, String> passwordsMap = new HashMap<String, String>();
                this.buildPasswordsMap(originalConvertedConfig, NEW_KEY, passwordsMap);
                this.unmaskPasswordFields(toUnmaskConfig, NEW_KEY, passwordsMap);
                return toUnmaskConfig;
            }
            catch (Exception e) {
                String message = SecretsUtil.buildExceptionMessageConnectionMask(e.getMessage(), connectionType, false);
                if (message != null) {
                    throw new EntityMaskException(message);
                }
                throw new EntityMaskException(String.format("Failed to unmask connection instance of %s", connectionType));
            }
        }
        return connectionConfig;
    }

    @Override
    public void unmaskIngestionPipeline(IngestionPipeline ingestionPipeline, IngestionPipeline originalIngestionPipeline) {
        if (ingestionPipeline != null && originalIngestionPipeline != null) {
            IngestionPipelineBuilder.addDefinedConfig(ingestionPipeline);
            IngestionPipelineBuilder.addDefinedConfig(originalIngestionPipeline);
            try {
                HashMap<String, String> passwordsMap = new HashMap<String, String>();
                this.buildPasswordsMap(originalIngestionPipeline, NEW_KEY, passwordsMap);
                this.unmaskPasswordFields(ingestionPipeline, NEW_KEY, passwordsMap);
            }
            catch (Exception e) {
                throw new EntityMaskException(String.format("Failed to unmask ingestion pipeline instance [%s]", ingestionPipeline.getName()));
            }
        }
    }

    @Override
    public void unmaskAuthenticationMechanism(String name, AuthenticationMechanism authenticationMechanism, AuthenticationMechanism originalAuthenticationMechanism) {
        if (authenticationMechanism != null && originalAuthenticationMechanism != null) {
            AuthenticationMechanismBuilder.addDefinedConfig(authenticationMechanism);
            AuthenticationMechanismBuilder.addDefinedConfig(originalAuthenticationMechanism);
            try {
                HashMap<String, String> passwordsMap = new HashMap<String, String>();
                this.buildPasswordsMap(originalAuthenticationMechanism, NEW_KEY, passwordsMap);
                this.unmaskPasswordFields(authenticationMechanism, NEW_KEY, passwordsMap);
            }
            catch (Exception e) {
                throw new EntityMaskException(String.format("Failed to unmask auth mechanism instance [%s]", name));
            }
        }
    }

    @Override
    public Workflow unmaskWorkflow(Workflow workflow, Workflow originalWorkflow) {
        if (workflow != null && originalWorkflow != null) {
            Workflow workflowConverted = (Workflow)ClassConverterFactory.getConverter(Workflow.class).convert(workflow);
            Workflow origWorkflowConverted = (Workflow)ClassConverterFactory.getConverter(Workflow.class).convert(originalWorkflow);
            try {
                HashMap<String, String> passwordsMap = new HashMap<String, String>();
                this.buildPasswordsMap(origWorkflowConverted, NEW_KEY, passwordsMap);
                this.unmaskPasswordFields(workflowConverted, NEW_KEY, passwordsMap);
                return workflowConverted;
            }
            catch (Exception e) {
                throw new EntityMaskException(String.format("Failed to unmask workflow instance [%s]", workflow.getName()));
            }
        }
        return workflow;
    }

    private void maskPasswordFields(Object toMaskObject) {
        if (!DO_NOT_MASK_CLASSES.contains(toMaskObject.getClass())) {
            Arrays.stream(toMaskObject.getClass().getMethods()).filter(ReflectionUtil::isGetMethodOfObject).forEach(method -> {
                Object obj = ReflectionUtil.getObjectFromMethod(method, toMaskObject);
                String fieldName = method.getName().replaceFirst("get", NEW_KEY);
                if (obj != null && obj.getClass().getPackageName().startsWith("org.openmetadata")) {
                    this.maskPasswordFields(obj);
                } else if (obj != null && method.getAnnotation(PasswordField.class) != null) {
                    Method toSet = ReflectionUtil.getToSetMethod(toMaskObject, obj, fieldName);
                    ReflectionUtil.setValueInMethod(toMaskObject, PASSWORD_MASK, toSet);
                }
            });
        }
    }

    private void unmaskPasswordFields(Object toUnmaskObject, String key, Map<String, String> passwordsMap) {
        if (!DO_NOT_MASK_CLASSES.contains(toUnmaskObject.getClass())) {
            Arrays.stream(toUnmaskObject.getClass().getMethods()).filter(ReflectionUtil::isGetMethodOfObject).forEach(method -> {
                Object obj = ReflectionUtil.getObjectFromMethod(method, toUnmaskObject);
                String fieldName = method.getName().replaceFirst("get", NEW_KEY);
                if (obj != null && obj.getClass().getPackageName().startsWith("org.openmetadata")) {
                    this.unmaskPasswordFields(obj, this.createKey(key, fieldName), passwordsMap);
                } else if (obj != null && method.getAnnotation(PasswordField.class) != null) {
                    String valueToSet = PASSWORD_MASK.equals(obj) ? passwordsMap.getOrDefault(this.createKey(key, fieldName), PASSWORD_MASK) : Fernet.getInstance().decryptIfApplies((String)obj);
                    Method toSet = ReflectionUtil.getToSetMethod(toUnmaskObject, obj, fieldName);
                    ReflectionUtil.setValueInMethod(toUnmaskObject, valueToSet, toSet);
                }
            });
        }
    }

    private void buildPasswordsMap(Object toMapObject, String key, Map<String, String> passwordsMap) {
        if (!DO_NOT_MASK_CLASSES.contains(toMapObject.getClass())) {
            Arrays.stream(toMapObject.getClass().getMethods()).filter(ReflectionUtil::isGetMethodOfObject).forEach(method -> {
                Object obj = ReflectionUtil.getObjectFromMethod(method, toMapObject);
                String fieldName = method.getName().replaceFirst("get", NEW_KEY);
                if (obj != null && obj.getClass().getPackageName().startsWith("org.openmetadata")) {
                    this.buildPasswordsMap(obj, this.createKey(key, fieldName), passwordsMap);
                } else if (obj != null && method.getAnnotation(PasswordField.class) != null) {
                    String value = Fernet.getInstance().decryptIfApplies((String)obj);
                    passwordsMap.put(this.createKey(key, fieldName), value);
                }
            });
        }
    }

    private String createKey(String previousKey, String key) {
        if (NEW_KEY.equals(previousKey)) {
            return key;
        }
        return previousKey + "." + key;
    }
}

