/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.util;

import java.security.KeyStoreException;
import javax.net.ssl.SSLContext;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.nio.client.HttpAsyncClientBuilder;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestClientBuilder;
import org.elasticsearch.client.RestHighLevelClient;
import org.openmetadata.schema.service.configuration.elasticsearch.ElasticSearchConfiguration;
import org.openmetadata.service.util.SSLUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ElasticSearchClientUtils {
    private static final Logger LOG = LoggerFactory.getLogger(ElasticSearchClientUtils.class);

    private ElasticSearchClientUtils() {
    }

    public static RestHighLevelClient createElasticSearchClient(ElasticSearchConfiguration esConfig) {
        try {
            RestClientBuilder restClientBuilder = RestClient.builder((HttpHost[])new HttpHost[]{new HttpHost(esConfig.getHost(), esConfig.getPort().intValue(), esConfig.getScheme())});
            if (StringUtils.isNotEmpty((CharSequence)esConfig.getUsername()) && StringUtils.isNotEmpty((CharSequence)esConfig.getPassword())) {
                BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
                credentialsProvider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(esConfig.getUsername(), esConfig.getPassword()));
                SSLContext sslContext = ElasticSearchClientUtils.createElasticSearchSSLContext(esConfig);
                restClientBuilder.setHttpClientConfigCallback(arg_0 -> ElasticSearchClientUtils.lambda$createElasticSearchClient$0((CredentialsProvider)credentialsProvider, sslContext, arg_0));
            }
            restClientBuilder.setRequestConfigCallback(requestConfigBuilder -> requestConfigBuilder.setConnectTimeout(esConfig.getConnectionTimeoutSecs() * 1000).setSocketTimeout(esConfig.getSocketTimeoutSecs() * 1000));
            return new RestHighLevelClient(restClientBuilder);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to create elastic search client ", e);
        }
    }

    private static SSLContext createElasticSearchSSLContext(ElasticSearchConfiguration elasticSearchConfiguration) throws KeyStoreException {
        if (elasticSearchConfiguration.getScheme().equals("https")) {
            return SSLUtil.createSSLContext(elasticSearchConfiguration.getTruststorePath(), elasticSearchConfiguration.getTruststorePassword(), "ElasticSearch");
        }
        return null;
    }

    private static /* synthetic */ HttpAsyncClientBuilder lambda$createElasticSearchClient$0(CredentialsProvider credentialsProvider, SSLContext sslContext, HttpAsyncClientBuilder httpAsyncClientBuilder) {
        httpAsyncClientBuilder.setDefaultCredentialsProvider(credentialsProvider);
        if (sslContext != null) {
            httpAsyncClientBuilder.setSSLContext(sslContext);
        }
        return httpAsyncClientBuilder;
    }
}

