/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.elasticsearch;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.openmetadata.schema.EntityInterface;
import org.openmetadata.schema.entity.data.MlModel;
import org.openmetadata.service.Entity;
import org.openmetadata.service.elasticsearch.ElasticSearchIndex;
import org.openmetadata.service.elasticsearch.ElasticSearchIndexUtils;
import org.openmetadata.service.elasticsearch.ElasticSearchSuggest;
import org.openmetadata.service.elasticsearch.ParseTags;
import org.openmetadata.service.util.JsonUtils;

public class MlModelIndex
implements ElasticSearchIndex {
    final MlModel mlModel;
    final List<String> excludeFields = List.of("changeDescription");

    public MlModelIndex(MlModel mlModel) {
        this.mlModel = mlModel;
    }

    @Override
    public Map<String, Object> buildESDoc() {
        Map<String, Object> doc = JsonUtils.getMap(this.mlModel);
        ArrayList<ElasticSearchSuggest> suggest = new ArrayList<ElasticSearchSuggest>();
        ElasticSearchIndexUtils.removeNonIndexableFields(doc, this.excludeFields);
        suggest.add(ElasticSearchSuggest.builder().input(this.mlModel.getFullyQualifiedName()).weight(5).build());
        suggest.add(ElasticSearchSuggest.builder().input(this.mlModel.getName()).weight(10).build());
        ParseTags parseTags = new ParseTags(Entity.getEntityTags("mlmodel", (EntityInterface)this.mlModel));
        doc.put("displayName", this.mlModel.getDisplayName() != null ? this.mlModel.getDisplayName() : this.mlModel.getName());
        doc.put("tags", parseTags.tags);
        doc.put("tier", parseTags.tierTag);
        doc.put("followers", ElasticSearchIndexUtils.parseFollowers(this.mlModel.getFollowers()));
        doc.put("suggest", suggest);
        doc.put("entityType", "mlmodel");
        doc.put("serviceType", this.mlModel.getServiceType());
        return doc;
    }
}

