/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.elasticsearch;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.openmetadata.schema.EntityInterface;
import org.openmetadata.schema.entity.data.Pipeline;
import org.openmetadata.schema.type.Task;
import org.openmetadata.service.Entity;
import org.openmetadata.service.elasticsearch.ElasticSearchIndex;
import org.openmetadata.service.elasticsearch.ElasticSearchIndexUtils;
import org.openmetadata.service.elasticsearch.ElasticSearchSuggest;
import org.openmetadata.service.elasticsearch.ParseTags;
import org.openmetadata.service.util.JsonUtils;

public class PipelineIndex
implements ElasticSearchIndex {
    final Pipeline pipeline;
    final List<String> excludeFields = List.of("changeDescription");

    public PipelineIndex(Pipeline pipeline) {
        this.pipeline = pipeline;
    }

    @Override
    public Map<String, Object> buildESDoc() {
        Map<String, Object> doc = JsonUtils.getMap(this.pipeline);
        ElasticSearchIndexUtils.removeNonIndexableFields(doc, this.excludeFields);
        ArrayList<ElasticSearchSuggest> suggest = new ArrayList<ElasticSearchSuggest>();
        ArrayList<ElasticSearchSuggest> serviceSuggest = new ArrayList<ElasticSearchSuggest>();
        ArrayList<ElasticSearchSuggest> taskSuggest = new ArrayList<ElasticSearchSuggest>();
        suggest.add(ElasticSearchSuggest.builder().input(this.pipeline.getFullyQualifiedName()).weight(5).build());
        suggest.add(ElasticSearchSuggest.builder().input(this.pipeline.getDisplayName()).weight(10).build());
        serviceSuggest.add(ElasticSearchSuggest.builder().input(this.pipeline.getService().getName()).weight(5).build());
        if (this.pipeline.getTasks() != null) {
            for (Task task : this.pipeline.getTasks()) {
                taskSuggest.add(ElasticSearchSuggest.builder().input(task.getName()).weight(5).build());
            }
        }
        ParseTags parseTags = new ParseTags(Entity.getEntityTags("pipeline", (EntityInterface)this.pipeline));
        doc.put("name", this.pipeline.getName() != null ? this.pipeline.getName() : this.pipeline.getDisplayName());
        doc.put("displayName", this.pipeline.getDisplayName() != null ? this.pipeline.getDisplayName() : this.pipeline.getName());
        doc.put("followers", ElasticSearchIndexUtils.parseFollowers(this.pipeline.getFollowers()));
        doc.put("tags", parseTags.tags);
        doc.put("tier", parseTags.tierTag);
        doc.put("suggest", suggest);
        doc.put("task_suggest", taskSuggest);
        doc.put("service_suggest", serviceSuggest);
        doc.put("entityType", "pipeline");
        doc.put("serviceType", this.pipeline.getServiceType());
        return doc;
    }
}

