/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.elasticsearch;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.openmetadata.schema.EntityInterface;
import org.openmetadata.schema.entity.data.Table;
import org.openmetadata.service.Entity;
import org.openmetadata.service.elasticsearch.ColumnIndex;
import org.openmetadata.service.elasticsearch.ElasticSearchIndexUtils;
import org.openmetadata.service.elasticsearch.ElasticSearchSuggest;
import org.openmetadata.service.elasticsearch.FlattenColumn;
import org.openmetadata.service.elasticsearch.ParseTags;
import org.openmetadata.service.util.JsonUtils;

public class TableIndex
implements ColumnIndex {
    private static final List<String> excludeFields = List.of("sampleData", "tableProfile", "joins", "changeDescription", "viewDefinition, tableProfilerConfig, profile, location, tableQueries, tests, dataModel");
    final Table table;

    public TableIndex(Table table) {
        this.table = table;
    }

    @Override
    public Map<String, Object> buildESDoc() {
        Map<String, Object> doc = JsonUtils.getMap(this.table);
        ArrayList<ElasticSearchSuggest> suggest = new ArrayList<ElasticSearchSuggest>();
        ArrayList<ElasticSearchSuggest> columnSuggest = new ArrayList<ElasticSearchSuggest>();
        ArrayList<ElasticSearchSuggest> schemaSuggest = new ArrayList<ElasticSearchSuggest>();
        ArrayList<ElasticSearchSuggest> databaseSuggest = new ArrayList<ElasticSearchSuggest>();
        ArrayList<ElasticSearchSuggest> serviceSuggest = new ArrayList<ElasticSearchSuggest>();
        ElasticSearchIndexUtils.removeNonIndexableFields(doc, excludeFields);
        if (this.table.getColumns() != null) {
            ArrayList<FlattenColumn> cols = new ArrayList<FlattenColumn>();
            this.parseColumns(this.table.getColumns(), cols, null);
            for (FlattenColumn col : cols) {
                columnSuggest.add(ElasticSearchSuggest.builder().input(col.getName()).weight(5).build());
            }
        }
        this.parseTableSuggest(suggest);
        serviceSuggest.add(ElasticSearchSuggest.builder().input(this.table.getService().getName()).weight(5).build());
        databaseSuggest.add(ElasticSearchSuggest.builder().input(this.table.getDatabase().getName()).weight(5).build());
        schemaSuggest.add(ElasticSearchSuggest.builder().input(this.table.getDatabaseSchema().getName()).weight(5).build());
        ParseTags parseTags = new ParseTags(Entity.getEntityTags("table", (EntityInterface)this.table));
        doc.put("displayName", this.table.getDisplayName() != null ? this.table.getDisplayName() : this.table.getName());
        doc.put("tags", parseTags.tags);
        doc.put("tier", parseTags.tierTag);
        doc.put("followers", ElasticSearchIndexUtils.parseFollowers(this.table.getFollowers()));
        doc.put("suggest", suggest);
        doc.put("service_suggest", serviceSuggest);
        doc.put("column_suggest", columnSuggest);
        doc.put("schema_suggest", schemaSuggest);
        doc.put("database_suggest", databaseSuggest);
        doc.put("entityType", "table");
        doc.put("serviceType", this.table.getServiceType());
        return doc;
    }

    private void parseTableSuggest(List<ElasticSearchSuggest> suggest) {
        suggest.add(ElasticSearchSuggest.builder().input(this.table.getFullyQualifiedName()).weight(5).build());
        suggest.add(ElasticSearchSuggest.builder().input(this.table.getName()).weight(10).build());
        String[] fqnPartsWithoutService = this.table.getFullyQualifiedName().split(Pattern.quote("."), 2);
        if (fqnPartsWithoutService.length == 2) {
            suggest.add(ElasticSearchSuggest.builder().input(fqnPartsWithoutService[1]).weight(5).build());
            String[] fqnPartsWithoutDB = fqnPartsWithoutService[1].split(Pattern.quote("."), 2);
            if (fqnPartsWithoutDB.length == 2) {
                suggest.add(ElasticSearchSuggest.builder().input(fqnPartsWithoutDB[1]).weight(5).build());
            }
        }
    }
}

