/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.events.scheduled;

import java.io.IOException;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.core.Response;
import org.elasticsearch.client.RestHighLevelClient;
import org.openmetadata.schema.api.events.CreateEventSubscription;
import org.openmetadata.schema.entity.events.EventSubscription;
import org.openmetadata.schema.entity.events.TriggerConfig;
import org.openmetadata.service.events.scheduled.DataInsightsReportJob;
import org.openmetadata.service.jdbi3.CollectionDAO;
import org.openmetadata.service.jdbi3.DataInsightChartRepository;
import org.openmetadata.service.util.SubscriptionUtil;
import org.quartz.JobBuilder;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.impl.StdSchedulerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReportsHandler {
    private static final Logger LOG = LoggerFactory.getLogger(ReportsHandler.class);
    public static final String DATA_INSIGHT_EMAIL_JOB = "dataInsightEmailJob";
    public static final String EMAIL_REPORT = "emailReport";
    public static final String CRON_TRIGGER = "dataInsightEmailTrigger";
    public static final String JOB_CONTEXT_CHART_REPO = "dataInsightChartRepository";
    public static final String ES_REST_CLIENT = "esRestClient";
    private final RestHighLevelClient restHighLevelClient;
    private final DataInsightChartRepository chartRepository;
    private static ReportsHandler INSTANCE;
    private static volatile boolean INITIALIZED;
    private final Scheduler reportScheduler = new StdSchedulerFactory().getScheduler();
    private static final ConcurrentHashMap<UUID, JobDetail> reportJobKeyMap;

    private ReportsHandler(CollectionDAO dao, RestHighLevelClient restHighLevelClient) throws SchedulerException {
        this.restHighLevelClient = restHighLevelClient;
        this.chartRepository = new DataInsightChartRepository(dao);
        this.reportScheduler.start();
    }

    public static ReportsHandler getInstance() {
        if (INITIALIZED) {
            return INSTANCE;
        }
        throw new RuntimeException("Reports Job Handler is not Initialized");
    }

    public ConcurrentHashMap<UUID, JobDetail> getReportMap() {
        return reportJobKeyMap;
    }

    public static void initialize(CollectionDAO dao, RestHighLevelClient restHighLevelClient) throws SchedulerException {
        if (!INITIALIZED) {
            INSTANCE = new ReportsHandler(dao, restHighLevelClient);
            INITIALIZED = true;
        } else {
            LOG.info("Reindexing Handler is already initialized");
        }
    }

    public void addDataReportConfig(EventSubscription dataReport) {
        try {
            JobDetail jobDetail = this.jobBuilder(dataReport);
            Trigger trigger = this.trigger(dataReport.getTrigger());
            this.reportScheduler.scheduleJob(jobDetail, trigger);
            reportJobKeyMap.put(dataReport.getId(), jobDetail);
        }
        catch (Exception ex) {
            LOG.error("Failed in setting up job Scheduler for Data Reporting", (Throwable)ex);
        }
    }

    public void updateDataReportConfig(EventSubscription dataReport) throws SchedulerException {
        this.deleteDataReportConfig(dataReport);
        this.addDataReportConfig(dataReport);
    }

    public void deleteDataReportConfig(EventSubscription dataReport) throws SchedulerException {
        JobDetail jobDetail = this.getJobKey(dataReport.getId());
        if (jobDetail != null) {
            this.reportScheduler.deleteJob(jobDetail.getKey());
            reportJobKeyMap.remove(dataReport.getId());
        }
    }

    private JobDetail jobBuilder(EventSubscription subscription) throws IOException {
        if (subscription.getAlertType() == CreateEventSubscription.AlertType.DATA_INSIGHT_REPORT) {
            JobDataMap dataMap = new JobDataMap();
            dataMap.put(JOB_CONTEXT_CHART_REPO, (Object)this.chartRepository);
            dataMap.put(ES_REST_CLIENT, (Object)this.restHighLevelClient);
            dataMap.put("eventsubscription", (Object)subscription);
            JobBuilder jobBuilder = JobBuilder.newJob(DataInsightsReportJob.class).withIdentity(DATA_INSIGHT_EMAIL_JOB, EMAIL_REPORT).usingJobData(dataMap);
            return jobBuilder.build();
        }
        throw new IOException("Invalid Report Type");
    }

    private Trigger trigger(TriggerConfig trigger) {
        return TriggerBuilder.newTrigger().withIdentity(CRON_TRIGGER, EMAIL_REPORT).withSchedule((ScheduleBuilder)SubscriptionUtil.getCronSchedule(trigger)).build();
    }

    private JobDetail getJobKey(UUID id) {
        return reportJobKeyMap.get(id);
    }

    public static void shutDown() throws SchedulerException {
        if (INSTANCE != null) {
            ReportsHandler.INSTANCE.reportScheduler.shutdown();
        }
    }

    public Response triggerExistingDataInsightJob(EventSubscription dataReport) throws SchedulerException {
        JobDetail jobDetail = this.getJobKey(dataReport.getId());
        if (jobDetail != null) {
            JobDataMap dataMap = new JobDataMap();
            dataMap.put(JOB_CONTEXT_CHART_REPO, (Object)this.chartRepository);
            dataMap.put(ES_REST_CLIENT, (Object)this.restHighLevelClient);
            dataMap.put("eventsubscription", (Object)dataReport);
            this.reportScheduler.triggerJob(jobDetail.getKey(), dataMap);
            return Response.status((Response.Status)Response.Status.OK).entity((Object)"Job Triggered Successfully.").build();
        }
        throw new BadRequestException("Job with given Id does not exist");
    }

    static {
        INITIALIZED = false;
        reportJobKeyMap = new ConcurrentHashMap();
    }
}

