/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.events.subscription.msteams;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.List;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.Invocation;
import org.openmetadata.common.utils.CommonUtil;
import org.openmetadata.schema.SubscriptionAction;
import org.openmetadata.schema.api.events.CreateEventSubscription;
import org.openmetadata.schema.entity.events.EventSubscription;
import org.openmetadata.schema.type.ChangeEvent;
import org.openmetadata.schema.type.Webhook;
import org.openmetadata.service.events.errors.EventPublisherException;
import org.openmetadata.service.events.subscription.SubscriptionPublisher;
import org.openmetadata.service.events.subscription.msteams.TeamsMessage;
import org.openmetadata.service.exception.CatalogExceptionMessage;
import org.openmetadata.service.jdbi3.CollectionDAO;
import org.openmetadata.service.resources.events.EventResource;
import org.openmetadata.service.util.ChangeEventParser;
import org.openmetadata.service.util.JsonUtils;
import org.openmetadata.service.util.SubscriptionUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MSTeamsPublisher
extends SubscriptionPublisher {
    private static final Logger LOG = LoggerFactory.getLogger(MSTeamsPublisher.class);
    private final Webhook webhook;
    private Invocation.Builder target;
    private final Client client;
    private final CollectionDAO daoCollection;

    public MSTeamsPublisher(EventSubscription eventSub, CollectionDAO dao) {
        super(eventSub, dao);
        if (eventSub.getSubscriptionType() == CreateEventSubscription.SubscriptionType.MS_TEAMS_WEBHOOK) {
            String msTeamsWebhookURL;
            this.daoCollection = dao;
            this.webhook = JsonUtils.convertValue(eventSub.getSubscriptionConfig(), Webhook.class);
            this.client = SubscriptionUtil.getClient(eventSub.getTimeout(), eventSub.getReadTimeout());
            if (this.webhook.getEndpoint() != null && !CommonUtil.nullOrEmpty((String)(msTeamsWebhookURL = this.webhook.getEndpoint().toString()))) {
                this.target = this.client.target(msTeamsWebhookURL).request();
            }
        } else {
            throw new IllegalArgumentException("MsTeams Alert Invoked with Illegal Type and Settings.");
        }
    }

    @Override
    public void onStartDelegate() {
        LOG.info("MsTeams Webhook Publisher Started");
    }

    @Override
    public void onShutdownDelegate() {
        if (this.client != null) {
            this.client.close();
        }
    }

    @Override
    public void sendAlert(EventResource.EventList list) throws JsonProcessingException {
        for (ChangeEvent event : list.getData()) {
            try {
                TeamsMessage teamsMessage = ChangeEventParser.buildTeamsMessage(event);
                List<Invocation.Builder> targets = SubscriptionUtil.getTargetsForWebhook((SubscriptionAction)this.webhook, CreateEventSubscription.SubscriptionType.MS_TEAMS_WEBHOOK, this.client, this.daoCollection, event);
                if (this.target != null) {
                    targets.add(this.target);
                }
                for (Invocation.Builder actionTarget : targets) {
                    SubscriptionUtil.postWebhookMessage(this, actionTarget, teamsMessage);
                }
            }
            catch (Exception e) {
                String message = CatalogExceptionMessage.eventPublisherFailedToPublish(CreateEventSubscription.SubscriptionType.MS_TEAMS_WEBHOOK, event, e.getMessage());
                LOG.error(message);
                throw new EventPublisherException(message);
            }
        }
    }
}

