/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.jdbi3;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.BiPredicate;
import org.openmetadata.common.utils.CommonUtil;
import org.openmetadata.schema.EntityInterface;
import org.openmetadata.schema.entity.data.Container;
import org.openmetadata.schema.entity.services.StorageService;
import org.openmetadata.schema.type.Column;
import org.openmetadata.schema.type.EntityReference;
import org.openmetadata.schema.type.Include;
import org.openmetadata.schema.type.Relationship;
import org.openmetadata.schema.type.TagLabel;
import org.openmetadata.service.Entity;
import org.openmetadata.service.jdbi3.CollectionDAO;
import org.openmetadata.service.jdbi3.ColumnUtil;
import org.openmetadata.service.jdbi3.EntityRepository;
import org.openmetadata.service.util.EntityUtil;
import org.openmetadata.service.util.FullyQualifiedName;

public class ContainerRepository
extends EntityRepository<Container> {
    private static final String CONTAINER_UPDATE_FIELDS = "dataModel,owner,tags,extension";
    private static final String CONTAINER_PATCH_FIELDS = "dataModel,owner,tags,extension";

    public ContainerRepository(CollectionDAO dao) {
        super("v1/containers/", "container", Container.class, dao.containerDAO(), dao, "dataModel,owner,tags,extension", "dataModel,owner,tags,extension", null);
    }

    @Override
    public Container setFields(Container container, EntityUtil.Fields fields) throws IOException {
        this.setDefaultFields(container);
        container.setChildren(fields.contains("children") ? this.getChildrenContainers(container) : null);
        container.setParent(fields.contains("parent") ? this.getParentContainer(container) : null);
        container.setDataModel(fields.contains("dataModel") ? container.getDataModel() : null);
        if (container.getDataModel() != null) {
            this.populateDataModelColumnTags(fields.contains("tags"), container.getDataModel().getColumns());
        }
        container.setFollowers(fields.contains("followers") ? this.getFollowers(container) : null);
        return container;
    }

    private void populateDataModelColumnTags(boolean setTags, List<Column> columns) {
        for (Column c : CommonUtil.listOrEmpty(columns)) {
            c.setTags(setTags ? this.getTags(c.getFullyQualifiedName()) : null);
            this.populateDataModelColumnTags(setTags, c.getChildren());
        }
    }

    private EntityReference getParentContainer(Container container) throws IOException {
        if (container == null) {
            return null;
        }
        return this.getFromEntityRef(container.getId(), Relationship.CONTAINS, "container", false);
    }

    private void setDefaultFields(Container container) throws IOException {
        EntityReference parentServiceRef = this.getFromEntityRef(container.getId(), Relationship.CONTAINS, "storageService", true);
        container.withService(parentServiceRef);
    }

    private List<EntityReference> getChildrenContainers(Container container) throws IOException {
        if (container == null) {
            return Collections.emptyList();
        }
        List<CollectionDAO.EntityRelationshipRecord> childContainerIds = this.findTo(container.getId(), "container", Relationship.CONTAINS, "container");
        return EntityUtil.populateEntityReferences(childContainerIds, "container");
    }

    @Override
    public void setFullyQualifiedName(Container container) {
        if (container.getParent() != null) {
            container.setFullyQualifiedName(FullyQualifiedName.add(container.getParent().getFullyQualifiedName(), container.getName()));
        } else {
            container.setFullyQualifiedName(FullyQualifiedName.add(container.getService().getFullyQualifiedName(), container.getName()));
        }
        if (container.getDataModel() != null) {
            this.setColumnFQN(container.getFullyQualifiedName(), container.getDataModel().getColumns());
        }
    }

    private void setColumnFQN(String parentFQN, List<Column> columns) {
        columns.forEach(c -> {
            String columnFqn = FullyQualifiedName.add(parentFQN, c.getName());
            c.setFullyQualifiedName(columnFqn);
            if (c.getChildren() != null) {
                this.setColumnFQN(columnFqn, c.getChildren());
            }
        });
    }

    @Override
    public void prepare(Container container) throws IOException {
        StorageService storageService = (StorageService)Entity.getEntity(container.getService(), "", Include.NON_DELETED);
        container.setService(storageService.getEntityReference());
        container.setServiceType(storageService.getServiceType());
        if (container.getParent() != null) {
            Container parent = (Container)Entity.getEntity(container.getParent(), "owner", Include.ALL);
            container.withParent(parent.getEntityReference());
        }
        if (container.getDataModel() != null) {
            this.addDerivedColumnTags(container.getDataModel().getColumns());
            this.validateColumnTags(container.getDataModel().getColumns());
        }
    }

    @Override
    public void storeEntity(Container container, boolean update) throws IOException {
        EntityReference storageService = container.getService();
        EntityReference parent = container.getParent();
        List children = container.getChildren();
        EntityReference owner = container.getOwner();
        List tags = container.getTags();
        container.withService(null).withParent(null).withChildren(null).withOwner(null).withHref(null).withTags(null);
        ArrayList columnWithTags = Lists.newArrayList();
        if (container.getDataModel() != null) {
            columnWithTags.addAll(container.getDataModel().getColumns());
            container.getDataModel().setColumns(ColumnUtil.cloneWithoutTags(columnWithTags));
            container.getDataModel().getColumns().forEach(column -> column.setTags(null));
        }
        this.store(container, update);
        container.withService(storageService).withParent(parent).withChildren(children).withOwner(owner).withTags(tags);
        if (container.getDataModel() != null) {
            container.getDataModel().setColumns((List)columnWithTags);
        }
    }

    @Override
    public void restorePatchAttributes(Container original, Container updated) {
        updated.withFullyQualifiedName(original.getFullyQualifiedName()).withService(original.getService()).withParent(original.getParent()).withName(original.getName()).withId(original.getId());
    }

    @Override
    public void storeRelationships(Container container) {
        EntityReference service = container.getService();
        this.addRelationship(service.getId(), container.getId(), service.getType(), "container", Relationship.CONTAINS);
        EntityReference parentReference = container.getParent();
        if (parentReference != null) {
            this.addRelationship(parentReference.getId(), container.getId(), "container", "container", Relationship.CONTAINS);
        }
        this.storeOwner(container, container.getOwner());
        this.applyTags(container);
    }

    @Override
    public EntityRepository.EntityUpdater getUpdater(Container original, Container updated, EntityRepository.Operation operation) {
        return new ContainerUpdater(original, updated, operation);
    }

    @Override
    public void applyTags(Container container) {
        super.applyTags(container);
        if (container.getDataModel() != null) {
            this.applyTags(container.getDataModel().getColumns());
        }
    }

    @Override
    private void applyTags(List<Column> columns) {
        for (Column column : columns) {
            this.applyTags(column.getTags(), column.getFullyQualifiedName());
            if (column.getChildren() == null) continue;
            this.applyTags(column.getChildren());
        }
    }

    @Override
    public List<TagLabel> getAllTags(EntityInterface entity) {
        ArrayList<TagLabel> allTags = new ArrayList<TagLabel>();
        Container container = (Container)entity;
        EntityUtil.mergeTags(allTags, container.getTags());
        if (container.getDataModel() != null) {
            for (Column column : CommonUtil.listOrEmpty((List)container.getDataModel().getColumns())) {
                EntityUtil.mergeTags(allTags, column.getTags());
            }
        }
        return allTags;
    }

    private void addDerivedColumnTags(List<Column> columns) {
        if (CommonUtil.nullOrEmpty(columns)) {
            return;
        }
        for (Column column : columns) {
            column.setTags(this.addDerivedTags(column.getTags()));
            if (column.getChildren() == null) continue;
            this.addDerivedColumnTags(column.getChildren());
        }
    }

    private void validateColumnTags(List<Column> columns) {
        for (Column column : columns) {
            this.checkMutuallyExclusive(column.getTags());
            if (column.getChildren() == null) continue;
            this.validateColumnTags(column.getChildren());
        }
    }

    public class ContainerUpdater
    extends EntityRepository.ColumnEntityUpdater {
        public ContainerUpdater(Container original, Container updated, EntityRepository.Operation operation) {
            super((EntityRepository)ContainerRepository.this, (EntityInterface)original, (EntityInterface)updated, operation);
        }

        @Override
        public void entitySpecificUpdate() throws IOException {
            this.updateDataModel((Container)this.original, (Container)this.updated);
        }

        private void updateDataModel(Container original, Container updated) throws IOException {
            if (original.getDataModel() == null || updated.getDataModel() == null) {
                this.recordChange("dataModel", original.getDataModel(), updated.getDataModel(), true);
            }
            if (original.getDataModel() != null && updated.getDataModel() != null) {
                this.updateColumns("dataModel.columns", original.getDataModel().getColumns(), updated.getDataModel().getColumns(), (BiPredicate)EntityUtil.columnMatch);
                this.recordChange("dataModel.partition", original.getDataModel().getIsPartitioned(), updated.getDataModel().getIsPartitioned());
            }
        }
    }
}

