/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.resources.dqtests;

import io.swagger.v3.oas.annotations.ExternalDocumentation;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.ExampleObject;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.io.IOException;
import java.net.URI;
import java.util.UUID;
import javax.json.JsonPatch;
import javax.validation.Valid;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.PATCH;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriInfo;
import lombok.NonNull;
import org.openmetadata.schema.CreateEntity;
import org.openmetadata.schema.api.data.RestoreEntity;
import org.openmetadata.schema.api.tests.CreateTestCase;
import org.openmetadata.schema.tests.TestCase;
import org.openmetadata.schema.tests.type.TestCaseResult;
import org.openmetadata.schema.type.EntityHistory;
import org.openmetadata.schema.type.Include;
import org.openmetadata.schema.type.MetadataOperation;
import org.openmetadata.service.Entity;
import org.openmetadata.service.jdbi3.CollectionDAO;
import org.openmetadata.service.jdbi3.ListFilter;
import org.openmetadata.service.jdbi3.TestCaseRepository;
import org.openmetadata.service.resources.Collection;
import org.openmetadata.service.resources.EntityResource;
import org.openmetadata.service.resources.feeds.MessageParser;
import org.openmetadata.service.security.Authorizer;
import org.openmetadata.service.security.policyevaluator.OperationContext;
import org.openmetadata.service.security.policyevaluator.TestCaseResourceContext;
import org.openmetadata.service.util.EntityUtil;
import org.openmetadata.service.util.RestUtil;
import org.openmetadata.service.util.ResultList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/v1/dataQuality/testCases")
@Tag(name="Test Cases", description="Test case is a test definition to capture data quality tests against tables, columns, and other data assets.")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@Collection(name="TestCases")
public class TestCaseResource
extends EntityResource<TestCase, TestCaseRepository> {
    private static final Logger LOG = LoggerFactory.getLogger(TestCaseResource.class);
    public static final String COLLECTION_PATH = "/v1/dataQuality/testCases";
    static final String FIELDS = "owner,testSuite,testDefinition";

    @Override
    public TestCase addHref(UriInfo uriInfo, TestCase test) {
        test.withHref(RestUtil.getHref(uriInfo, COLLECTION_PATH, test.getId()));
        Entity.withHref(uriInfo, test.getOwner());
        Entity.withHref(uriInfo, test.getTestSuite());
        Entity.withHref(uriInfo, test.getTestDefinition());
        return test;
    }

    public TestCaseResource(CollectionDAO dao, Authorizer authorizer) {
        super(TestCase.class, new TestCaseRepository(dao), authorizer);
    }

    @GET
    @Operation(operationId="listTestCases", summary="List test cases", description="Get a list of test. Use `fields` parameter to get only necessary fields. Use cursor-based pagination to limit the number entries in the list using `limit` and `before` or `after` query params.", responses={@ApiResponse(responseCode="200", description="List of test definitions", content={@Content(mediaType="application/json", schema=@Schema(implementation=TestCaseList.class))})})
    public ResultList<TestCase> list(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Fields requested in the returned resource", schema=@Schema(type="string", example="owner,testSuite,testDefinition")) @QueryParam(value="fields") String fieldsParam, @Parameter(description="Limit the number tests returned. (1 to 1000000, default = 10)") @DefaultValue(value="10") @QueryParam(value="limit") @Min(value=0L) @Max(value=1000000L) @Min(value=0L) @Max(value=1000000L) int limitParam, @Parameter(description="Returns list of tests before this cursor", schema=@Schema(type="string")) @QueryParam(value="before") String before, @Parameter(description="Returns list of tests after this cursor", schema=@Schema(type="string")) @QueryParam(value="after") String after, @Parameter(description="Return list of tests by entity link", schema=@Schema(type="string", example="<E#/{entityType}/{entityFQN}/{fieldName}>")) @QueryParam(value="entityLink") String entityLink, @Parameter(description="Returns list of tests filtered by the testSuite id", schema=@Schema(type="string")) @QueryParam(value="testSuiteId") String testSuiteId, @Parameter(description="Include all the tests at the entity level", schema=@Schema(type="boolean")) @QueryParam(value="includeAllTests") @DefaultValue(value="false") Boolean includeAllTests, @Parameter(description="Include all, deleted, or non-deleted entities.", schema=@Schema(implementation=Include.class)) @QueryParam(value="include") @DefaultValue(value="non-deleted") Include include) throws IOException {
        TestCaseResourceContext resourceContext;
        ListFilter filter = new ListFilter(include).addQueryParam("testSuiteId", testSuiteId).addQueryParam("includeAllTests", includeAllTests.toString());
        if (entityLink != null) {
            MessageParser.EntityLink entityLinkParsed = MessageParser.EntityLink.parse(entityLink);
            filter.addQueryParam("entityFQN", entityLinkParsed.getFullyQualifiedFieldValue());
            resourceContext = TestCaseResourceContext.builder().entityLink(entityLinkParsed).build();
        } else {
            resourceContext = TestCaseResourceContext.builder().build();
        }
        OperationContext operationContext = new OperationContext("table", MetadataOperation.VIEW_TESTS);
        EntityUtil.Fields fields = this.getFields(fieldsParam);
        return super.listInternal(uriInfo, securityContext, fields, filter, limitParam, before, after, operationContext, resourceContext);
    }

    @GET
    @Path(value="/{id}/versions")
    @Operation(operationId="listAllTestCaseVersion", summary="List test case versions", description="Get a list of all the versions of a testCases identified by `Id`", responses={@ApiResponse(responseCode="200", description="List of test versions", content={@Content(mediaType="application/json", schema=@Schema(implementation=EntityHistory.class))})})
    public EntityHistory listVersions(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Id of the test case", schema=@Schema(type="UUID")) @PathParam(value="id") UUID id) throws IOException {
        TestCaseResourceContext resourceContext = TestCaseResourceContext.builder().id(id).build();
        OperationContext operationContext = new OperationContext("table", MetadataOperation.VIEW_TESTS);
        return super.listVersionsInternal(securityContext, id, operationContext, resourceContext);
    }

    @GET
    @Path(value="/{id}")
    @Operation(summary="Get a test case by Id", description="Get a TestCase by `Id`.", responses={@ApiResponse(responseCode="200", description="The TestCases", content={@Content(mediaType="application/json", schema=@Schema(implementation=TestCase.class))}), @ApiResponse(responseCode="404", description="Test for instance {id} is not found")})
    public TestCase get(@Context UriInfo uriInfo, @Parameter(description="Id of the test case", schema=@Schema(type="UUID")) @PathParam(value="id") UUID id, @Context SecurityContext securityContext, @Parameter(description="Fields requested in the returned resource", schema=@Schema(type="string", example="owner,testSuite,testDefinition")) @QueryParam(value="fields") String fieldsParam, @Parameter(description="Include all, deleted, or non-deleted entities.", schema=@Schema(implementation=Include.class)) @QueryParam(value="include") @DefaultValue(value="non-deleted") Include include) throws IOException {
        EntityUtil.Fields fields = this.getFields(fieldsParam);
        OperationContext operationContext = new OperationContext("table", MetadataOperation.VIEW_TESTS);
        TestCaseResourceContext resourceContext = TestCaseResourceContext.builder().id(id).build();
        return (TestCase)this.getInternal(uriInfo, securityContext, id, fields, include, operationContext, resourceContext);
    }

    @GET
    @Path(value="/name/{fqn}")
    @Operation(operationId="getTestCaseByName", summary="Get a test case by fully qualified name", description="Get a test case by `fullyQualifiedName`.", responses={@ApiResponse(responseCode="200", description="The TestCase", content={@Content(mediaType="application/json", schema=@Schema(implementation=TestCase.class))}), @ApiResponse(responseCode="404", description="Test for instance {fqn} is not found")})
    public TestCase getByName(@Context UriInfo uriInfo, @Parameter(description="Fully qualified name of the test case", schema=@Schema(type="string")) @PathParam(value="fqn") String fqn, @Context SecurityContext securityContext, @Parameter(description="Fields requested in the returned resource", schema=@Schema(type="string", example="owner,testSuite,testDefinition")) @QueryParam(value="fields") String fieldsParam, @Parameter(description="Include all, deleted, or non-deleted entities.", schema=@Schema(implementation=Include.class)) @QueryParam(value="include") @DefaultValue(value="non-deleted") Include include) throws IOException {
        EntityUtil.Fields fields = this.getFields(fieldsParam);
        OperationContext operationContext = new OperationContext("table", MetadataOperation.VIEW_TESTS);
        TestCaseResourceContext resourceContext = TestCaseResourceContext.builder().name(fqn).build();
        return (TestCase)this.getByNameInternal(uriInfo, securityContext, fqn, fields, include, operationContext, resourceContext);
    }

    @GET
    @Path(value="/{id}/versions/{version}")
    @Operation(operationId="getSpecificTestCaseVersion", summary="Get a version of the test case", description="Get a version of the test case by given `Id`", responses={@ApiResponse(responseCode="200", description="Test", content={@Content(mediaType="application/json", schema=@Schema(implementation=TestCase.class))}), @ApiResponse(responseCode="404", description="Test for instance {id} and version {version} is not found")})
    public TestCase getVersion(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Id of the test case", schema=@Schema(type="UUID")) @PathParam(value="id") UUID id, @Parameter(description="Test version number in the form `major`.`minor`", schema=@Schema(type="string", example="0.1 or 1.1")) @PathParam(value="version") String version) throws IOException {
        OperationContext operationContext = new OperationContext("table", MetadataOperation.VIEW_TESTS);
        TestCaseResourceContext resourceContext = TestCaseResourceContext.builder().id(id).build();
        return (TestCase)super.getVersionInternal(securityContext, id, version, operationContext, resourceContext);
    }

    @Override
    @POST
    @Operation(operationId="createTestCase", summary="Create a test case", description="Create a test case", responses={@ApiResponse(responseCode="200", description="The test", content={@Content(mediaType="application/json", schema=@Schema(implementation=TestCase.class))}), @ApiResponse(responseCode="400", description="Bad request")})
    public Response create(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Valid CreateTestCase create) throws IOException {
        MessageParser.EntityLink entityLink = MessageParser.EntityLink.parse(create.getEntityLink());
        TestCase test = this.getTestCase(create, securityContext.getUserPrincipal().getName(), entityLink);
        OperationContext operationContext = new OperationContext("table", MetadataOperation.EDIT_TESTS);
        TestCaseResourceContext resourceContext = TestCaseResourceContext.builder().entityLink(entityLink).build();
        this.authorizer.authorize(securityContext, operationContext, resourceContext);
        test = this.addHref(uriInfo, ((TestCaseRepository)this.dao).create(uriInfo, test));
        LOG.info("Created {}:{}", (Object)Entity.getEntityTypeFromObject(test), (Object)test.getId());
        return Response.created((URI)test.getHref()).entity((Object)test).build();
    }

    @PATCH
    @Path(value="/{id}")
    @Operation(operationId="patchTest", summary="Update a test case", description="Update an existing test using JsonPatch.", externalDocs=@ExternalDocumentation(description="JsonPatch RFC", url="https://tools.ietf.org/html/rfc6902"))
    @Consumes(value={"application/json-patch+json"})
    public Response patch(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Id of the test case", schema=@Schema(type="UUID")) @PathParam(value="id") UUID id, @RequestBody(description="JsonPatch with array of operations", content={@Content(mediaType="application/json-patch+json", examples={@ExampleObject(value="[{op:remove, path:/a},{op:add, path: /b, value: val}]")})}) JsonPatch patch) throws IOException {
        TestCaseResourceContext resourceContext = TestCaseResourceContext.builder().id(id).build();
        OperationContext operationContext = new OperationContext("table", MetadataOperation.EDIT_TESTS);
        this.authorizer.authorize(securityContext, operationContext, resourceContext);
        RestUtil.PatchResponse response = ((TestCaseRepository)this.dao).patch(uriInfo, id, securityContext.getUserPrincipal().getName(), patch);
        this.addHref(uriInfo, (TestCase)response.getEntity());
        return response.toResponse();
    }

    @Override
    @PUT
    @Operation(operationId="createOrUpdateTest", summary="Update test case", description="Create a TestCase, it it does not exist or update an existing TestCase.", responses={@ApiResponse(responseCode="200", description="The updated testCase.", content={@Content(mediaType="application/json", schema=@Schema(implementation=TestCase.class))})})
    public Response createOrUpdate(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Valid CreateTestCase create) throws IOException {
        MessageParser.EntityLink entityLink = MessageParser.EntityLink.parse(create.getEntityLink());
        TestCaseResourceContext resourceContext = TestCaseResourceContext.builder().entityLink(entityLink).build();
        OperationContext operationContext = new OperationContext("table", MetadataOperation.EDIT_TESTS);
        this.authorizer.authorize(securityContext, operationContext, resourceContext);
        TestCase test = this.getTestCase(create, securityContext.getUserPrincipal().getName(), entityLink);
        ((TestCaseRepository)this.dao).prepareInternal(test);
        RestUtil.PutResponse<TestCase> response = ((TestCaseRepository)this.dao).createOrUpdate(uriInfo, test);
        this.addHref(uriInfo, response.getEntity());
        return response.toResponse();
    }

    @DELETE
    @Path(value="/{id}")
    @Operation(operationId="deleteTestCase", summary="Delete a test case by Id", description="Delete a test case by `Id`.", responses={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="Test case for instance {id} is not found")})
    public Response delete(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Hard delete the entity. (Default = `false`)") @QueryParam(value="hardDelete") @DefaultValue(value="false") boolean hardDelete, @Parameter(description="Id of the test case", schema=@Schema(type="UUID")) @PathParam(value="id") UUID id) throws IOException {
        TestCaseResourceContext resourceContext = TestCaseResourceContext.builder().id(id).build();
        OperationContext operationContext = new OperationContext("table", MetadataOperation.EDIT_TESTS);
        this.authorizer.authorize(securityContext, operationContext, resourceContext);
        RestUtil.DeleteResponse<UUID> response = ((TestCaseRepository)this.dao).delete(securityContext.getUserPrincipal().getName(), id, false, hardDelete);
        this.addHref(uriInfo, (TestCase)response.getEntity());
        return response.toResponse();
    }

    @DELETE
    @Path(value="/name/{fqn}")
    @Operation(operationId="deleteTestCaseByName", summary="Delete a test case by fully qualified name", description="Delete a testCase by `fullyQualifiedName`.", responses={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="TestCase for instance {fqn} is not found")})
    public Response delete(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Hard delete the entity. (Default = `false`)") @QueryParam(value="hardDelete") @DefaultValue(value="false") boolean hardDelete, @Parameter(description="Fully qualified name of the test case", schema=@Schema(type="string")) @PathParam(value="fqn") String fqn) throws IOException {
        return this.deleteByName(uriInfo, securityContext, fqn, false, hardDelete);
    }

    @PUT
    @Path(value="/restore")
    @Operation(operationId="restore", summary="Restore a soft deleted test case", description="Restore a soft deleted test case.", responses={@ApiResponse(responseCode="200", description="Successfully restored the Chart ", content={@Content(mediaType="application/json", schema=@Schema(implementation=TestCase.class))})})
    public Response restoreTestCase(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Valid RestoreEntity restore) throws IOException {
        return this.restoreEntity(uriInfo, securityContext, restore.getId());
    }

    @PUT
    @Path(value="/{fqn}/testCaseResult")
    @Operation(operationId="addTestCaseResult", summary="Add test case result data", description="Add test case result data to the testCase.", responses={@ApiResponse(responseCode="200", description="Successfully updated the TestCase. ", content={@Content(mediaType="application/json", schema=@Schema(implementation=TestCase.class))})})
    public Response addTestCaseResult(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Fully qualified name of the test case", schema=@Schema(type="string")) @PathParam(value="fqn") String fqn, @Valid TestCaseResult testCaseResult) throws IOException {
        TestCaseResourceContext resourceContext = TestCaseResourceContext.builder().name(fqn).build();
        OperationContext operationContext = new OperationContext("table", MetadataOperation.EDIT_TESTS);
        this.authorizer.authorize(securityContext, operationContext, resourceContext);
        return ((TestCaseRepository)this.dao).addTestCaseResult(securityContext.getUserPrincipal().getName(), uriInfo, fqn, testCaseResult).toResponse();
    }

    @GET
    @Path(value="/{fqn}/testCaseResult")
    @Operation(operationId="listTestCaseResults", summary="List of test case results", description="Get a list of all the test case results for the given testCase id, optionally filtered by  `startTs` and `endTs` of the profile. Use cursor-based pagination to limit the number of entries in the list using `limit` and `before` or `after` query params.", responses={@ApiResponse(responseCode="200", description="List of testCase results", content={@Content(mediaType="application/json", schema=@Schema(implementation=TestCaseResultList.class))})})
    public ResultList<TestCaseResult> listTestCaseResults(@Context SecurityContext securityContext, @Parameter(description="Fully qualified name of the test case", schema=@Schema(type="string")) @PathParam(value="fqn") String fqn, @Parameter(description="Filter testCase results after the given start timestamp", schema=@Schema(type="number")) @QueryParam(value="startTs") @NonNull Long startTs, @Parameter(description="Filter testCase results before the given end timestamp", schema=@Schema(type="number")) @QueryParam(value="endTs") @NonNull Long endTs) throws IOException {
        if (startTs == null) {
            throw new NullPointerException("startTs is marked non-null but is null");
        }
        if (endTs == null) {
            throw new NullPointerException("endTs is marked non-null but is null");
        }
        return ((TestCaseRepository)this.dao).getTestCaseResults(fqn, startTs, endTs);
    }

    @DELETE
    @Path(value="/{fqn}/testCaseResult/{timestamp}")
    @Operation(operationId="DeleteTestCaseResult", summary="Delete test case result", description="Delete testCase result for a testCase.", responses={@ApiResponse(responseCode="200", description="Successfully deleted the TestCaseResult", content={@Content(mediaType="application/json", schema=@Schema(implementation=TestCase.class))})})
    public Response deleteTestCaseResult(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Fully qualified name of the test case", schema=@Schema(type="string")) @PathParam(value="fqn") String fqn, @Parameter(description="Timestamp of the testCase result", schema=@Schema(type="long")) @PathParam(value="timestamp") Long timestamp) throws IOException {
        TestCaseResourceContext resourceContext = TestCaseResourceContext.builder().name(fqn).build();
        OperationContext operationContext = new OperationContext("table", MetadataOperation.EDIT_TESTS);
        this.authorizer.authorize(securityContext, operationContext, resourceContext);
        return ((TestCaseRepository)this.dao).deleteTestCaseResult(securityContext.getUserPrincipal().getName(), fqn, timestamp).toResponse();
    }

    private TestCase getTestCase(CreateTestCase create, String user, MessageParser.EntityLink entityLink) throws IOException {
        return this.copy(new TestCase(), (CreateEntity)create, user).withDescription(create.getDescription()).withName(create.getName()).withDisplayName(create.getDisplayName()).withParameterValues(create.getParameterValues()).withEntityLink(create.getEntityLink()).withEntityFQN(entityLink.getFullyQualifiedFieldValue()).withTestSuite(this.getEntityReference("testSuite", create.getTestSuite())).withTestDefinition(this.getEntityReference("testDefinition", create.getTestDefinition()));
    }

    public static class TestCaseResultList
    extends ResultList<TestCaseResult> {
    }

    public static class TestCaseList
    extends ResultList<TestCase> {
    }
}

