/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.security;

import com.auth0.jwk.Jwk;
import com.auth0.jwk.JwkProvider;
import com.auth0.jwt.JWT;
import com.auth0.jwt.algorithms.Algorithm;
import com.auth0.jwt.exceptions.JWTDecodeException;
import com.auth0.jwt.interfaces.Claim;
import com.auth0.jwt.interfaces.DecodedJWT;
import com.fasterxml.jackson.databind.node.TextNode;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import java.net.URL;
import java.security.interfaces.RSAPublicKey;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.TreeMap;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.ext.Provider;
import org.openmetadata.common.utils.CommonUtil;
import org.openmetadata.schema.api.security.AuthenticationConfiguration;
import org.openmetadata.schema.api.security.AuthorizerConfiguration;
import org.openmetadata.schema.auth.LogoutRequest;
import org.openmetadata.schema.auth.SSOAuthMechanism;
import org.openmetadata.schema.auth.ServiceTokenType;
import org.openmetadata.service.security.AuthenticationException;
import org.openmetadata.service.security.CatalogPrincipal;
import org.openmetadata.service.security.MultiUrlJwkProvider;
import org.openmetadata.service.security.auth.BotTokenCache;
import org.openmetadata.service.security.auth.CatalogSecurityContext;
import org.openmetadata.service.security.auth.UserTokenCache;
import org.openmetadata.service.security.saml.JwtTokenCacheManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
public class JwtFilter
implements ContainerRequestFilter {
    private static final Logger LOG = LoggerFactory.getLogger(JwtFilter.class);
    public static final String AUTHORIZATION_HEADER = "Authorization";
    public static final String TOKEN_PREFIX = "Bearer";
    public static final String BOT_CLAIM = "isBot";
    private List<String> jwtPrincipalClaims;
    private JwkProvider jwkProvider;
    private String principalDomain;
    private boolean enforcePrincipalDomain;
    private String providerType;
    public static final List<String> EXCLUDED_ENDPOINTS = List.of("v1/system/config", "v1/users/signup", "v1/system/version", "v1/users/registrationConfirmation", "v1/users/resendRegistrationToken", "v1/users/generatePasswordResetLink", "v1/users/password/reset", "v1/users/checkEmailInUse", "v1/users/login", "v1/users/refresh");

    private JwtFilter() {
    }

    public JwtFilter(AuthenticationConfiguration authenticationConfiguration, AuthorizerConfiguration authorizerConfiguration) {
        this.providerType = authenticationConfiguration.getProvider();
        this.jwtPrincipalClaims = authenticationConfiguration.getJwtPrincipalClaims();
        ImmutableList.Builder publicKeyUrlsBuilder = ImmutableList.builder();
        for (String publicKeyUrlStr : authenticationConfiguration.getPublicKeyUrls()) {
            publicKeyUrlsBuilder.add((Object)new URL(publicKeyUrlStr));
        }
        this.jwkProvider = new MultiUrlJwkProvider((List<URL>)publicKeyUrlsBuilder.build());
        this.principalDomain = authorizerConfiguration.getPrincipalDomain();
        this.enforcePrincipalDomain = authorizerConfiguration.getEnforcePrincipalDomain();
    }

    @VisibleForTesting
    JwtFilter(JwkProvider jwkProvider, List<String> jwtPrincipalClaims, String principalDomain, boolean enforcePrincipalDomain) {
        this.jwkProvider = jwkProvider;
        this.jwtPrincipalClaims = jwtPrincipalClaims;
        this.principalDomain = principalDomain;
        this.enforcePrincipalDomain = enforcePrincipalDomain;
    }

    public void filter(ContainerRequestContext requestContext) {
        UriInfo uriInfo = requestContext.getUriInfo();
        if (EXCLUDED_ENDPOINTS.stream().anyMatch(endpoint -> uriInfo.getPath().contains((CharSequence)endpoint))) {
            return;
        }
        MultivaluedMap headers = requestContext.getHeaders();
        String tokenFromHeader = JwtFilter.extractToken((MultivaluedMap<String, String>)headers);
        LOG.debug("Token from header:{}", (Object)tokenFromHeader);
        if (SSOAuthMechanism.SsoServiceType.BASIC.toString().equals(this.providerType) || SSOAuthMechanism.SsoServiceType.SAML.toString().equals(this.providerType)) {
            this.validateTokenIsNotUsedAfterLogout(tokenFromHeader);
        }
        DecodedJWT jwt = this.validateAndReturnDecodedJwtToken(tokenFromHeader);
        TreeMap<String, Claim> claims = new TreeMap<String, Claim>(String.CASE_INSENSITIVE_ORDER);
        claims.putAll(jwt.getClaims());
        String userName = this.validateAndReturnUsername(claims);
        if (claims.containsKey(BOT_CLAIM) && Boolean.TRUE.equals(((Claim)claims.get(BOT_CLAIM)).asBoolean())) {
            this.validateBotToken(tokenFromHeader, userName);
        }
        if (claims.containsKey("tokenType") && ServiceTokenType.PERSONAL_ACCESS.equals((Object)ServiceTokenType.fromValue((String)((Claim)claims.get("tokenType")).asString()))) {
            this.validatePersonalAccessToken(tokenFromHeader, userName);
        }
        CatalogPrincipal catalogPrincipal = new CatalogPrincipal(userName);
        String scheme = requestContext.getUriInfo().getRequestUri().getScheme();
        CatalogSecurityContext catalogSecurityContext = new CatalogSecurityContext(catalogPrincipal, scheme, "DIGEST");
        LOG.debug("SecurityContext {}", (Object)catalogSecurityContext);
        requestContext.setSecurityContext((SecurityContext)catalogSecurityContext);
    }

    public DecodedJWT validateAndReturnDecodedJwtToken(String token) {
        DecodedJWT jwt;
        try {
            jwt = JWT.decode((String)token);
        }
        catch (JWTDecodeException e) {
            throw new AuthenticationException("Invalid token", e);
        }
        if (jwt.getExpiresAt() != null && jwt.getExpiresAt().before(Calendar.getInstance(TimeZone.getTimeZone("UTC")).getTime())) {
            throw new AuthenticationException("Expired token!");
        }
        Jwk jwk = this.jwkProvider.get(jwt.getKeyId());
        Algorithm algorithm = Algorithm.RSA256((RSAPublicKey)((RSAPublicKey)jwk.getPublicKey()), null);
        try {
            algorithm.verify(jwt);
        }
        catch (RuntimeException runtimeException) {
            throw new AuthenticationException("Invalid token", runtimeException);
        }
        return jwt;
    }

    public String validateAndReturnUsername(Map<String, Claim> claims) {
        String domain;
        String userName;
        String jwtClaim = this.jwtPrincipalClaims.stream().filter(claims::containsKey).findFirst().map(claims::get).map(claim -> ((TextNode)claim.as(TextNode.class)).asText()).orElseThrow(() -> new AuthenticationException("Invalid JWT token, none of the following claims are present " + this.jwtPrincipalClaims));
        if (jwtClaim.contains("@")) {
            userName = jwtClaim.split("@")[0];
            domain = jwtClaim.split("@")[1];
        } else {
            userName = jwtClaim;
            domain = "";
        }
        if (this.enforcePrincipalDomain && !domain.equals(this.principalDomain)) {
            throw new AuthenticationException(String.format("Not Authorized! Email does not match the principal domain %s", this.principalDomain));
        }
        return userName;
    }

    protected static String extractToken(MultivaluedMap<String, String> headers) {
        LOG.debug("Request Headers:{}", headers);
        String source = (String)headers.getFirst((Object)AUTHORIZATION_HEADER);
        if (CommonUtil.nullOrEmpty((String)source)) {
            throw new AuthenticationException("Not Authorized! Token not present");
        }
        if (source.startsWith(TOKEN_PREFIX)) {
            return source.substring(TOKEN_PREFIX.length() + 1);
        }
        throw new AuthenticationException("Not Authorized! Token not present");
    }

    public static String extractToken(String tokenFromHeader) {
        LOG.debug("Request Token:{}", (Object)tokenFromHeader);
        if (CommonUtil.nullOrEmpty((String)tokenFromHeader)) {
            throw new AuthenticationException("Not Authorized! Token not present");
        }
        if (tokenFromHeader.startsWith(TOKEN_PREFIX)) {
            return tokenFromHeader.substring(TOKEN_PREFIX.length() + 1);
        }
        throw new AuthenticationException("Not Authorized! Token not present");
    }

    private void validateBotToken(String tokenFromHeader, String userName) {
        if (tokenFromHeader.equals(BotTokenCache.getInstance().getToken(userName))) {
            return;
        }
        throw new AuthenticationException("Not Authorized! Invalid Token");
    }

    private void validatePersonalAccessToken(String tokenFromHeader, String userName) {
        if (UserTokenCache.getInstance().getToken(userName).contains(tokenFromHeader)) {
            return;
        }
        throw new AuthenticationException("Not Authorized! Invalid Token");
    }

    private void validateTokenIsNotUsedAfterLogout(String authToken) {
        LogoutRequest previouslyLoggedOutEvent = JwtTokenCacheManager.getInstance().getLogoutEventForToken(authToken);
        if (previouslyLoggedOutEvent != null) {
            throw new AuthenticationException("Expired token!");
        }
    }
}

