/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.security.policyevaluator;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.util.concurrent.UncheckedExecutionException;
import java.io.IOException;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import javax.annotation.CheckForNull;
import org.openmetadata.schema.entity.teams.Role;
import org.openmetadata.service.Entity;
import org.openmetadata.service.exception.CatalogExceptionMessage;
import org.openmetadata.service.exception.EntityNotFoundException;
import org.openmetadata.service.jdbi3.RoleRepository;
import org.openmetadata.service.util.EntityUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RoleCache {
    private static final Logger LOG = LoggerFactory.getLogger(RoleCache.class);
    private static final RoleCache INSTANCE = new RoleCache();
    private static volatile boolean INITIALIZED = false;
    protected static LoadingCache<String, Role> ROLE_CACHE;
    protected static LoadingCache<UUID, Role> ROLE_CACHE_WITH_ID;
    private static RoleRepository ROLE_REPOSITORY;
    private static EntityUtil.Fields FIELDS;

    public static RoleCache getInstance() {
        return INSTANCE;
    }

    public static void initialize() {
        if (!INITIALIZED) {
            ROLE_CACHE = CacheBuilder.newBuilder().maximumSize(100L).expireAfterWrite(3L, TimeUnit.MINUTES).build((CacheLoader)new RoleLoader());
            ROLE_CACHE_WITH_ID = CacheBuilder.newBuilder().maximumSize(100L).expireAfterWrite(3L, TimeUnit.MINUTES).build((CacheLoader)new RoleLoaderWithId());
            ROLE_REPOSITORY = (RoleRepository)Entity.getEntityRepository("role");
            FIELDS = ROLE_REPOSITORY.getFields("policies");
            INITIALIZED = true;
        }
    }

    public Role getRole(String roleName) {
        try {
            return (Role)ROLE_CACHE.get((Object)roleName);
        }
        catch (UncheckedExecutionException | ExecutionException ex) {
            throw EntityNotFoundException.byMessage(CatalogExceptionMessage.entityNotFound("role", roleName));
        }
    }

    public Role getRoleById(UUID roleId) {
        try {
            return (Role)ROLE_CACHE_WITH_ID.get((Object)roleId);
        }
        catch (UncheckedExecutionException | ExecutionException ex) {
            throw EntityNotFoundException.byMessage(CatalogExceptionMessage.entityNotFound("role", roleId));
        }
    }

    public void invalidateRole(UUID roleId) {
        try {
            ROLE_CACHE_WITH_ID.invalidate((Object)roleId);
        }
        catch (Exception ex) {
            LOG.error("Failed to invalidate cache for role {}", (Object)roleId, (Object)ex);
        }
    }

    public static void cleanUp() {
        ROLE_CACHE_WITH_ID.cleanUp();
        INITIALIZED = false;
    }

    static class RoleLoaderWithId
    extends CacheLoader<UUID, Role> {
        RoleLoaderWithId() {
        }

        public Role load(@CheckForNull UUID roleId) throws IOException {
            Role role = (Role)ROLE_REPOSITORY.get(null, roleId, FIELDS);
            LOG.info("Loaded role {}:{}", (Object)role.getName(), (Object)role.getId());
            return role;
        }
    }

    static class RoleLoader
    extends CacheLoader<String, Role> {
        RoleLoader() {
        }

        public Role load(@CheckForNull String roleName) throws IOException {
            Role role = (Role)ROLE_REPOSITORY.getByName(null, roleName, FIELDS);
            LOG.info("Loaded role {}:{}", (Object)role.getName(), (Object)role.getId());
            return role;
        }
    }
}

