/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.util;

import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.openmetadata.common.utils.CommonUtil;
import org.openmetadata.schema.email.SmtpSettings;
import org.openmetadata.schema.entity.feed.Thread;
import org.openmetadata.schema.entity.teams.User;
import org.openmetadata.schema.settings.SettingsType;
import org.openmetadata.schema.tests.type.TestCaseResult;
import org.openmetadata.service.events.scheduled.template.DataInsightDescriptionAndOwnerTemplate;
import org.openmetadata.service.events.scheduled.template.DataInsightTotalAssetTemplate;
import org.openmetadata.service.events.subscription.emailAlert.EmailMessage;
import org.openmetadata.service.resources.settings.SettingsCache;
import org.simplejavamail.api.email.Email;
import org.simplejavamail.api.email.EmailPopulatingBuilder;
import org.simplejavamail.api.mailer.Mailer;
import org.simplejavamail.api.mailer.config.TransportStrategy;
import org.simplejavamail.email.EmailBuilder;
import org.simplejavamail.mailer.MailerBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmailUtil {
    private static final Logger LOG = LoggerFactory.getLogger(EmailUtil.class);
    public static final String USERNAME = "userName";
    public static final String ENTITY = "entity";
    public static final String SUPPORT_URL = "supportUrl";
    public static final String EMAIL_TEMPLATE_BASEPATH = "/emailTemplates";
    private static final String EMAIL_VERIFICATION_SUBJECT = "%s: Verify your Email Address (Action Required)";
    public static final String EMAIL_VERIFICATION_LINKKEY = "userEmailTokenVerificationLink";
    public static final String EMAIL_VERIFICATION_TEMPLATE_PATH = "email-verification.ftl";
    private static final String PASSWORD_RESET_SUBJECT = "%s: Reset your Password";
    public static final String PASSWORD_RESET_LINKKEY = "userResetPasswordLink";
    public static final String EXPIRATION_TIME_KEY = "expirationTime";
    public static final String DEFAULT_EXPIRATION_TIME = "60";
    public static final String PASSWORD = "password";
    public static final String APPLICATION_LOGIN_LINK = "applicationLoginLink";
    public static final String PASSWORD_RESET_TEMPLATE_FILE = "reset-link.ftl";
    private static final String ACCOUNT_STATUS_SUBJECT = "%s: Change in Account Status";
    public static final String ACTION_KEY = "action";
    public static final String ACTION_STATUS_KEY = "actionStatus";
    public static final String ACCOUNT_STATUS_TEMPLATE_FILE = "account-activity-change.ftl";
    private static final String INVITE_SUBJECT = "Welcome to %s";
    private static final String CHANGE_EVENT_UPDATE = "Change Event Update from %s";
    private static final String TASK_SUBJECT = "%s : Task Assignment Notification";
    private static final String TEST_SUBJECT = "%s : Test Result Notification";
    public static final String INVITE_RANDOM_PWD = "invite-randompwd.ftl";
    public static final String CHANGE_EVENT_TEMPLATE = "changeEvent.ftl";
    public static final String INVITE_CREATE_PWD = "invite-createPassword.ftl";
    public static final String TASK_NOTIFICATION_TEMPLATE = "taskAssignment.ftl";
    public static final String TEST_NOTIFICATION_TEMPLATE = "testResultStatus.ftl";
    private static final String REPORT_SUBJECT = "%s: Data Insights Weekly - %s";
    public static final String DATA_INSIGHT_REPORT_TEMPLATE = "dataInsightReport.ftl";
    private static EmailUtil INSTANCE;
    private static SmtpSettings STORED_SMTP_SETTINGS;
    private static Mailer MAILER;
    private static Configuration TEMPLATE_CONFIGURATION;

    private EmailUtil() {
        try {
            STORED_SMTP_SETTINGS = EmailUtil.getSmtpSettings();
            MAILER = EmailUtil.createMailer(STORED_SMTP_SETTINGS);
            TEMPLATE_CONFIGURATION = new Configuration(Configuration.VERSION_2_3_28);
            LOG.info("Email Util cache is initialized");
        }
        catch (Exception ex) {
            LOG.warn("[MAILER] Smtp Configurations are missing : Reason {} ", (Object)ex.getMessage(), (Object)ex);
        }
    }

    private static Mailer createMailer(SmtpSettings smtpServerSettings) {
        if (Boolean.TRUE.equals(smtpServerSettings.getEnableSmtpServer())) {
            TransportStrategy strategy;
            switch (smtpServerSettings.getTransportationStrategy()) {
                case SMTPS: {
                    strategy = TransportStrategy.SMTPS;
                    break;
                }
                case SMTP_TLS: {
                    strategy = TransportStrategy.SMTP_TLS;
                    break;
                }
                default: {
                    strategy = TransportStrategy.SMTP;
                }
            }
            return MailerBuilder.withSMTPServer((String)smtpServerSettings.getServerEndpoint(), (Integer)smtpServerSettings.getServerPort(), (String)smtpServerSettings.getUsername(), (String)smtpServerSettings.getPassword()).withTransportStrategy(strategy).buildMailer();
        }
        return null;
    }

    public static EmailUtil getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new EmailUtil();
        }
        return INSTANCE;
    }

    public void sendAccountStatus(User user, String action, String status) throws IOException, TemplateException {
        if (Boolean.TRUE.equals(EmailUtil.getSmtpSettings().getEnableSmtpServer())) {
            HashMap<String, Object> templatePopulator = new HashMap<String, Object>();
            templatePopulator.put(ENTITY, this.getEmailingEntity());
            templatePopulator.put(SUPPORT_URL, this.getSupportUrl());
            templatePopulator.put(USERNAME, user.getName());
            templatePopulator.put(ACTION_KEY, action);
            templatePopulator.put(ACTION_STATUS_KEY, status);
            this.sendMail(this.getAccountStatusChangeSubject(), templatePopulator, user.getEmail(), EMAIL_TEMPLATE_BASEPATH, ACCOUNT_STATUS_TEMPLATE_FILE);
        }
    }

    public void sendEmailVerification(String emailVerificationLink, User user) throws IOException, TemplateException {
        if (Boolean.TRUE.equals(EmailUtil.getSmtpSettings().getEnableSmtpServer())) {
            HashMap<String, Object> templatePopulator = new HashMap<String, Object>();
            templatePopulator.put(ENTITY, this.getEmailingEntity());
            templatePopulator.put(SUPPORT_URL, this.getSupportUrl());
            templatePopulator.put(USERNAME, user.getName());
            templatePopulator.put(EMAIL_VERIFICATION_LINKKEY, emailVerificationLink);
            templatePopulator.put(EXPIRATION_TIME_KEY, "24");
            this.sendMail(this.getEmailVerificationSubject(), templatePopulator, user.getEmail(), EMAIL_TEMPLATE_BASEPATH, EMAIL_VERIFICATION_TEMPLATE_PATH);
        }
    }

    public void sendPasswordResetLink(String passwordResetLink, User user, String subject, String templateFilePath) throws IOException, TemplateException {
        if (Boolean.TRUE.equals(EmailUtil.getSmtpSettings().getEnableSmtpServer())) {
            HashMap<String, Object> templatePopulator = new HashMap<String, Object>();
            templatePopulator.put(ENTITY, this.getEmailingEntity());
            templatePopulator.put(SUPPORT_URL, this.getSupportUrl());
            templatePopulator.put(USERNAME, user.getName());
            templatePopulator.put(PASSWORD_RESET_LINKKEY, passwordResetLink);
            templatePopulator.put(EXPIRATION_TIME_KEY, DEFAULT_EXPIRATION_TIME);
            this.sendMail(subject, templatePopulator, user.getEmail(), EMAIL_TEMPLATE_BASEPATH, templateFilePath);
        }
    }

    public void sendTaskAssignmentNotificationToUser(String assigneeName, String email, String taskLink, Thread thread, String subject, String templateFilePath) throws IOException, TemplateException {
        if (Boolean.TRUE.equals(EmailUtil.getSmtpSettings().getEnableSmtpServer())) {
            HashMap<String, Object> templatePopulator = new HashMap<String, Object>();
            templatePopulator.put("assignee", assigneeName);
            templatePopulator.put("createdBy", thread.getCreatedBy());
            templatePopulator.put("taskName", thread.getMessage());
            templatePopulator.put("taskStatus", thread.getTask().getStatus().toString());
            templatePopulator.put("taskType", thread.getTask().getType().toString());
            templatePopulator.put("fieldOldValue", thread.getTask().getOldValue());
            templatePopulator.put("fieldNewValue", thread.getTask().getSuggestion());
            templatePopulator.put("taskLink", taskLink);
            this.sendMail(subject, templatePopulator, email, EMAIL_TEMPLATE_BASEPATH, templateFilePath);
        }
    }

    public void sendTestResultEmailNotificationToUser(String email, String testResultLink, String testCaseName, TestCaseResult result, String subject, String templateFilePath) throws IOException, TemplateException {
        if (Boolean.TRUE.equals(EmailUtil.getSmtpSettings().getEnableSmtpServer())) {
            HashMap<String, Object> templatePopulator = new HashMap<String, Object>();
            templatePopulator.put("receiverName", email.split("@")[0]);
            templatePopulator.put("testResultName", testCaseName);
            templatePopulator.put("testResultDescription", result.getResult());
            templatePopulator.put("testResultStatus", result.getTestCaseStatus().toString());
            templatePopulator.put("testResultTimestamp", result.getTimestamp().toString());
            templatePopulator.put("testResultLink", testResultLink);
            this.sendMail(subject, templatePopulator, email, EMAIL_TEMPLATE_BASEPATH, templateFilePath);
        }
    }

    public void sendMail(String subject, Map<String, Object> model, String to, String baseTemplatePackage, String templatePath) throws IOException, TemplateException {
        if (Boolean.TRUE.equals(EmailUtil.getSmtpSettings().getEnableSmtpServer())) {
            EmailPopulatingBuilder emailBuilder = EmailBuilder.startingBlank();
            emailBuilder.withSubject(subject);
            emailBuilder.to(to);
            emailBuilder.from(EmailUtil.getSmtpSettings().getSenderMail());
            TEMPLATE_CONFIGURATION.setClassForTemplateLoading(this.getClass(), baseTemplatePackage);
            Template template = TEMPLATE_CONFIGURATION.getTemplate(templatePath);
            StringWriter stringWriter = new StringWriter();
            template.process(model, (Writer)stringWriter);
            String mailContent = stringWriter.toString();
            emailBuilder.withHTMLText(mailContent);
            this.sendMail(emailBuilder.buildEmail());
        }
    }

    public void sendMailToMultiple(String subject, Map<String, Object> model, Set<String> to, String baseTemplatePackage, String templatePath) throws IOException, TemplateException {
        if (Boolean.TRUE.equals(EmailUtil.getSmtpSettings().getEnableSmtpServer())) {
            EmailPopulatingBuilder emailBuilder = EmailBuilder.startingBlank();
            emailBuilder.withSubject(subject);
            emailBuilder.toMultiple(to);
            emailBuilder.from(EmailUtil.getSmtpSettings().getSenderMail());
            TEMPLATE_CONFIGURATION.setClassForTemplateLoading(this.getClass(), baseTemplatePackage);
            Template template = TEMPLATE_CONFIGURATION.getTemplate(templatePath);
            StringWriter stringWriter = new StringWriter();
            template.process(model, (Writer)stringWriter);
            String mailContent = stringWriter.toString();
            emailBuilder.withHTMLText(mailContent);
            this.sendMail(emailBuilder.buildEmail());
        }
    }

    public void sendMail(Email email) {
        if (MAILER != null && EmailUtil.getSmtpSettings().getEnableSmtpServer().booleanValue()) {
            MAILER.sendMail(email, true);
        }
    }

    public String buildBaseUrl(URI uri) {
        try {
            if (CommonUtil.nullOrEmpty((String)EmailUtil.getSmtpSettings().getOpenMetadataUrl())) {
                return String.format("%s://%s", uri.getScheme(), uri.getHost());
            }
            URI serverUrl = new URI(EmailUtil.getSmtpSettings().getOpenMetadataUrl());
            return String.format("%s://%s", serverUrl.getScheme(), serverUrl.getHost());
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("Missing URI info from URI and SMTP settings.");
        }
    }

    public static void sendInviteMailToAdmin(User user, String pwd) {
        if (Boolean.TRUE.equals(EmailUtil.getSmtpSettings().getEnableSmtpServer())) {
            HashMap<String, Object> templatePopulator = new HashMap<String, Object>();
            templatePopulator.put(ENTITY, EmailUtil.getInstance().getEmailingEntity());
            templatePopulator.put(SUPPORT_URL, EmailUtil.getInstance().getSupportUrl());
            templatePopulator.put(USERNAME, user.getName());
            templatePopulator.put(PASSWORD, pwd);
            templatePopulator.put(APPLICATION_LOGIN_LINK, EmailUtil.getInstance().getOMUrl());
            try {
                EmailUtil.getInstance().sendMail(EmailUtil.getInstance().getEmailInviteSubject(), templatePopulator, user.getEmail(), EMAIL_TEMPLATE_BASEPATH, INVITE_RANDOM_PWD);
            }
            catch (Exception ex) {
                LOG.error("Failed in sending Mail to user [{}]. Reason : {}", (Object)user.getEmail(), (Object)ex.getMessage());
            }
        }
    }

    public static void sendChangeEventMail(String receiverMail, EmailMessage emailMessaged) {
        if (Boolean.TRUE.equals(EmailUtil.getSmtpSettings().getEnableSmtpServer())) {
            HashMap<String, Object> templatePopulator = new HashMap<String, Object>();
            templatePopulator.put(USERNAME, receiverMail.split("@")[0]);
            templatePopulator.put("updatedBy", emailMessaged.getUpdatedBy());
            templatePopulator.put("entityUrl", emailMessaged.getEntityUrl());
            StringBuilder buff = new StringBuilder();
            for (String cmessage : emailMessaged.getChangeMessage()) {
                buff.append(cmessage);
                buff.append("\n");
            }
            templatePopulator.put("changeMessage", buff.toString());
            try {
                EmailUtil.getInstance().sendMail(EmailUtil.getInstance().getChangeEventTemplate(), templatePopulator, receiverMail, EMAIL_TEMPLATE_BASEPATH, CHANGE_EVENT_TEMPLATE);
            }
            catch (Exception ex) {
                LOG.error("Failed in sending Mail to user [{}]. Reason : {}", (Object)receiverMail, (Object)ex.getMessage());
            }
        }
    }

    public void sendDataInsightEmailNotificationToUser(Set<String> emails, DataInsightTotalAssetTemplate totalAssetObj, DataInsightDescriptionAndOwnerTemplate descriptionObj, DataInsightDescriptionAndOwnerTemplate ownerShipObj, DataInsightDescriptionAndOwnerTemplate tierObj, String subject, String templateFilePath) throws IOException, TemplateException {
        if (Boolean.TRUE.equals(EmailUtil.getSmtpSettings().getEnableSmtpServer())) {
            HashMap<String, Object> templatePopulator = new HashMap<String, Object>();
            templatePopulator.put("totalAssetObj", totalAssetObj);
            templatePopulator.put("descriptionObj", descriptionObj);
            templatePopulator.put("ownershipObj", ownerShipObj);
            templatePopulator.put("tierObj", tierObj);
            this.sendMailToMultiple(subject, templatePopulator, emails, EMAIL_TEMPLATE_BASEPATH, templateFilePath);
        }
    }

    public void testConnection() {
        MAILER.testConnection();
    }

    private String getEmailVerificationSubject() {
        return String.format(EMAIL_VERIFICATION_SUBJECT, EmailUtil.getSmtpSettings().getEmailingEntity());
    }

    public String getPasswordResetSubject() {
        return String.format(PASSWORD_RESET_SUBJECT, EmailUtil.getSmtpSettings().getEmailingEntity());
    }

    private String getAccountStatusChangeSubject() {
        return String.format(ACCOUNT_STATUS_SUBJECT, EmailUtil.getSmtpSettings().getEmailingEntity());
    }

    public String getEmailInviteSubject() {
        return String.format(INVITE_SUBJECT, EmailUtil.getSmtpSettings().getEmailingEntity());
    }

    public String getChangeEventTemplate() {
        return String.format(CHANGE_EVENT_UPDATE, EmailUtil.getSmtpSettings().getEmailingEntity());
    }

    public String getTaskAssignmentSubject() {
        return String.format(TASK_SUBJECT, EmailUtil.getSmtpSettings().getEmailingEntity());
    }

    public String getTestResultSubject() {
        return String.format(TEST_SUBJECT, EmailUtil.getSmtpSettings().getEmailingEntity());
    }

    public String getDataInsightReportSubject() {
        return String.format(REPORT_SUBJECT, EmailUtil.getSmtpSettings().getEmailingEntity(), new SimpleDateFormat("dd-MM-yy").format(new Date()));
    }

    public String getEmailingEntity() {
        return EmailUtil.getSmtpSettings().getEmailingEntity();
    }

    public String getSupportUrl() {
        return EmailUtil.getSmtpSettings().getSupportUrl();
    }

    public String getOMUrl() {
        return EmailUtil.getSmtpSettings().getOpenMetadataUrl();
    }

    private static SmtpSettings getSmtpSettings() {
        SmtpSettings emailConfig = SettingsCache.getInstance().getSetting(SettingsType.EMAIL_CONFIGURATION, SmtpSettings.class);
        if (!emailConfig.equals((Object)STORED_SMTP_SETTINGS)) {
            STORED_SMTP_SETTINGS = emailConfig;
            MAILER = EmailUtil.createMailer(emailConfig);
        }
        return emailConfig;
    }
}

