/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.workflows.searchIndex;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.update.UpdateRequest;
import org.elasticsearch.common.xcontent.XContentType;
import org.openmetadata.common.utils.CommonUtil;
import org.openmetadata.schema.EntityInterface;
import org.openmetadata.schema.system.StepStats;
import org.openmetadata.service.elasticsearch.ElasticSearchIndexDefinition;
import org.openmetadata.service.elasticsearch.ElasticSearchIndexFactory;
import org.openmetadata.service.exception.ProcessorException;
import org.openmetadata.service.util.JsonUtils;
import org.openmetadata.service.util.ResultList;
import org.openmetadata.service.workflows.interfaces.Processor;
import org.openmetadata.service.workflows.searchIndex.ReindexingUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EsEntitiesProcessor
implements Processor<ResultList<? extends EntityInterface>, BulkRequest> {
    private static final Logger LOG = LoggerFactory.getLogger(EsEntitiesProcessor.class);
    private final StepStats stats = new StepStats();

    @Override
    public BulkRequest process(ResultList<? extends EntityInterface> input, Map<String, Object> contextData) throws ProcessorException {
        BulkRequest requests;
        String entityType = (String)contextData.get("entityType");
        if (CommonUtil.nullOrEmpty((String)entityType)) {
            throw new IllegalArgumentException("[EsEntitiesProcessor] entityType cannot be null or empty.");
        }
        LOG.debug("[EsEntitiesProcessor] Processing a Batch of Size: {}, EntityType: {} ", (Object)input.getData().size(), (Object)entityType);
        try {
            requests = this.buildBulkRequests(entityType, input.getData());
            LOG.debug("[EsEntitiesProcessor] Batch Stats :- Submitted : {} Success: {} Failed: {}", new Object[]{input.getData().size(), input.getData().size(), 0});
            this.updateStats(input.getData().size(), 0);
        }
        catch (JsonProcessingException e) {
            LOG.debug("[EsEntitiesProcessor] Batch Stats :- Submitted : {} Success: {} Failed: {}", new Object[]{input.getData().size(), 0, input.getData().size()});
            this.updateStats(0, input.getData().size());
            throw new ProcessorException("[EsEntitiesProcessor] Batch encountered Exception. Failing Completely.", e);
        }
        return requests;
    }

    private BulkRequest buildBulkRequests(String entityType, List<? extends EntityInterface> entities) throws JsonProcessingException {
        BulkRequest bulkRequests = new BulkRequest();
        for (EntityInterface entityInterface : entities) {
            UpdateRequest request = EsEntitiesProcessor.getUpdateRequest(entityType, entityInterface);
            bulkRequests.add(request);
        }
        return bulkRequests;
    }

    public static UpdateRequest getUpdateRequest(String entityType, EntityInterface entity) throws JsonProcessingException {
        ElasticSearchIndexDefinition.ElasticSearchIndexType indexType = ElasticSearchIndexDefinition.getIndexMappingByEntityType(entityType);
        UpdateRequest updateRequest = new UpdateRequest(indexType.indexName, entity.getId().toString());
        updateRequest.doc(JsonUtils.pojoToJson(Objects.requireNonNull(ElasticSearchIndexFactory.buildIndex(entityType, entity)).buildESDoc()), XContentType.JSON);
        updateRequest.docAsUpsert(true);
        return updateRequest;
    }

    @Override
    public void updateStats(int currentSuccess, int currentFailed) {
        ReindexingUtil.getUpdatedStats(this.stats, currentSuccess, currentFailed);
    }

    @Override
    public StepStats getStats() {
        return this.stats;
    }
}

