/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.elasticsearch;

import java.io.IOException;
import java.io.InputStream;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.json.JSONObject;
import org.openmetadata.schema.service.configuration.elasticsearch.ElasticSearchConfiguration;
import org.openmetadata.schema.type.IndexMappingLanguage;
import org.openmetadata.service.Entity;
import org.openmetadata.service.events.errors.EventPublisherException;
import org.openmetadata.service.jdbi3.CollectionDAO;
import org.openmetadata.service.search.SearchClient;
import org.openmetadata.service.workflows.searchIndex.ReindexingUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElasticSearchIndexDefinition {
    private static final Logger LOG = LoggerFactory.getLogger(ElasticSearchIndexDefinition.class);
    private static final String MAPPINGS_KEY = "mappings";
    private static final String PROPERTIES_KEY = "properties";
    public static final String ENTITY_REPORT_DATA = "entityReportData";
    public static final String WEB_ANALYTIC_ENTITY_VIEW_REPORT_DATA = "webAnalyticEntityViewReportData";
    public static final String WEB_ANALYTIC_USER_ACTIVITY_REPORT_DATA = "webAnalyticUserActivityReportData";
    private final CollectionDAO dao;
    final EnumMap<ElasticSearchIndexType, ElasticSearchIndexStatus> elasticSearchIndexes = new EnumMap(ElasticSearchIndexType.class);
    public static final Map<String, Object> ENTITY_TO_MAPPING_SCHEMA_MAP = new HashMap<String, Object>();
    protected static final Map<String, String> ENTITY_TYPE_TO_INDEX_MAP;
    private static final Map<ElasticSearchIndexType, Set<String>> INDEX_TO_MAPPING_FIELDS_MAP;
    private SearchClient searchClient;

    public ElasticSearchIndexDefinition(SearchClient client, CollectionDAO dao) {
        this.dao = dao;
        this.searchClient = client;
        for (ElasticSearchIndexType elasticSearchIndexType : ElasticSearchIndexType.values()) {
            this.elasticSearchIndexes.put(elasticSearchIndexType, ElasticSearchIndexStatus.NOT_CREATED);
        }
    }

    public void createIndexes(ElasticSearchConfiguration esConfig) {
        for (ElasticSearchIndexType elasticSearchIndexType : ElasticSearchIndexType.values()) {
            this.searchClient.createIndex(elasticSearchIndexType, esConfig.getSearchIndexMappingLanguage().value());
        }
    }

    public void updateIndexes(ElasticSearchConfiguration esConfig) {
        for (ElasticSearchIndexType elasticSearchIndexType : ElasticSearchIndexType.values()) {
            this.searchClient.updateIndex(elasticSearchIndexType, esConfig.getSearchIndexMappingLanguage().value());
        }
    }

    public void dropIndexes() {
        for (ElasticSearchIndexType elasticSearchIndexType : ElasticSearchIndexType.values()) {
            this.searchClient.deleteIndex(elasticSearchIndexType);
        }
    }

    public static String getIndexMapping(ElasticSearchIndexType elasticSearchIndexType, String lang) throws IOException {
        try (InputStream in = ElasticSearchIndexDefinition.class.getResourceAsStream(String.format(elasticSearchIndexType.indexMappingFile, lang.toLowerCase()));){
            assert (in != null);
            String string = new String(in.readAllBytes());
            return string;
        }
    }

    private static void populateEsFieldsForIndexes(ElasticSearchIndexType elasticSearchIndexType, IndexMappingLanguage lang) {
        if (!ReindexingUtil.isDataInsightIndex(elasticSearchIndexType.entityType)) {
            String indexData = ElasticSearchIndexDefinition.getIndexMapping(elasticSearchIndexType, lang.value());
            JSONObject object = new JSONObject(indexData).getJSONObject(MAPPINGS_KEY).getJSONObject(PROPERTIES_KEY);
            Set<String> keySet = Entity.getEntityRepository(elasticSearchIndexType.entityType).getCommonFields(object.keySet());
            INDEX_TO_MAPPING_FIELDS_MAP.put(elasticSearchIndexType, keySet);
        }
    }

    public static ElasticSearchIndexType getIndexMappingByEntityType(String type) {
        if (type.equalsIgnoreCase("table")) {
            return ElasticSearchIndexType.TABLE_SEARCH_INDEX;
        }
        if (type.equalsIgnoreCase("dashboard")) {
            return ElasticSearchIndexType.DASHBOARD_SEARCH_INDEX;
        }
        if (type.equalsIgnoreCase("pipeline")) {
            return ElasticSearchIndexType.PIPELINE_SEARCH_INDEX;
        }
        if (type.equalsIgnoreCase("topic")) {
            return ElasticSearchIndexType.TOPIC_SEARCH_INDEX;
        }
        if (type.equalsIgnoreCase("user")) {
            return ElasticSearchIndexType.USER_SEARCH_INDEX;
        }
        if (type.equalsIgnoreCase("team")) {
            return ElasticSearchIndexType.TEAM_SEARCH_INDEX;
        }
        if (type.equalsIgnoreCase("glossary")) {
            return ElasticSearchIndexType.GLOSSARY_SEARCH_INDEX;
        }
        if (type.equalsIgnoreCase("mlmodel")) {
            return ElasticSearchIndexType.MLMODEL_SEARCH_INDEX;
        }
        if (type.equalsIgnoreCase("glossaryTerm")) {
            return ElasticSearchIndexType.GLOSSARY_SEARCH_INDEX;
        }
        if (type.equalsIgnoreCase("tag")) {
            return ElasticSearchIndexType.TAG_SEARCH_INDEX;
        }
        if (type.equalsIgnoreCase(ENTITY_REPORT_DATA)) {
            return ElasticSearchIndexType.ENTITY_REPORT_DATA_INDEX;
        }
        if (type.equalsIgnoreCase(WEB_ANALYTIC_ENTITY_VIEW_REPORT_DATA)) {
            return ElasticSearchIndexType.WEB_ANALYTIC_ENTITY_VIEW_REPORT_DATA_INDEX;
        }
        if (type.equalsIgnoreCase(WEB_ANALYTIC_USER_ACTIVITY_REPORT_DATA)) {
            return ElasticSearchIndexType.WEB_ANALYTIC_USER_ACTIVITY_REPORT_DATA_INDEX;
        }
        if (type.equalsIgnoreCase("container")) {
            return ElasticSearchIndexType.CONTAINER_SEARCH_INDEX;
        }
        if (type.equalsIgnoreCase("query")) {
            return ElasticSearchIndexType.QUERY_SEARCH_INDEX;
        }
        if (type.equalsIgnoreCase("testSuite") || type.equalsIgnoreCase("testCase")) {
            return ElasticSearchIndexType.TEST_CASE_SEARCH_INDEX;
        }
        throw new EventPublisherException("Failed to find index doc for type " + type);
    }

    public static Set<String> getIndexFields(String entityType, IndexMappingLanguage lang) {
        Set<String> fields = INDEX_TO_MAPPING_FIELDS_MAP.get((Object)ElasticSearchIndexDefinition.getIndexMappingByEntityType(entityType));
        if (fields != null) {
            return fields;
        }
        ElasticSearchIndexDefinition.populateEsFieldsForIndexes(ElasticSearchIndexDefinition.getIndexMappingByEntityType(entityType), lang);
        fields = INDEX_TO_MAPPING_FIELDS_MAP.get((Object)ElasticSearchIndexDefinition.getIndexMappingByEntityType(entityType));
        return fields;
    }

    public static Map<String, Object> getIndexMappingSchema(Set<String> entities) {
        if (entities.contains("*")) {
            return ENTITY_TO_MAPPING_SCHEMA_MAP;
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        entities.forEach(entityType -> result.put((String)entityType, ENTITY_TO_MAPPING_SCHEMA_MAP.get(entityType)));
        return result;
    }

    static {
        INDEX_TO_MAPPING_FIELDS_MAP = new EnumMap<ElasticSearchIndexType, Set<String>>(ElasticSearchIndexType.class);
        ENTITY_TYPE_TO_INDEX_MAP = new HashMap<String, String>();
        for (ElasticSearchIndexType elasticSearchIndexType : ElasticSearchIndexType.values()) {
            ENTITY_TYPE_TO_INDEX_MAP.put(elasticSearchIndexType.entityType, elasticSearchIndexType.indexName);
        }
    }

    public static enum ElasticSearchIndexType {
        TABLE_SEARCH_INDEX("table", "table_search_index", "/elasticsearch/%s/table_index_mapping.json"),
        TOPIC_SEARCH_INDEX("topic", "topic_search_index", "/elasticsearch/%s/topic_index_mapping.json"),
        DASHBOARD_SEARCH_INDEX("dashboard", "dashboard_search_index", "/elasticsearch/%s/dashboard_index_mapping.json"),
        PIPELINE_SEARCH_INDEX("pipeline", "pipeline_search_index", "/elasticsearch/%s/pipeline_index_mapping.json"),
        USER_SEARCH_INDEX("user", "user_search_index", "/elasticsearch/%s/user_index_mapping.json"),
        TEAM_SEARCH_INDEX("team", "team_search_index", "/elasticsearch/%s/team_index_mapping.json"),
        GLOSSARY_SEARCH_INDEX("glossary", "glossary_search_index", "/elasticsearch/%s/glossary_index_mapping.json"),
        MLMODEL_SEARCH_INDEX("mlmodel", "mlmodel_search_index", "/elasticsearch/%s/mlmodel_index_mapping.json"),
        CONTAINER_SEARCH_INDEX("container", "container_search_index", "/elasticsearch/%s/container_index_mapping.json"),
        QUERY_SEARCH_INDEX("query", "query_search_index", "/elasticsearch/%s/query_index_mapping.json"),
        TAG_SEARCH_INDEX("tag", "tag_search_index", "/elasticsearch/%s/tag_index_mapping.json"),
        ENTITY_REPORT_DATA_INDEX("entityReportData", "entity_report_data_index", "/elasticsearch/entity_report_data_index.json"),
        TEST_CASE_SEARCH_INDEX("testCase", "test_case_search_index", "/elasticsearch/%s/test_case_index_mapping.json"),
        WEB_ANALYTIC_ENTITY_VIEW_REPORT_DATA_INDEX("webAnalyticEvent", "web_analytic_entity_view_report_data_index", "/elasticsearch/web_analytic_entity_view_report_data_index.json"),
        WEB_ANALYTIC_USER_ACTIVITY_REPORT_DATA_INDEX("webAnalyticUserActivityReportData", "web_analytic_user_activity_report_data_index", "/elasticsearch/web_analytic_user_activity_report_data_index.json");

        public final String indexName;
        public final String indexMappingFile;
        public final String entityType;

        private ElasticSearchIndexType(String entityType, String indexName, String indexMappingFile) {
            this.entityType = entityType;
            this.indexName = indexName;
            this.indexMappingFile = indexMappingFile;
        }
    }

    public static enum ElasticSearchIndexStatus {
        CREATED,
        NOT_CREATED,
        FAILED;

    }
}

