/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.elasticsearch;

import org.openmetadata.schema.entity.classification.Tag;
import org.openmetadata.schema.entity.data.Container;
import org.openmetadata.schema.entity.data.Dashboard;
import org.openmetadata.schema.entity.data.GlossaryTerm;
import org.openmetadata.schema.entity.data.MlModel;
import org.openmetadata.schema.entity.data.Pipeline;
import org.openmetadata.schema.entity.data.Query;
import org.openmetadata.schema.entity.data.Table;
import org.openmetadata.schema.entity.data.Topic;
import org.openmetadata.schema.entity.teams.Team;
import org.openmetadata.schema.entity.teams.User;
import org.openmetadata.schema.tests.TestCase;
import org.openmetadata.service.elasticsearch.TestCaseIndex;
import org.openmetadata.service.elasticsearch.indexes.ContainerIndex;
import org.openmetadata.service.elasticsearch.indexes.DashboardIndex;
import org.openmetadata.service.elasticsearch.indexes.ElasticSearchIndex;
import org.openmetadata.service.elasticsearch.indexes.GlossaryTermIndex;
import org.openmetadata.service.elasticsearch.indexes.MlModelIndex;
import org.openmetadata.service.elasticsearch.indexes.PipelineIndex;
import org.openmetadata.service.elasticsearch.indexes.QueryIndex;
import org.openmetadata.service.elasticsearch.indexes.TableIndex;
import org.openmetadata.service.elasticsearch.indexes.TagIndex;
import org.openmetadata.service.elasticsearch.indexes.TeamIndex;
import org.openmetadata.service.elasticsearch.indexes.TopicIndex;
import org.openmetadata.service.elasticsearch.indexes.UserIndex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElasticSearchIndexFactory {
    private static final Logger LOG = LoggerFactory.getLogger(ElasticSearchIndexFactory.class);

    private ElasticSearchIndexFactory() {
    }

    public static ElasticSearchIndex buildIndex(String entityType, Object entity) {
        switch (entityType) {
            case "table": {
                return new TableIndex((Table)entity);
            }
            case "dashboard": {
                return new DashboardIndex((Dashboard)entity);
            }
            case "topic": {
                return new TopicIndex((Topic)entity);
            }
            case "pipeline": {
                return new PipelineIndex((Pipeline)entity);
            }
            case "user": {
                return new UserIndex((User)entity);
            }
            case "team": {
                return new TeamIndex((Team)entity);
            }
            case "glossaryTerm": {
                return new GlossaryTermIndex((GlossaryTerm)entity);
            }
            case "mlmodel": {
                return new MlModelIndex((MlModel)entity);
            }
            case "tag": {
                return new TagIndex((Tag)entity);
            }
            case "query": {
                return new QueryIndex((Query)entity);
            }
            case "container": {
                return new ContainerIndex((Container)entity);
            }
            case "testCase": 
            case "testSuite": {
                return new TestCaseIndex((TestCase)entity);
            }
        }
        LOG.warn("Ignoring Entity Type {}", (Object)entityType);
        throw new IllegalArgumentException(String.format("Entity Type [%s] is not valid for Index Factory", entityType));
    }
}

