/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.elasticsearch;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import java.util.UUID;
import org.openmetadata.schema.tests.TestCase;
import org.openmetadata.schema.tests.TestSuite;
import org.openmetadata.schema.type.EntityReference;
import org.openmetadata.schema.type.Include;
import org.openmetadata.service.Entity;
import org.openmetadata.service.elasticsearch.indexes.ElasticSearchIndex;
import org.openmetadata.service.util.JsonUtils;

public class TestCaseIndex
implements ElasticSearchIndex {
    TestCase testCase;

    public TestCaseIndex(TestCase testCase) {
        this.testCase = testCase;
    }

    @Override
    public Map<String, Object> buildESDoc() {
        Map<String, Object> doc = JsonUtils.getMap(this.testCase);
        return doc;
    }

    public Map<String, Object> buildESDocForCreate() throws IOException {
        EntityReference testSuiteEntityReference = this.testCase.getTestSuite();
        TestSuite testSuite = this.getTestSuite(testSuiteEntityReference.getId());
        ArrayList<TestSuite> testSuiteArray = new ArrayList<TestSuite>();
        testSuiteArray.add(testSuite);
        Map<String, Object> doc = JsonUtils.getMap(this.testCase);
        doc.put("testSuites", testSuiteArray);
        return doc;
    }

    private TestSuite getTestSuite(UUID testSuiteId) throws IOException {
        TestSuite testSuite = (TestSuite)Entity.getEntity("testSuite", testSuiteId, "", Include.ALL);
        return new TestSuite().withId(testSuite.getId()).withName(testSuite.getName()).withDisplayName(testSuite.getDisplayName()).withDescription(testSuite.getDescription()).withFullyQualifiedName(testSuite.getFullyQualifiedName()).withDeleted(testSuite.getDeleted()).withHref(testSuite.getHref()).withExecutable(testSuite.getExecutable());
    }
}

