/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.events.scheduled;

import io.github.resilience4j.retry.Retry;
import io.github.resilience4j.retry.RetryConfig;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.prometheus.PrometheusMeterRegistry;
import java.time.Duration;
import java.util.Map;
import java.util.function.Supplier;
import javax.ws.rs.core.Response;
import org.openmetadata.sdk.PipelineServiceClient;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PipelineServiceStatusJob
implements Job {
    private static final Logger LOG = LoggerFactory.getLogger(PipelineServiceStatusJob.class);
    private static final String HEALTHY_STATUS = "healthy";
    private static final String STATUS_KEY = "status";
    private static final String COUNTER_NAME = "pipelineServiceClientStatus.counter";
    private static final String UNHEALTHY_TAG_NAME = "unhealthy";
    private static final String CLUSTER_TAG_NAME = "clusterName";
    private static final Integer MAX_ATTEMPTS = 3;
    private static final Integer BACKOFF_TIME_SECONDS = 5;

    public void execute(JobExecutionContext jobExecutionContext) {
        PipelineServiceClient pipelineServiceClient = (PipelineServiceClient)jobExecutionContext.getJobDetail().getJobDataMap().get((Object)"pipelineServiceClient");
        PrometheusMeterRegistry meterRegistry = (PrometheusMeterRegistry)jobExecutionContext.getJobDetail().getJobDataMap().get((Object)"meterRegistry");
        String clusterName = (String)jobExecutionContext.getJobDetail().getJobDataMap().get((Object)CLUSTER_TAG_NAME);
        try {
            this.registerStatusMetric(pipelineServiceClient, meterRegistry, clusterName);
        }
        catch (Exception e) {
            LOG.error("[Pipeline Service Status Job] Failed in sending metric due to", (Throwable)e);
            this.publishUnhealthyCounter(meterRegistry, clusterName);
        }
    }

    private String getServiceStatus(PipelineServiceClient pipelineServiceClient) {
        RetryConfig retryConfig = RetryConfig.custom().maxAttempts(MAX_ATTEMPTS.intValue()).waitDuration(Duration.ofMillis((long)BACKOFF_TIME_SECONDS.intValue() * 1000L)).retryOnResult(response -> !HEALTHY_STATUS.equals(response)).failAfterMaxAttempts(false).build();
        Retry retry = Retry.of((String)"getServiceStatus", (RetryConfig)retryConfig);
        Supplier<String> responseSupplier = () -> {
            try {
                Response response = pipelineServiceClient.getServiceStatus();
                Map responseMap = (Map)response.getEntity();
                return responseMap.get(STATUS_KEY) == null ? UNHEALTHY_TAG_NAME : (String)responseMap.get(STATUS_KEY);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        };
        return (String)retry.executeSupplier(responseSupplier);
    }

    private void registerStatusMetric(PipelineServiceClient pipelineServiceClient, PrometheusMeterRegistry meterRegistry, String clusterName) {
        String status = this.getServiceStatus(pipelineServiceClient);
        if (!HEALTHY_STATUS.equals(status)) {
            this.publishUnhealthyCounter(meterRegistry, clusterName);
        }
    }

    private void publishUnhealthyCounter(PrometheusMeterRegistry meterRegistry, String clusterName) {
        Counter.builder((String)COUNTER_NAME).tags(new String[]{STATUS_KEY, UNHEALTHY_TAG_NAME, CLUSTER_TAG_NAME, clusterName}).register((MeterRegistry)meterRegistry).increment();
    }
}

