/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.formatter.entity;

import java.util.List;
import org.openmetadata.schema.EntityInterface;
import org.openmetadata.schema.entity.data.Query;
import org.openmetadata.schema.type.EntityReference;
import org.openmetadata.schema.type.FieldChange;
import org.openmetadata.service.formatter.decorators.MessageDecorator;
import org.openmetadata.service.formatter.entity.EntityFormatter;
import org.openmetadata.service.formatter.util.FormatterUtil;

public class QueryFormatter
implements EntityFormatter {
    private static final String QUERY_USED_IN_FIELD = "queryUsedIn";

    @Override
    public String format(MessageDecorator<?> messageFormatter, FieldChange fieldChange, EntityInterface entity, FormatterUtil.CHANGE_TYPE changeType) {
        if (QUERY_USED_IN_FIELD.equals(fieldChange.getName())) {
            return this.transformQueryUsedIn(messageFormatter, fieldChange, entity, changeType);
        }
        return FormatterUtil.transformMessage(messageFormatter, fieldChange, entity, changeType);
    }

    private static String getFieldValue(Object fieldValue, EntityInterface entity, MessageDecorator<?> messageFormatter) {
        Query query = (Query)entity;
        StringBuilder field = new StringBuilder();
        List queryUsedIn = (List)fieldValue;
        field.append("for '").append(query.getQuery()).append("', ").append(messageFormatter.getLineBreak());
        field.append("Query Used in :- ");
        int i = 1;
        for (EntityReference queryUsage : queryUsedIn) {
            field.append(messageFormatter.getEntityUrl(queryUsage.getType(), queryUsage.getFullyQualifiedName()));
            if (i < queryUsedIn.size()) {
                field.append(", ");
            }
            ++i;
        }
        return field.toString();
    }

    private String transformQueryUsedIn(MessageDecorator<?> messageFormatter, FieldChange fieldChange, EntityInterface entity, FormatterUtil.CHANGE_TYPE changeType) {
        String newVal = QueryFormatter.getFieldValue(fieldChange.getNewValue(), entity, messageFormatter);
        String oldVal = QueryFormatter.getFieldValue(fieldChange.getOldValue(), entity, messageFormatter);
        return FormatterUtil.transformMessage(messageFormatter, new FieldChange().withNewValue((Object)newVal).withOldValue((Object)oldVal).withName(QUERY_USED_IN_FIELD), entity, changeType);
    }
}

